#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "xtiltype.h"
#include "normutil.h"
#include "changeref.h"

void rearrange(mod)
    struct module *mod;
{
    int i, j;
    int *ent;
    origintype o;
    keytype k;

#ifdef	DEBUG
    fprintf(stderr, "rearrange\n");
#endif

    ent = PSF_NMALLOC(int, mod->entries_table[MOD] + 1);
    for (i = 1; i <= MTABLE; i++) {
	if (i != PRM && i > DEF)
	    continue;
	for (j = 1; j <= mod->entries_table[MOD]; j++)
	    ent[j] = 0;
	for (j = 1; j <= mod->entries_table[i]; j++) {
	    if (!remove_tuple(mod, i, j)) {
		o = origin(mod, i, j);
		ent[o]++;
		k = origin_key(mod, i, j);
		if (ent[o] != k) {
		    changeref(mod, o, i, k, o, i, ent[o]);
		    switch (i) {
		    case SOR:
			mod->sor[j].k =
			    ent[o];
			break;
		    case FUN:
			mod->fun[j].k =
			    ent[o];
			break;
		    case ATM:
			mod->atm[j].k =
			    ent[o];
			break;
		    case PRO:
			mod->pro[j].k =
			    ent[o];
			break;
		    case SET:
			mod->set[j].k =
			    ent[o];
			break;
		    case COM:
			mod->com[j].k =
			    ent[o];
			break;
		    case VAR:
			mod->var[j].k =
			    ent[o];
			break;
		    case EQU:
			mod->equ[j].k =
			    ent[o];
			break;
		    case DEF:
			mod->def[j].k =
			    ent[o];
			break;
		    case PRM:
			mod->par[j].k =
			    ent[o];
			break;
		    }
		}
	    }
	}
    }
}
