#include <stdio.h>
#include <assert.h>
#include "psf_prototype.h"
#include "xtiltype.h"
#include "ffutil.h"
#include "normutil.h"

keytype find_sort_key(mod, o, t, k)
    struct module *mod;
    origintype o;
    tabletype t;
    keytype k;
{
    int i;

    for (i = 1; i <= mod->entries_table[t]; i++) {
	if (t == SOR) {
	    if (mod->sor[i].o == o &&
		    mod->sor[i].k == k)
		return (i);
	} else if (t == SET) {
	    if (mod->set[i].o == o &&
		    mod->set[i].k == k)
		return (i);
	} else
	    assert(0);
    }

    return 0;			/* to shut up lint */
}

void print_ind_list(fp, mod, table, key)
    FILE *fp;
    struct module *mod;
    tabletype table;
    keytype key;
{
    struct indexlist *il;
    int i;
    char *name;
    keytype k;

    switch (table) {
    case FUN:
	il = &mod->fun[key].sor_indlist;
	break;
    case ATM:
	il = &mod->atm[key].sor_indlist;
	break;
    case PRO:
	il = &mod->pro[key].sor_indlist;
	break;
    default:
	return;
    }
    fprintf(fp, "(");
    for (i = 0; i < il->a; i++) {
	if (il->indlist[i].key == -1)
	    name = "?";
	else {
	    k = find_sort_key(mod, il->indlist[i].origin,
			      il->indlist[i].table, il->indlist[i].key);
	    name = get_buf_name(name_tuple(mod, il->indlist[i].table, k));
	}
	if (i)
	    fprintf(fp, "#%s", name);
	else
	    fprintf(fp, "%s", name);
    }
    fprintf(fp, ")");
}
