#include <stdio.h>
#include <stdlib.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "xtiltype.h"
#include "ffutil.h"
#include "normutil.h"
#include "readxtil.h"
#include "rememberbin.h"
#include "prlist.h"
#include "realkey.h"

static struct module *special_mod = NULL;
static int parameter_cmp = 0;

static tag get_tag(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    switch (table) {
    case SOR:
	return mod->sor[key].t;
    case FUN:
	return mod->fun[key].t;
    case ATM:
	return mod->atm[key].t;
    case PRO:
	return mod->pro[key].t;
    case SET:
	return mod->set[key].t;
    case COM:
	return mod->com[key].t;
    case VAR:
	return mod->var[key].t;
    case EQU:
	return mod->equ[key].t;
    case DEF:
	return mod->def[key].t;
    case PRM:
	return mod->par[key].t;
    default:
	PSF_ASSERT(0);
    }

    return 0;			/* to shut up lint */
}

char *name_tuple(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    switch (table) {
    case SOR:
	return (mod->sor[key].ff);
    case FUN:
	return (mod->fun[key].ff);
    case ATM:
	return (mod->atm[key].ff);
    case PRO:
	return (mod->pro[key].ff);
    case SET:
	return (mod->set[key].ff);
    case COM:
	return (mod->com[key].ff);
    case VAR:
	return (mod->var[key].ff);
    case EQU:
	return (mod->equ[key].ff);
    case DEF:
	return (mod->def[key].ff);
    case UND:
	return (mod->und[key].ff);
    case PRM:
	return (mod->par[key].ff);
    case MOD:
	return (mod->mod[key].ff);
    default:
	PSF_ASSERT(0);
    }

    return NULL;		/* to shut up lint */
}

origintype origin(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    switch (table) {
    case SOR:
	return (mod->sor[key].o);
    case FUN:
	return (mod->fun[key].o);
    case ATM:
	return (mod->atm[key].o);
    case PRO:
	return (mod->pro[key].o);
    case SET:
	return (mod->set[key].o);
    case COM:
	return (mod->com[key].o);
    case VAR:
	return (mod->var[key].o);
    case EQU:
	return (mod->equ[key].o);
    case DEF:
	return (mod->def[key].o);
    case PRM:
	return (mod->par[key].o);
    default:
	PSF_ASSERT(0);
    }

    return 0;			/* to shut up lint */
}

keytype origin_key(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    switch (table) {
    case SOR:
	return (mod->sor[key].k);
    case FUN:
	return (mod->fun[key].k);
    case ATM:
	return (mod->atm[key].k);
    case PRO:
	return (mod->pro[key].k);
    case SET:
	return (mod->set[key].k);
    case COM:
	return (mod->com[key].k);
    case VAR:
	return (mod->var[key].k);
    case EQU:
	return (mod->equ[key].k);
    case DEF:
	return (mod->def[key].k);
    case PRM:
	return (mod->par[key].k);

    default:
	PSF_ASSERT(0);
    }

    return 0;			/* to shut up lint */
}

bool local_tuple(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    tag t = get_tag(mod, table, key);

    return (t == LOCAL || t == IDLE || t == UNKNOWN);
}

bool import_tuple(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    tag t = get_tag(mod, table, key);

    return (t == IMPORTS);
}

bool export_tuple(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    tag t = get_tag(mod, table, key);

    return (t == EXPORTS || t == PARAMETER);
}

bool unknown_tuple(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    tag t = get_tag(mod, table, key);

    return (t == UNKNOWN);
}

bool parameter_tuple(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    tag t = get_tag(mod, table, key);

    return (t == PARAMETER);
}

bool delete_tuple(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    tag t = get_tag(mod, table, key);

    return (t == DELETE);
}

bool remove_tuple(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    tag t = get_tag(mod, table, key);

    return (t == IMPORTS || t == UNKNOWN || t == DELETE);
}

bool idle_tuple(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    tag t = get_tag(mod, table, key);

    return (t == IDLE);
}

bool not_wanted_from_other(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    tag t = get_tag(mod, table, key);

    return (t == IDLE || t == IMPORTS || t == DELETE ||
	    t == LOCAL || t == UNKNOWN);
}

bool not_wanted_from_same(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    tag t = get_tag(mod, table, key);

    return (t == IMPORTS || t == DELETE || t == UNKNOWN);
}

bool not_to_be_printed(mod, table, key)		/* was remove_tuples */
    struct module *mod;
    tabletype table;
    keytype key;
{
    tag t = get_tag(mod, table, key);

    return (t == IMPORTS || t == DELETE || t == UNKNOWN);
}

keytype find_real_key(mod, ind)
    struct module *mod;
    struct indextype *ind;
{
    int i;

    switch (ind->table) {
    case SOR:
	for (i = 1; i <= mod->entries_table[SOR]; i++)
	    if (mod->sor[i].o == ind->origin && mod->sor[i].k == ind->key)
		return (i);
	break;
    case FUN:
	for (i = 1; i <= mod->entries_table[FUN]; i++)
	    if (mod->fun[i].o == ind->origin && mod->fun[i].k == ind->key)
		return (i);
	break;
    case ATM:
	for (i = 1; i <= mod->entries_table[ATM]; i++)
	    if (mod->atm[i].o == ind->origin && mod->atm[i].k == ind->key)
		return (i);
	break;
    case PRO:
	for (i = 1; i <= mod->entries_table[PRO]; i++)
	    if (mod->pro[i].o == ind->origin && mod->pro[i].k == ind->key)
		return (i);
	break;
    case SET:
	for (i = 1; i <= mod->entries_table[SET]; i++)
	    if (mod->set[i].o == ind->origin && mod->set[i].k == ind->key)
		return (i);
	break;
    default:
	PSF_ASSERT(0);
    }

    PSF_ASSERT(0);
    return 0;			/* to shut up lint */
}

void set_special_cmp(mod)
    struct module *mod;
{
    special_mod = mod;
}

void reset_special_cmp()
{
    special_mod = 0;
}

bool index_equal(x, y)
    struct indextype *x;
    struct indextype *y;
{
    return x->origin == y->origin && x->table == y->table && x->key == y->key;
}

void set_parameter_cmp()
{
    parameter_cmp = 1;
}

void reset_parameter_cmp()
{
    parameter_cmp = 0;
}

static bool s_index_equal(mod, x, y)
    struct module *mod;
    struct indextype *x;
    struct indextype *y;
{
    keytype key_s, key_s2;
    struct indextype *bi;
    struct indextype *xs, *ys;

    if (x->key != y->key)
	if (x->key != -1 && y->key != -1) {
	    if (special_mod && (x->table == SET || y->table == SET)) {
		if (x->table == SET)
		    xs = &special_mod->set[find_sort_key(special_mod,
		       x->origin, SET, x->key)].ind;
		else
		    xs = x;
		if (y->table == SET)
		    ys = &special_mod->set[find_sort_key(special_mod,
		       y->origin, SET, y->key)].ind;
		else
		    ys = y;
		if (index_equal(xs, ys))
		    return (TRUE);
	    }
	    if (x->table != y->table)
		return (FALSE);
	    if ((bi = get_actual_object(y)) != NULL) {
		if (index_equal(bi, x))
		    return (TRUE);
	    } else if ((bi = get_actual_object(x)) != NULL) {
		if (index_equal(bi, y))
		    return (TRUE);
	    }
	    if (bi == NULL)
		bi = y;
	    key_s = cmp_tuples(mod, mod, bi-> table, bi->table,
			       find_real_key(mod, bi), (char *) NULL);
	    if (x->origin == origin(mod, bi->table, key_s) &&
		    x->key == origin_key(mod, bi->table, key_s))
		return (TRUE);
	    if (parameter_cmp) { /* don't know why this doesn't work in
			    all cases */
		    bi = x;
		    key_s2 = cmp_tuples(mod, mod, bi-> table, bi->table,
			       find_real_key(mod, bi), (char *) NULL);
		    if (origin(mod, bi->table, key_s2) ==
			    y->origin &&
			    origin_key(mod, bi->table, key_s2) ==
				    y->key)
			return (TRUE);
		    if (origin(mod, bi->table, key_s2) ==
			    origin(mod, bi->table, key_s) &&
			    origin_key(mod, bi->table, key_s2) ==
				    origin_key(mod, bi->table, key_s))
			return (TRUE);
	    }
	    return (FALSE);
	} else
	    return (TRUE);
    if (x->origin != y->origin || x->table != y->table) {
	if (special_mod && (x->table == SET || y->table == SET)) {
	    if (x->table == SET)
		xs = &special_mod->set[find_sort_key(special_mod,
		       x->origin, SET, x->key)].ind;
	    else
		xs = x;
	    if (y->table == SET)
		ys = &special_mod->set[find_sort_key(special_mod,
		       y->origin, SET, y->key)].ind;
	    else
		ys = y;
	    if (index_equal(xs, ys))
		return (TRUE);
	}
	if (parameter_cmp) {
	    if (x->table != y->table)
		return (FALSE);
	    if ((bi = get_actual_object(y)) != NULL) {
		if (index_equal(bi, x))
		    return (TRUE);
	    } else if ((bi = get_actual_object(x)) != NULL) {
		if (index_equal(bi, y))
		    return (TRUE);
	    }
	    if (bi == NULL)
		bi = y;
	    key_s = cmp_tuples(mod, mod, bi->table, bi->table,
			       find_real_key(mod, bi), (char *) NULL);
	    if (x->origin == origin(mod, bi->table, key_s) &&
		    x->key == origin_key(mod, bi->table, key_s))
		return (TRUE);
	}
	return (FALSE);
    }
    return(TRUE);
}

static bool indexlist_equal(mod, x, y)
    struct module *mod;
    struct indexlist *x;
    struct indexlist *y;
{
    int i;

    if (x->a != y->a)
	return (FALSE);
    for (i = 0; i < x->a; i++) {
	if (!s_index_equal(mod, &x->indlist[i], &y->indlist[i]))
	    return (FALSE);
    }
    return (TRUE);
}

static bool aet_not_equal(x, y)
    struct ae_term *x;
    struct ae_term *y;
{
    int i;

    if (!index_equal(&x->ind, &y->ind))
	return (TRUE);
    if (x->a != y->a)
	return (TRUE);
    for (i = 0; i < x->a; i++) {
	if (aet_not_equal(&x->ae_list[i], &y->ae_list[i]))
	    return (TRUE);
    }
    return (FALSE);
}

static bool proc_not_equal(mod, x, y)
    struct module *mod;
    struct process_expr *x;
    struct process_expr *y;
{
    int i;

    if (x->fun != y->fun)
	return (TRUE);
    switch (x->fun) {
    case AET:
	return (aet_not_equal(&x->proc_expr.pe2, &y->proc_expr.pe2));
    case SKP:
    case DLK:
	return (FALSE);
    case ALT:
    case SEQ:
    case PAR:
    case INTR:
    case DISR:
    case STAR:
    case SHARP:
	for (i = 0; i < x->proc_expr.pe3.a; i++)
	    if (proc_not_equal(mod, &x->proc_expr.pe3.pe[i],
				&y->proc_expr.pe3.pe[i]))
		return (TRUE);
	return (FALSE);
    case SUM:
    case MRG:
    case ENC:
    case HID:
	if (!index_equal(&x->proc_expr.pe1.ind, &y->proc_expr.pe1.ind))
	    return (TRUE);
	return (proc_not_equal(mod, x->proc_expr.pe1.pe, y->proc_expr.pe1.pe));

#ifndef NOIF
    case IF:
	if (aet_not_equal(&x->proc_expr.pe4.aex, &y->proc_expr.pe4.aex))
	    return (TRUE);
	if (aet_not_equal(&x->proc_expr.pe4.aey, &y->proc_expr.pe4.aey))
	    return (TRUE);
	return (proc_not_equal(mod, x->proc_expr.pe4.pe, y->proc_expr.pe4.pe));
#endif
    case PRIO:
	if (!indexlist_equal(mod, x->proc_expr.pe5.sets,
	    &y->proc_expr.pe5.sets))
	    return(TRUE);
	return (proc_not_equal(mod, x->proc_expr.pe5.pe, y->proc_expr.pe5.pe));
    default:
	PSF_ASSERT(0);
    }

    return FALSE;			/* to shut up lint */
}

static int equ_equal(x, y)
    equ_tuple *x;
    equ_tuple *y;
{
    int i;

    if (aet_not_equal(&x->aet1, &y->aet1))
	return (FALSE);
    if (aet_not_equal(&x->aet2, &y->aet2))
	return (FALSE);
    if (x->a != y->a)
	return (FALSE);
    for (i = 0; i < x->a; i++) {
	if (aet_not_equal(&x->guard[i].aet1, &y->guard[i].aet1))
	    return (FALSE);
	if (aet_not_equal(&x->guard[i].aet2, &y->guard[i].aet2))
	    return (FALSE);
    }
    return (TRUE);
}

static int def_equal(mod, x, y)
    struct module *mod;
    def_tuple *x;
    def_tuple *y;
{
    if (aet_not_equal(&x->ae_t, &y->ae_t))
	return (FALSE);
    if (proc_not_equal(mod, &x->p_expr, &y->p_expr))
	return (FALSE);
    return (TRUE);
}

int cmp_tuples(mod, im, table, imt, imk, rename)
    struct module *mod;
    struct module *im;
    tabletype table;
    tabletype imt;
    keytype imk;
    char *rename;
{
    return (next_cmp_tuples(mod, im, table, imt, imk, rename, 0));
}

int next_cmp_tuples(mod, im, table, imt, imk, rename, start)
    struct module *mod;
    struct module *im;
    tabletype table;
    tabletype imt;
    keytype imk;
    char *rename;
    int start;
{
    int i, j;
    bool found;
    char *name;
    origintype or;

    if (rename == NULL)
	name = name_tuple(im, imt, imk);
    else
	name = rename;
    or = origin(im, imt, imk);
    for (i = start + 1; i <= mod->entries_table[table]; i++) {
	if (remove_tuple(mod, table, i))
	    continue;
	if (mod != im && idle_tuple(mod, table, i))
	    continue;
	if (mod == im && table == imt && i == imk)
	    continue;
	if (mod != im && not_wanted_from_other(mod, table, i))
	    continue;
	if (mod == im && not_wanted_from_same(mod, table, i))
	    continue;

	switch (table) {
	case SOR:
	    found = name_equal(mod->sor[i].ff, name);
	    break;
	case FUN:
	    found = name_equal(mod->fun[i].ff, name) &&
		indexlist_equal(mod, &mod-> fun[i].sor_indlist,
		    &im->fun[imk].sor_indlist) &&
		    indexlist_equal(mod, &mod-> fun[i].return_list,
		    &im->fun[imk].return_list);
	    break;
	case ATM:
	    found = name_equal(mod->atm[i].ff, name) &&
		indexlist_equal(mod, &mod->atm[i].sor_indlist,
				imt == ATM ? &im->atm[imk].sor_indlist :
				     	     &im->pro[imk].sor_indlist);
	    break;
	case PRO:
	    found = name_equal(mod->pro[i].ff, name) &&
		indexlist_equal(mod, &mod->pro[i].sor_indlist,
				imt == ATM ? &im->atm[imk].sor_indlist :
				     	     &im->pro[imk].sor_indlist);
	    break;
	case SET:
	    if ((found = name_equal(mod->set[i].ff, name)) == 0)
		break;
            /*
             * Same name and origin but different type is not allowed
             * anymore (new origin-rule).
             * check_forbid has been made to detect this.
             */
	    if (imt == SOR)
		break;
	    if (parameter_cmp)
		break;    /* we have only a name to compare */
	    if (mod->set[i].ind.key == 0 && im->set[imk].ind.key == 0) {
		found = 1;
		break;
	    }
            if (!index_equal(&mod->set[i].ind, &im->set[imk].ind))
                /*
                 * I'm not sure if index_equal will do, or that we need
                 * some fancy stuff like there is in indexlist_equal
                 */
                found = 0;
	    break;
	case COM:
	    if (origin(mod, imt, i) != or) {
		found = FALSE;
		break;
	    }
	    for (j = 0, found = TRUE; j < 3 && found; j++)
		if (aet_not_equal(&mod->com[i].aet[j], &mod->com[imk].aet[j]))
		    found = FALSE;
	    break;
	case VAR:
	    if (origin(mod, imt, i) != or) {
		found = FALSE;
		break;
	    }
	    if (mod->var[imk].t != im->var[i].t) {
		found = FALSE;
		break;
	    }
	    found = name_equal(mod->var[i].ff, name) &&
		index_equal(&mod->var[i].ind, &mod->var[imk].ind);
	    break;
	case EQU:
	    if (origin(mod, imt, i) != or) {
		found = FALSE;
		break;
	    }
	    if (mod->equ[imk].t != im->equ[i].t) {
		found = FALSE;
		break;
	    }
	    found = name_equal(mod->equ[i].ff, name) &&
		equ_equal(&mod->equ[i], &mod->equ[imk]);
	    break;
	case DEF:
	    if (origin(mod, imt, i) != or) {
		found = FALSE;
		break;
	    }
	    if (mod->def[imk].t != im->def[i].t) {
		found = FALSE;
		break;
	    }
	    found = name_equal(mod->def[i].ff, name) &&
		def_equal(mod, &mod->def[i], &mod->def[imk]);
	    break;
	case PRM:
	    found = name_equal(mod->par[i].ff, name);
	    break;
	default:
	    PSF_ASSERT(0);
	}
	if (found)
	    return (i);
    }
    return (0);
}

static char *table_name[] = {
    "",
    "sort",
    "function",
    "atom",
    "process",
    "set",
    "communication",
    "variable",
    "equation",
    "definition",
    "parameter",
    "renaming",
    "binding",
    "import",
    "module",
    "undefined"
};

char *name_table(table)
    tabletype table;
{
    return (table_name[table]);
}

void mark_delete(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    switch (table) {
    case SOR:
	mod->sor[key].t = DELETE;
	break;
    case FUN:
	mod->fun[key].t = DELETE;
	break;
    case ATM:
	mod->atm[key].t = DELETE;
	break;
    case PRO:
	mod->pro[key].t = DELETE;
	break;
    case SET:
	mod->set[key].t = DELETE;
	break;
    case COM:
	mod->com[key].t = DELETE;
	break;
    case VAR:
	mod->var[key].t = DELETE;
	break;
    case EQU:
	mod->equ[key].t = DELETE;
	break;
    case DEF:
	mod->def[key].t = DELETE;
	break;
    case PRM:
	mod->par[key].t = DELETE;
	break;
    default:
	PSF_ASSERT(table ? 0 : 0);
    }
}

struct indextype *sort_of_item(mod, ind)
    struct module *mod;
    struct indextype *ind;
{
    keytype key;

    key = module_get_real_key(ind);
    switch (ind->table) {
    case SOR:
	return (ind);
    case FUN:
	return (sort_of_item(mod, mod-> fun[key].return_list.indlist));
    case SET:
	if (mod->set[key].ind.key == 0)
	    return (&mod->set[key].ind);
	else
	    return (sort_of_item(mod, &mod-> set[key].ind));
    case VAR:
	return (sort_of_item(mod, &mod->var[key].ind));
    default:
	PSF_ASSERT(0);
    }

    return 0;			/* to shut up lint */
}

int cmp_original_names(m1, t1, k1, m2, t2, k2)
struct module *m1;
tabletype t1;
keytype k1;
struct module *m2;
tabletype t2;
keytype k2;
{
    char *f1, *f2;

    if ((f1 = search_field("on", name_tuple(m1, t1, k1))) == NULL)
	f1 = name_tuple(m1, t1, k1);
    else
	f1 += 4;
    if ((f2 = search_field("on", name_tuple(m2, t2, k2))) == NULL)
	f2 = name_tuple(m2, t2, k2);
    else
	f2 += 4;
    for (; *f1 != ' ' && *f1 != '\0'; f1 ++, f2 ++) {
	if  (*f1 != *f2)
		return(*f1 - *f2);
    }
    return(*f1 - *f2);
}
