#include <stdio.h>
#include "psf_prototype.h"
#include "psf_fopen.h"
#include "psf_malloc.h"
#include "psf_standards.h"
#include "xtiltype.h"
#include "changeref.h"
#include "changerefpar.h"
#include "checkbind.h"
#include "checkclash.h"
#include "checkcomm.h"
#include "checktypes.h"
#include "checkforbid.h"
#include "error.h"
#include "ffutil.h"
#include "main.h"
#include "normutil.h"
#include "prlist.h"
#include "readxtil.h"
#include "realkey.h"
#include "rearrange.h"
#include "rememberbin.h"
#include "reorigin.h"
#include "writeitil.h"

/* For the meaning of BOUND see mark_par_bound (). */
#define	BOUND	'B'

static bool data_module;
extern char *filename;

static struct module *Imods;
static unsigned int nr_mods = 0;
static Ent *mod_ent = NULL;
static struct start_end {
    Ent s;
    Ent e;
    struct start_end * prev;
} *ent_base;

static void alloc_Imods(n)
    unsigned int n;
{
    int i;

    nr_mods = n;
    Imods = PSF_NMALLOC(struct module, n);
    ent_base = PSF_NMALLOC(struct start_end, n + 1);
    for (i = 0; i <= n; i ++) {
	ent_base[i].e[PRM] = 0;
	ent_base[i].prev = NULL;
    }
}

static void add_tuple(mod, im, table, key)
    struct module *mod;
    struct module *im;
    tabletype table;
    keytype key;
{
    if (++mod->entries_table[table] == max_entries[table])
	enlarge_entries(table, mod);
    switch (table) {
    case SOR:
	mod->sor[mod->entries_table[table]] = im->sor[key];
	break;
    case FUN:
	mod->fun[mod->entries_table[table]] = im->fun[key];
	break;
    case ATM:
	mod->atm[mod->entries_table[table]] = im->atm[key];
	break;
    case PRO:
	mod->pro[mod->entries_table[table]] = im->pro[key];
	break;
    case SET:
	mod->set[mod->entries_table[table]] = im->set[key];
	break;
    case COM:
	mod->com[mod->entries_table[table]] = im->com[key];
	break;
    case VAR:
	mod->var[mod->entries_table[table]] = im->var[key];
	break;
    case EQU:
	mod->equ[mod->entries_table[table]] = im->equ[key];
	break;
    case DEF:
	mod->def[mod->entries_table[table]] = im->def[key];
	break;
    case PRM:
	mod->par[mod->entries_table[table]] = im->par[key];
	break;
    }
    mod_ent[origin(im, table, key)][table]++;
}

static void add_module(mod, name)
    struct module *mod;
    char *name;
{
    int i, j;

    i = ++mod->entries_table[MOD];
    if (i == max_entries[MOD])
	enlarge_entries(MOD, mod);
    mod->mod[i].ff = name;

    if (i == 1)
	mod_ent = PSF_NMALLOC(Ent, i + 1);
    else
	mod_ent = PSF_REALLOC(mod_ent, Ent, i + 1);
    for (j = 1; j < MTABLE; j++)
	mod_ent[i][j] = 0;
}

static void merge_modules(mod, new)
    struct module *mod;
    struct module *new;
{
    unsigned int m, n;
    int i, j;
    int found;

    m = mod->entries_table[MOD];
    n = new->entries_table[MOD];
    for (i = 1; i <= n; i++) {
	found = 0;
	for (j = 1; j <= m; j++) {
	    if (name_equal(mod->mod[j].ff, new->mod[i].ff)) {
		new->mod[i].o = j;
		found = 1;
		break;
	    }
	}
	if (!found) {
	    add_module(mod, new->mod[i].ff);
	    new->mod[i].o = m + 1;
	    m++;
	}
    }
}

static void check_orv_par(mod, im_nr, bind)
    struct module *mod;
    keytype im_nr;
    arity bind;
{
    struct module *im;
    int t;
    keytype key;
    struct indexlist *parl1, *parl2;
    int i;

    if (Option_Par == 0)
	return;
    im = &Imods[im_nr - 1];
    for (t = ent_base[im_nr - 1].s[PRM]; t < ent_base[im_nr - 1].e[PRM];
	    t++) {
	if (!(key = cmp_tuples(mod, mod, PRM, PRM, t, (char *) NULL)))
	    continue;
	if (origin(mod, PRM, t) == origin(mod, PRM, key)) {
	    if (bind)
		continue;
	    if (Option_Par == 1) {
		mark_delete(mod, PRM, t);
		/* we should delete items of the parameter too */
		parl1 = &mod->par[t].par_attr;
		parl2 = &mod->par[key].par_attr;
		for (i = 0; i < parl1->a; i++) {
		    /*
		     * If something is bind to this, then we may not throw
		     * it away.
		     * That's why check_orv_par is done before check_orv.
		     */
/*
fprintf(stderr, "mdpar: %d.%d.%d - %d\n", parl1->indlist[i].origin, parl1->indlist[i].table, parl1->indlist[i].key, find_real_key(mod, &parl1->indlist[i]));
*/
		    mark_delete(mod, parl1->indlist[i].table,
			find_real_key(mod, &parl1->indlist[i]));
		    changeref(mod, parl1->indlist[i].origin,
			parl1->indlist[i].table, parl1->indlist[i].key,
			parl2->indlist[i].origin, parl2->indlist[i].table,
			parl2->indlist[i].key);
		}
		continue;
	    }
	    fprintf(stderr, "Error in module \"%s\": parameter \"%s\"",
		    mod->name, get_buf_name(name_tuple(mod, PRM, key)));
	    fprintf(stderr, " from module \"%s\" originating from module ",
		    im->name);
	    fprintf(stderr, "\"%s\" already exists in this module\n",
		    get_buf_name(name_tuple(mod, MOD,
					    (keytype) origin(mod, PRM, key))));
	    set_error();
	} else {
	    if (mod->par[t].t == BOUND || mod->par[key].t == BOUND)
		continue;
	    if (bind)
		continue;
	    fprintf(stderr, "Error in module \"%s\": parameter \"%s\"",
		    mod->name, get_buf_name(name_tuple(mod, PRM, t)));
	    fprintf(stderr, " from module \"%s\" ", im->name);
	    fprintf(stderr, "originating from module \"%s\" clashes",
		    get_buf_name(name_tuple(mod, MOD,
					    (keytype) origin(mod, PRM, t))));
	    fprintf(stderr, "%s %s", "with the parameter with",
		    "the same name originating from module ");
	    fprintf(stderr, "\"%s\"\n",
		    get_buf_name(name_tuple(mod, MOD,
					    (keytype) origin(mod, PRM, key))));
	    set_error();
	}
    }
}

static void add_parameters(mod, im_nr)
    struct module *mod;
    int im_nr;
{
    struct module *im;
    keytype i;

    im = &Imods[im_nr - 1];
    for (i = 1; i <= im->entries_table[PRM]; i++) {
	reorigin(im, PRM, i, mod_ent);
    }
    for (i = 1; i <= im->entries_table[PRM]; i++) {
	add_tuple(mod, im, PRM, i);
    }
}

static void check_binren_list(mod, list, br)
    struct module *mod;
    struct indexlist *list;
    int br;
{
    int i, j;
    char *name;
    keytype key;

    for (i = 0; i < list->a; i++) {
	key = list->indlist[i].key;
	name = name_tuple(mod, mod->ren[key].ind1.table,
			  mod->ren[key].ind1.key);
	for (j = i + 1; j < list->a; j++) {
	    key = list->indlist[j].key;
	    if (!name_equal(name, name_tuple(mod, mod->
				ren[key].ind1.table, mod->ren[key].ind1.key)))
		continue;
	    fprintf(stderr, "Error in module \"%s\": the name \"%s\" ",
		    mod->name, name);
	    fprintf(stderr, "appears more than once in a %s-list\n",
		    br ? "binding" : "renaming");
	    set_error();
	}
    }
}

static int *rentable;
static int *rentable_error;

static void do_bindings(mod, im, table, key, binlist)
    struct module *mod;
    struct module *im;
    tabletype table;
    keytype key;
    struct indexlist *binlist;
{
    struct indexlist *renlist;
    ren_tuple *ren_t;
    char *name_n;
    tabletype table_s;
    keytype key_s;
    int i, j;

    if (!parameter_tuple(im, table, key))
	return;
/* cmp_tuples has a specific mode for parameters */
    set_parameter_cmp();
    changerefpar(im, table, key);
    for (i = 0; i < binlist->a; i++) {
	renlist = &mod->bin[binlist->indlist[i].key].ren_indlist;
	name_n = NULL;
	for (j = 0; j < renlist->a; j++) {
            /* get name of item to which the tuple must be bound */
	    ren_t = &mod->ren[renlist->indlist[j].key];
	    if (!name_equal(name_tuple(im, table, key),
			 name_tuple(mod, ren_t->ind1.table, ren_t->ind1.key)))
		continue;
            
            /* get the renaming */
	    name_n = name_tuple(mod, ren_t->ind2.table, ren_t->
				ind2.key);
            /* find a tuple of the same type, but with name_n */
	    table_s = table;
                /* ATM and PRO, SET and SOR can be mixed */
	    if (table == ATM) {
		key_s = cmp_tuples(mod, im, PRO, table, key, name_n);
		if (key_s && unknown_tuple(mod, PRO, key_s))
		    table_s = PRO;
		else
		    key_s = cmp_tuples(mod, im, table, table, key, name_n);
	    } else if (table == SET) {
		key_s = cmp_tuples(mod, im, SOR, table, key, name_n);
		if (key_s && unknown_tuple(mod, SOR, key_s))
		    table_s = SOR;
		else
		    key_s = cmp_tuples(mod, im, table, table, key, name_n);
	    } else
		key_s = cmp_tuples(mod, im, table, table, key, name_n);
	    if (key_s) {
                /* remember the binding for later use, and delete the
                    parameter tuple */
		remember(im, table, key, mod, table_s, key_s);
		mark_delete(im, table, key);

		/* count renaming */
		rentable[renlist->indlist[j].key] --;
	    } else {
		fprintf(stderr, "Error in module \"%s\": ", mod->name);
		fprintf(stderr, "parameter %s \"%s\" of module \"%s\"",
			name_table(table),
			get_buf_name(name_tuple(im, table, key)), im->name);
		fprintf(stderr, " cannot be bound\n");
		set_error();
		rentable_error[renlist->indlist[j].key] = 1;
	    }
	    reset_parameter_cmp();
	    return;
	}
    }

    /* There is no explicit bounding given. So we have to find a tuple
        with the same types and name */
    /*
     * fprintf (stderr, "bound to: [%u.%u.%d]\n", origin (im, table, key),
     * table, origin_key (im, table, key));
     */

    table_s = table;
        /* ATM and PRO, SET and SOR can be mixed */
    if (table == ATM) {
	key_s = cmp_tuples(mod, im, PRO, table, key, (char *) NULL);
	if (key_s && unknown_tuple(mod, PRO, key_s))
	    table_s = PRO;
	else
	    key_s = cmp_tuples(mod, im, table, table, key, (char *) NULL);
    } else if (table == SET) {
	key_s = cmp_tuples(mod, im, SOR, table, key, (char *) NULL);
	if (key_s && unknown_tuple(mod, SOR, key_s))
	    table_s = SOR;
	else
	    key_s = cmp_tuples(mod, im, table, table, key, (char *) NULL);
    } else
	key_s = cmp_tuples(mod, im, table, table, key, (char *) NULL);
    if (key_s) {
	remember(im, table, key, mod, table_s, key_s);
	mark_delete(im, table, key);
    } else {
	set_not_bound(im, table, key);
	/*
	 * fprintf (stderr, "not bound\n"); if (table == FUN) fprintf (stderr,
	 * "%s [%u.%u.%d]\n", name_tuple (im, table, key), im ->
	 * fun[key].sor_indlist.indlist[0].origin, im ->
	 * fun[key].sor_indlist.indlist[0].table,im ->
	 * fun[key].sor_indlist.indlist[0].key); print_ind_list (stderr, im,
	 * table, key);
	 */
    }
    reset_parameter_cmp();
}

static void do_renamings(mod, im, table, key, renlist)
    struct module *mod;
    struct module *im;
    tabletype table;
    keytype key;
    struct indexlist *renlist;
{
    ren_tuple *ren_t;
    int i;
    char *name;

    if (table > SET)
	return;
    name = name_tuple(im, table, key);
    for (i = 0; i < renlist->a; i++) {
	ren_t = &mod->ren[renlist->indlist[i].key];

#ifdef	DEBUG
	fprintf(stderr, "r %d %s %s-%s\n", i, im->name, get_buf_name(name),
		get_buf_name(name_tuple(mod, ren_t->ind1.table,
					ren_t->ind1.key)));
#endif

	if (!name_equal(name,
			name_tuple(mod, ren_t->ind1.table, ren_t->ind1.key)))
	    continue;

#ifdef	DEBUG
	fprintf(stderr, "rename: [%u.%u.%d] ==> [%u.%u.%d]\n",
		ren_t->ind2.origin, ren_t->ind2.table, ren_t->ind2.key,
		origin(im, table, key), table, key);
#endif

        /* count renaming */
        rentable[renlist->indlist[i].key] ++;

	switch (table) {
	case SOR:
	    im->sor[key].ff =
		name_tuple(mod, ren_t->ind2.table, ren_t->ind2.key);
	    im->sor[key].ff = ff_add_field(im->sor[key].ff, "on", name);
	    break;
	case FUN:
	    im->fun[key].ff =
		name_tuple(mod, ren_t->ind2.table, ren_t->ind2.key);
	    im->fun[key].ff = ff_add_field(im->fun[key].ff, "on", name);
	    break;
	case ATM:
	    im->atm[key].ff =
		name_tuple(mod, ren_t->ind2.table, ren_t->ind2.key);
	    im->atm[key].ff = ff_add_field(im->atm[key].ff, "on", name);
	    break;
	case PRO:
	    im->pro[key].ff =
		name_tuple(mod, ren_t->ind2.table, ren_t->ind2.key);
	    im->pro[key].ff = ff_add_field(im->pro[key].ff, "on", name);
	    break;
	case SET:
	    im->set[key].ff =
		name_tuple(mod, ren_t->ind2.table, ren_t->ind2.key);
	    im->set[key].ff = ff_add_field(im->set[key].ff, "on", name);
	    break;
	}
    }
}

static void module_do_renamings(mod, im_nr, renlist)
    struct module *mod;
    int im_nr;
    struct indexlist *renlist;
{
    tabletype i;
    keytype t;
    struct module *im;

    im = &Imods[im_nr - 1];

#ifdef	DEBUG
    fprintf(stderr, "module do ren for %s %u\n", im->name, im->origin);
#endif

    for (i = 1; i <= DEF; i++) {
	for (t = 1; t <= mod->entries_table[i]; t++) {
	    if (origin(mod, i, t) != im->origin)
		continue;
	    if (!local_tuple(mod, i, t)) {

#ifdef	DEBUG
		fprintf(stderr, "module_do_ren: [%u.%u.%d]\n",
			im->origin, i, origin_key(mod, i, t));
#endif

		do_renamings(mod, mod, i, t, renlist);
	    }
	}
    }
}

static void add_imported_tuples(mod, im_nr, im_entry)
    struct module *mod;
    int im_nr;
    int im_entry;
{
    tabletype i;
    keytype t;
    struct module *im;

    im = &Imods[im_nr - 1];
    for (i = 1; i <= DEF; i++)
	for (t = 1; t <= im->entries_table[i]; t++)
	    reorigin(im, i, t, mod_ent);
    for (i = 1; i <= DEF; i++) {
	for (t = 1; t <= im->entries_table[i]; t++) {
	    if (local_tuple(im, i, t)) {
		add_tuple(mod, im, i, t);
	    } else {
		if (im_entry == 0) {
		    add_tuple(mod, im, i, t);
		    continue;
		}
		if (mod->imp[im_entry].t == BINREN) {
		    do_bindings(mod, im, i, t, &mod->imp[im_entry].bin_indlist);
		    do_renamings(mod, im, i, t, &mod->imp[im_entry].ren_indlist);
		} else if (mod->imp[im_entry].t == RENBIN) {
		    do_renamings(mod, im, i, t, &mod->imp[im_entry].ren_indlist);
		    do_bindings(mod, im, i, t, &mod->imp[im_entry].bin_indlist);
		}
		add_tuple(mod, im, i, t);
	    }
	}
    }
}

static tabletype check_order[] =
{ADM, SOR, FUN, ATM, PRO, VAR, SET, COM, EQU, DEF, PRM};

static void check_orv(mod, im_nr)
    struct module *mod;
    int im_nr;
{
    tabletype i, j;
    keytype t;
    keytype key;

    for (j = 1; j <= DEF; j++) {
	i = check_order[j];
	for (t = ent_base[im_nr - 1].s[i]; t < ent_base[im_nr - 1].e[i]; t++) {
	    if (remove_tuple(mod, i, t))
		continue;
	    if (key = cmp_tuples(mod, mod, i, i, t, (char *) NULL)) {
		if (key >= ent_base[im_nr - 1].s[i])
		    continue;
		if (origin(mod, i, key) == origin(mod, i, t)) {
		    if (key != t) {
			/*
			 * Watch out!  Indices of remembered bindings may not
			 * be changed. So changing is done from t to key. Key
			 * is the one, supposed to be present in binding.
			 */
			changeref(mod, origin(mod, i, t),
				  i, origin_key(mod, i, t),
				  origin(mod, i, key), i,
				  origin_key(mod, i, key));
			mark_delete(mod, i, t);
		    }
		    /* do nothing */
		} else if (local_tuple(mod, i, t))
		    continue;
	    }
	}
    }
}

static void check_orv_module(mod)
    struct module *mod;
{
    tabletype i, j;
    keytype t;
    keytype key;

    for (j = 1; j <= PRM; j++) {
	i = check_order[j];
	for (t = 1; t <= mod->entries_table[i]; t++) {
	    if (remove_tuple(mod, i, t))
		continue;
	    if (key = cmp_tuples(mod, mod, i, i, t, (char *) NULL)) {
		if (origin(mod, i, key) == origin(mod, i, t)) {
		    if (key != t) {
			if (cmp_original_names(mod, i, key, mod, i, t)) {
			    fprintf(stderr, "Error in module \"%s\"",
				mod->name);
			    fprintf(stderr, ": origin rule violation for %s \"%s",
				    name_table(i),
				    get_buf_name(name_tuple(mod, i, t)));
			    print_ind_list(stderr, mod, i, t);
			    fprintf(stderr, "\" with original name \"%s",
				ff_get_on(name_tuple(mod, i, t)));
			    fprintf(stderr, "\" from module \"%s\"\n",
				    get_buf_name(mod->mod[origin(mod, i, t)].ff));
			    set_error();
			    /*
			     * We continue (delete it), so that we get only one
			     * error-message (check_orv_module is done twice).
			     */
			}
			/*
			 * Watch out!  Indices of remembered bindings may not
			 * be changed. So changing is done from t to key. Key
			 * is the one, supposed to be present in binding.
			 */
			changeref(mod, origin(mod, i,
					      t), i, origin_key(mod, i, t),
				  origin(mod, i, key), i,
				  origin_key(mod, i, key));
			mark_delete(mod, i, t);
			/*
			 * fprintf (stderr, "md: [%u.%u.%d]\n", origin (mod, i,
			 * t), i, origin_key (mod, i, t));
			 */
		    }
		    /* do nothing */
		} else if (local_tuple(mod, i, t) && origin(mod, i, t) != 1)
		    /* not visible */
		    continue;
		else if (local_tuple(mod, i, key) && origin(mod, i, key) != 1)
		    /* not visible */
		    continue;
                else if (parameter_tuple (mod, i, t))
                    continue;
		else {
		    if (origin(mod, i, key) == 1)
			key = t;
		    fprintf(stderr, "Error in module \"%s\"", mod->name);
		    fprintf(stderr, ": origin rule violation for %s \"%s",
			    name_table(i),
			    get_buf_name(name_tuple(mod, i, key)));
		    print_ind_list(stderr, mod, i, key);
		    fprintf(stderr, "\" from module \"%s\" and local %s\n",
			    get_buf_name(mod->mod[origin(mod, i, key)].ff),
			    name_table(i));
		    set_error();
		    mark_delete(mod, i, t); /* only one error-message */
		    break;
		}
	    }
	}
    }
}

/*
 * BOUND means that the parameter originates from a module to which is bound.
 */
static void mark_par_bound(mod, bm_nr)
    struct module *mod;
    int bm_nr;
{
    int i;

    for (i = ent_base[bm_nr - 1].s[PRM]; i < ent_base[bm_nr - 1].e[PRM]; i++)
	mod->par[i].t = BOUND;
}

static char *get_impmod_name(mod, pkey)
    struct module *mod;
    int pkey;
{
    int bkey;
    int i, j;
    int a;
    struct indextype *il;

    for (i = 1; i <= mod->entries_table[BIN]; i++)
	if (mod->bin[i].par_ind.key == pkey) {
	    bkey = i;
	    break;
	}
    PSF_ASSERT(i <= mod->entries_table[BIN]);

    for (i = 1; i <= mod->entries_table[IMP]; i++) {
	a = mod->imp[i].bin_indlist.a;
	il = mod->imp[i].bin_indlist.indlist;
	for (j = 0; j < a; j++)
	    if (il[j].key == bkey)
		return (get_buf_name(Imods[mod->imp[i].mod_ind.key - 1].name));
    }
    PSF_ASSERT(0);
    return (0);			/* to shut up lint */
}

static char *get_binmod_name(mod, pkey)
    struct module *mod;
    int pkey;
{
    int bkey;
    int i, j;
    int a;
    struct indextype *il;

    for (i = 1; i <= mod->entries_table[BIN]; i++)
	if (mod->bin[i].par_ind.key == pkey) {
	    bkey = i;
	    break;
	}
    PSF_ASSERT(i <= mod->entries_table[BIN]);

    for (i = 1; i <= mod->entries_table[IMP]; i++) {
	a = mod->imp[i].bin_indlist.a;
	il = mod->imp[i].bin_indlist.indlist;
	for (j = 0; j < a; j++)
	    if (il[j].key == bkey)
		return (get_buf_name(Imods[mod->bin[i].mod_ind.key - 1].name));
    }
    PSF_ASSERT(0);
    return (0);			/* to shut up lint */
}

static int import_before_bind(mod, mk, pk)
struct module *mod;
int mk;
int pk;
{
    int i, j;
    int omk;
    struct indexlist *il;
    int m_found = 0;

    /* get the number of the module as it was imported */
    for (i = 0; i < nr_mods; i ++)
	if (Imods[i].origin == mk)
	    omk = i + 1;

    for (i = 1; i <= mod->entries_table[IMP]; i ++) {
	il = &mod->imp[i].bin_indlist;
	for (j = 0; j < il->a; j ++) {
	    if (mod->bin[il->indlist[j].key].par_ind.key == pk)
		return (m_found);
	    if (mod->bin[il->indlist[j].key].mod_ind.key == omk)
		m_found = 1;
	}
    }
    return (0);
}

static void check_parameters(mod)
    struct module *mod;
{
    int i, j;
    struct indexlist *palist;
    int fully_bound;
    keytype pkey;
    struct indextype *t_ind;
    int k, l, m, n;
    struct indexlist *bl;
    struct start_end *se;
    int name_found;

    for (i = 1; i <= mod->entries_table[PRM]; i++) {
	if (!import_tuple(mod, PRM, i)) {
	    /*
	     * if (remove_tuple (mod, PRM, i)) continue;
	     */
	    palist = &mod->par[i].par_attr;
	    for (j = 0; j < palist->a; j++) {
		t_ind = get_actual_object(&palist->indlist[j]);
		if (t_ind == NULL)
		    /* this one couldn't be bound */
		    continue;

#ifdef	DEBUG
		fprintf(stderr, "bind: ");
#endif

		changeref(mod, palist->indlist[j].origin,
			  palist->indlist[j].table, palist->indlist[j].key,
			  t_ind->origin, t_ind->table, t_ind->key);
	    }
	    continue;
	}
	pkey = 0;
	name_found = 0;
	for (j = i + 1; j <= mod->entries_table[PRM]; j++) {
	    if (mod->par[j].t == BOUND) {
		/*
		 * Test if there is a binding of this parameter
		 * after it is imported, to deal with nested bindings.
		 */
		if (!import_before_bind (mod, mod->par[j].o, i)) {
		    continue;
		}
	    }
	    if (mod->par[j].t == DELETE || mod->par[j].t == IMPORTS)
		continue;
	    if (name_equal(mod->par[i].ff, mod->par[j].ff)) {
		name_found = 1;
		/*
		 * There may be more parameters with this name. Which one
		 * should we use?
		 *
		 * Find the binding with [P.i].
		 * Find the import with this binding.
		 * Take [M.x] from this import.
                 * Check if pkey falls into start and end of module x.
		 */
		/* We first check of all of the items have a binding */
		for (k = 0; k < mod->par[j].par_attr.a; k ++) {
		    if (! is_a_binding(& mod->par[j].par_attr.indlist[k]))
			break;
		}
		if (k < mod->par[j].par_attr.a)
		    continue;
		for (k = 1; k <= mod->entries_table[BIN]; k ++) {
		    if (mod->bin[k].par_ind.key != mod->par[i].k)
			continue;
		    n = mod->bin[k].mod_ind.key;
		    for (l = 1; l <= mod->entries_table[IMP]; l ++) {
			if (mod->imp[l].bin_indlist.a == 0)
			    continue;
			bl = &mod->imp[l].bin_indlist;
			for (m = 0; m < bl->a; m ++) {
			    if (bl->indlist[m].key != k)
				continue;
			    n = mod->imp[l].mod_ind.key;

			    if (j >= ent_base[n - 1].s[PRM] &&
				j < ent_base[n - 1].e[PRM]) {
				pkey = j;
				goto found;
			    }
			    se = ent_base[n-1].prev;
			    while (se != NULL) {
				if (j >= se->s[PRM] &&
				    j < se->e[PRM]) {
				    pkey = j;
				    goto found;
				}
				se = se->prev;
			    }
			}
		    }
		}
	    }
	}
found:
	if (pkey == 0) {
	    if (name_found) {
		fprintf(stderr, "Error in module \"%s\": export signature of bound module \"%s\"", mod->name, get_binmod_name(mod, i));
		fprintf(stderr, " does not match requirements of parameter \"%s\"\n", get_buf_name(mod->par[i].ff));
	    } else {
		fprintf(stderr, "Error in module \"%s\": no parameter ",
		    mod->name);
		fprintf(stderr, "\"%s\" found in imported module",
			get_buf_name(mod->par[i].ff));
		fprintf(stderr, " \"%s\"\n", get_impmod_name(mod, i));
	    }
	    set_error();
	    continue;
	}
	palist = &mod->par[pkey].par_attr;
	fully_bound = 1;
	for (j = 0; j < palist->a; j++) {
	    if (not_bound(&palist->indlist[j])) {
		fully_bound = 0;
		break;
	    }
	}
	if (fully_bound) {
	    for (j = 0; j < palist->a; j++) {
		t_ind = get_actual_object(&palist->
					  indlist[j]);
		if (t_ind == NULL)
		    /* this one couldn't be bound */
		    continue;

#ifdef	DEBUG
		fprintf(stderr, "bind: ");
#endif

		changeref(mod, palist->indlist[j].origin,
			  palist->indlist[j].table,
			  palist->indlist[j].key, t_ind->origin,
			  t_ind->table, t_ind->key);
	    }
	    mark_delete(mod, PRM, pkey);	/* mark parameter "to be
						 * deleted" */
	} else {
	    fprintf(stderr, "Error in module \"%s\": parameter ", mod->name);
	    fprintf(stderr, "block \"%s\" originating from module ",
		    get_buf_name(mod->par[pkey].ff));
	    fprintf(stderr, "\"%s\" not fully bound\n",
		    get_buf_name(name_tuple(mod, MOD,
					  (keytype) origin(mod, PRM, pkey))));
	    set_error();
	}
    }
    for (i = 1; i <= mod->entries_table[PRM]; i++)
	if (mod->par[i].t == BOUND)
	    mod->par[i].t = IDLE;
}

static keytype ct_non_idle (m1, m2, t1, t2, k, start)
struct module *m1, *m2;
tabletype t1, t2;
keytype k, start;
{
	keytype key;

    key = start;
    while (key = next_cmp_tuples(m1, m2, t1, t2, k, (char *) NULL, key)) {
        switch (t1) {
        case ATM:
	    if (m1->atm[key].t != IDLE)
                return (key);
	    break;
        case PRO:
	    if (m1->pro[key].t != IDLE)
                return (key);
	    break;
        case SET:
	    if (m1->set[key].t != IDLE)
                return (key);
	    break;
        case SOR:
	    if (m1->sor[key].t != IDLE)
                return (key);
	    break;
        }
    }
    return (key);
}

static keytype ct_local (m1, m2, t1, t2, k, start)
struct module *m1, *m2;
tabletype t1, t2;
keytype k, start;
{
	keytype key;

    key = start;
    while (key = next_cmp_tuples(m1, m2, t1, t2, k, (char *) NULL, key)) {
        switch (t1) {
        case ATM:
	    if (m1->atm[key].o == (t2 == ATM ? m2->atm[k].o : m2->pro[k].o))
                return (key);
	    break;
        case PRO:
	    if (m1->pro[key].o == m2->pro[k].o)
                return (key);
	    break;
        case SET:
	    if (m1->set[key].o == (t2 == SET ? m2->set[k].o : m2->sor[k].o))
                return (key);
	    break;
        case SOR:
	    if (m1->sor[key].o == m2->sor[k].o)
                return (key);
	    break;
        }
    }
    return (key);
}

static void check_unknown(mod, i, t)
    struct module *mod;
    tabletype i;
    keytype t;
{
    keytype key, skey;

    if (i == PRO) {
        if (key = ct_non_idle (mod, mod, ATM, PRO, t, 0)) {
	    if (skey = ct_non_idle (mod, mod, ATM, PRO, t, key))
		return;	/* we have an orv */
	    if (skey = ct_non_idle (mod, mod, PRO, PRO, t, 0)) {
		/* we have a clash */
		return;
	    }
	    changeref(mod, 1, PRO, t, origin(mod, ATM, key), ATM,
		origin_key(mod, ATM, key));
	    return;
        }
        if (key = ct_non_idle (mod, mod, PRO, PRO, t, 0)) {
	    if (skey = ct_non_idle (mod, mod, PRO, PRO, t, key))
		return;	/* we have an orv */
	    changeref(mod, 1, PRO, t, origin(mod, PRO, key), PRO,
		origin_key(mod, PRO, key));
            return;
        }
        /* maybe we can find one in the same module */
        if (key = ct_local (mod, mod, ATM, PRO, t, 0)) {
	    if (skey = ct_local (mod, mod, ATM, PRO, t, key))
		return;	/* Let check_types handle this */
	    changeref(mod, 1, PRO, t, origin(mod, ATM, key), ATM,
		origin_key(mod, ATM, key));
	    return;
        }
        if (key = ct_local (mod, mod, PRO, PRO, t, 0)) {
	    if (skey = ct_non_idle (mod, mod, PRO, PRO, t, key))
		return;	/* Let check_types handle this */
	    changeref(mod, 1, PRO, t, origin(mod, PRO, key), PRO,
		origin_key(mod, PRO, key));
	    return;
        }
	fprintf(stderr,
	    "Error in module \"%s\": unresolved atom or process \"%s",
	    mod->name, get_buf_name(name_tuple(mod, PRO, t)));
	print_ind_list(stderr, mod, PRO, t);
	fprintf(stderr, "\" after evaluating imports\n");
	set_error();
    } else if (i == SOR) {
        if (key = ct_non_idle (mod, mod, SET, SOR, t, 0)) {
	    if (skey = ct_non_idle (mod, mod, SET, SOR, t, key))
		return;	/* we have an orv */
	    if (skey = ct_non_idle (mod, mod, SOR, SOR, t, 0)) {
		/* we have a clash */
		return;
	    }
	    changeref(mod, 1, SOR, t, origin(mod, SET, key), SET,
		origin_key(mod, SET, key));
	    return;
        }
        if (key = ct_non_idle (mod, mod, SOR, SOR, t, 0)) {
	    if (skey = ct_non_idle (mod, mod, SOR, SOR, t, key))
		return;	/* we have an orv */
	    changeref(mod, 1, SOR, t, origin(mod, SOR, key), SOR,
		origin_key(mod, SOR, key));
            return;
        }
        /* maybe we can find one in the same module */
        if (key = ct_local (mod, mod, SET, SOR, t, 0)) {
	    changeref(mod, 1, SOR, t, origin(mod, SET, key), SET,
		origin_key(mod, SET, key));
	    return;
        }
        if (key = ct_local (mod, mod, SOR, SOR, t, 0)) {
	    changeref(mod, 1, SOR, t, origin(mod, SOR, key), SOR,
		origin_key(mod, SOR, key));
	    return;
        }
	fprintf(stderr,
	    "Error in module \"%s\": unresolved set or sort \"%s",
	    mod->name, get_buf_name(name_tuple(mod, SOR, t)));
	print_ind_list(stderr, mod, SOR, t);
	fprintf(stderr, "\" after evaluating imports\n");
	set_error();
    }
}

static void check_imports(mod)
    struct module *mod;
{
    tabletype i;
    keytype t, key, kh;

    set_special_cmp(mod);
    for (i = 1; i <= SET; i++) {
	for (t = 1; t <= mod->entries_table[i]; t++) {
	    if (!import_tuple(mod, i, t)) {
		if (unknown_tuple(mod, i, t))
		    check_unknown(mod, i, t);
		continue;
	    }
	    key = 0;
	    while (key = next_cmp_tuples(mod, mod, i, i, t,
					 (char *) NULL, key)) {
		if (origin(mod, i, t) == origin(mod, i, key))
		    break;
		if (export_tuple(mod, i, key))
		    break;
	    }
	    if (key) {
		kh = key;
		while (kh = next_cmp_tuples(mod, mod, i, i, t,
					    (char *) NULL, kh)) {
		    if (origin(mod, i, t) == origin(mod, i, kh))
			break;
		    if (export_tuple(mod, i, kh))
			break;
		}
		if (!kh) {
		    changeref(mod, 1, i, t, origin(mod, i, key),
			      i, origin_key(mod, i, key));
		}
		continue;
	    } else if (i == SOR) {
		key = 0;
		while (key = next_cmp_tuples(mod, mod, SET, i, t,
					     (char *) NULL, key)) {
		    if (origin(mod, i, t) == origin(mod, i, key))
			break;
		    if (export_tuple(mod, i, key))
			break;
		}
		if (key) {
		    kh = key;
		    while (kh = next_cmp_tuples(mod, mod, SET, i, t,
						(char *) NULL, kh)) {
			if (origin(mod, i, t) == origin(mod, i, kh))
			    break;
			if (export_tuple(mod, i, kh))
			    break;
		    }
		    if (!kh) {
			changeref(mod, 1, i, t, origin(mod, SET, key),
				  SET, origin_key(mod, SET, key));
		    }
		    continue;
		}
	    }
	    fprintf(stderr, "Error in module \"%s\": unresolved %s \"%s",
		    mod->name, name_table(i),
		    get_buf_name(name_tuple(mod, i, t)));
	    print_ind_list(stderr, mod, i, t);
	    fprintf(stderr, "\" after evaluating imports\n");
	    set_error();
	}
    }
    reset_special_cmp();
}

static char buf[256];

static void import_module(mod, nr, itil_lib, im_entry)
    struct module *mod;
    int nr;
    char *itil_lib;
    int im_entry;
{
    FILE *imp;
    int offset;
    int i;
    char *tf;
    struct start_end * se;


    sprintf(buf, "%s/%s.itil", itil_lib,
	    Imods[nr - 1].name);
    imp = psf_fopen(buf, NULL).fp;
    filename = buf;
    if (read_module(&Imods[nr - 1], 0, imp)) {
	(void) fprintf(stderr, "%s: file %s contains no module\n", progname, filename);
	exit(EXIT_SYNTAX_ERR);
    }
    fclose(imp);
    tf = search_field ("t", Imods[nr - 1].mod[1].ff);
    if (tf != NULL) {
	if (data_module && *(tf + 3) == 'p') {
	    (void) fprintf(stderr,
			   "Error in module \"%s\": data module imports process module \"%s\"\n",
			   mod->name, Imods[nr - 1].name);
	    set_error();
	}
    }
    offset = mod->entries_table[MOD];
    Imods[nr - 1].origin += offset;

    if (ent_base[nr-1].e[PRM] != 0) {
	se = PSF_MALLOC(struct start_end);
	se->prev = ent_base[nr-1].prev;
	se->s[PRM] = ent_base[nr-1].s[PRM];
	se->e[PRM] = ent_base[nr-1].e[PRM];
	ent_base[nr-1].prev = se;
    }
    for (i = 0; i < MTABLE; i++)
	ent_base[nr - 1].s[i] = mod->entries_table[i] + 1;

    merge_modules(mod, &Imods[nr - 1]);
    add_parameters(mod, nr);
    add_imported_tuples(mod, nr, im_entry);

    for (i = 0; i < MTABLE; i++)
	ent_base[nr - 1].e[i] = mod->entries_table[i] + 1;

#ifdef	DEBUG
    fprintf(stderr, "module: %s or: %u o: %d\n",
	    get_buf_name(Imods[nr - 1].name), Imods[nr - 1].origin, offset);
#endif
}

static void check(mod)
    struct module *mod;
{
    check_parameters(mod);
    check_orv_module(mod);	/* !!!!!!!!! *//* ?? please explain -- HansM */
    module_add_real_key(mod);
    check_imports(mod);
    check_orv_module(mod);	/* ?? again? why?    -- HansM */
          /*
           * Why 2 times check_orv_module!
           * The first is necessary, because in check_imports an attempt
           * is made to resolve unknown items. If we can find more than one
           * possible item to replace the unknow with, we have a problem.
           * If these items are all the same, check_orv_module maps them
           * on each other. And even through check_orv_module they may
           * become the same.
           * The second is needed, because in check_imports some indexes
           * may have changed, resulting in an origin rule violation.
           */

    if (!Option_Debug) {
	check_clashes(mod);
	check_types(mod);
	check_communications(mod);
	check_bindings(mod);
	check_forbid(mod);
    }
}

void normalize(fp, itil_lib)
    FILE *fp;
    char *itil_lib;
{
    struct module the_module;
    struct module *mod;
    mod_tuple *imports;
    unsigned int nr_imports;
    int i, j, k;
    imp_tuple *it;
    keytype binkey;
    ren_tuple *ren_t;
    bin_tuple *bin_t;
    char *ff;

    mod = &the_module;
    mod->origin = 1;
    if (read_module(mod, 1, fp)) {
	(void) fprintf(stderr, "%s: file %s contains no module\n", 
			progname, filename);
	exit(EXIT_SYNTAX_ERR);
    }
    fclose(fp);

    data_module = mod->ff[0] == 'd';
    if (Option_Lib != NULL)
	ff = ff_add_field(mod->ff, "lib", Option_Lib);
    else
	ff = mod->ff;
    if (mod->entries_table[MOD]) {	/* import modules */
	nr_imports = mod->entries_table[MOD];	/* copy import table */
	imports = PSF_NMALLOC(mod_tuple, nr_imports + 1);
	for (i = 1; i <= nr_imports; i++)
	    imports[i] = mod->mod[i];
	mod->entries_table[MOD] = 0;	/* clear import table */
	add_module(mod, ff_add_field(mod->name, "t", ff));
	/* add base module */
	alloc_Imods(nr_imports);
	for (i = 0; i < nr_imports; i++) {
	    Imods[i].origin = 1;
	    Imods[i].name = imports[i + 1].ff;
	}
	init_rememberbin();

        /* init rename-table for checking if a renaming is used */
        rentable = PSF_NMALLOC (int, mod->entries_table[REN] + 1);
        rentable_error = PSF_NMALLOC (int, mod->entries_table[REN] + 1);
        for (i = 1; i <= mod->entries_table[REN]; i ++) {
            rentable[i] = 0;
            rentable_error[i] = 0;
	}
                /* set renamings which are bindings to -1 */
        for (i = 1; i <= mod->entries_table[BIN]; i ++) {
            for (j = 0; j < mod->bin[i].ren_indlist.a; j ++) {
                rentable[mod->bin[i].ren_indlist.indlist[j].key] = -1;
            }
        }

	/* for every imported module do */
	nr_imports = mod->entries_table[IMP];
	for (i = 1; i <= nr_imports; i++) {
	    it = &mod->imp[i];
	    check_binren_list(mod, &it->ren_indlist, 0);
	    for (j = 0; j < it->bin_indlist.a; j++) {
		binkey = it->bin_indlist.indlist[j].key;
		check_binren_list(mod, &mod->bin[binkey].ren_indlist, 1);
		import_module(mod, mod->bin[binkey].mod_ind.key, itil_lib, 0);
		mark_par_bound(mod, mod->bin[binkey].mod_ind.key);
	    }
	    import_module(mod, it->mod_ind.key, itil_lib, i);
	    for (j = 0; j < it->bin_indlist.a; j++) {
		binkey = it->bin_indlist.indlist[j].key;
		if (it->t == BINREN)
		    module_do_renamings(mod, mod->bin[binkey].mod_ind.key,
					&it->ren_indlist);
		check_orv_par(mod, mod->bin[binkey].mod_ind.key, 0);
		check_orv(mod, mod->bin[binkey].mod_ind.key);
/* first orv_par because there are items deleted that get otherwise matches */
	    }
	    check_orv_par(mod, it->mod_ind.key, it->bin_indlist.a);
	    check_orv(mod, it->mod_ind.key);

	    /* check if renamings are used */
	    for (j = 0; j < it->ren_indlist.a; j ++) {
		if (rentable[it->ren_indlist.indlist[j].key] == 0) {
		    ren_t = &mod->ren[it->ren_indlist.indlist[j].key];
		    fprintf (stderr,
			"Error in module \"%s\": renaming \"%s -> ",
			mod->name, name_tuple(mod, ren_t->ind1.table,
			ren_t->ind1.key));
		    fprintf (stderr,
			"%s\" cannot be done, because there is no ",
			name_tuple(mod, ren_t->ind2.table, ren_t->ind2.key));
		    fprintf (stderr, "\"%s\" in module ", name_tuple(mod,
			ren_t->ind1.table, ren_t->ind1.key));
		    fprintf (stderr, "\"%s\"\n",
			Imods[mod->imp[i].mod_ind.key - 1].name);
		    set_error();
		}
	    }
	    /* check if bindings are used */
	    for (j = 0; j < it->bin_indlist.a; j ++) {
		bin_t = &mod->bin[it->bin_indlist.indlist[j].key];
		if (bin_t->ren_indlist.a == 0)
		    continue;
		for (k = 0; k < bin_t->ren_indlist.a; k ++) {
		    if (rentable[bin_t->ren_indlist.indlist[k].key] == -1 &&
			!rentable_error[bin_t->ren_indlist.indlist[k].key]) {
			/* From x->y, x is missing. */
			ren_t = &mod->ren[bin_t->ren_indlist.indlist[k].key];
			fprintf (stderr,
			    "Error in module \"%s\": binding \"%s -> ",
			    mod->name, name_tuple(mod, ren_t->ind1.table,
			    ren_t->ind1.key));
			fprintf (stderr,
			    "%s\" cannot be done, because there is no ",
			    name_tuple(mod, ren_t->ind2.table,
			    ren_t->ind2.key));
			fprintf (stderr, "\"%s\" in parameter ", name_tuple(mod,
			    ren_t->ind1.table, ren_t->ind1.key));
			fprintf(stderr, "\"%s\" of module ", get_buf_name(
			    mod->par[bin_t->par_ind.key].ff));
			fprintf (stderr, "\"%s\"\n",
			    Imods[mod->imp[i].mod_ind.key - 1].name);
			set_error();
		    }
		    /*
		     * If rentable_error[..], an error-message has already been
		     * given, which means from x->y, y is missing (not
		     * exported).
		     */
		    if (rentable_error[bin_t->ren_indlist.indlist[k].key]) {
			ren_t = &mod->ren[bin_t->ren_indlist.indlist[k].key];
			fprintf (stderr,
			    "Error in module \"%s\": binding \"%s -> ",
			    mod->name, name_tuple(mod, ren_t->ind1.table,
			    ren_t->ind1.key));
			fprintf (stderr,
			    "%s\" cannot be done, because there is no ",
			    name_tuple(mod, ren_t->ind2.table,
			ren_t->ind2.key));
			fprintf (stderr, "\"%s\" ", name_tuple(mod,
			    ren_t->ind2.table, ren_t->ind2.key));
			fprintf (stderr, "exported from module \"%s\"\n",
			    Imods[bin_t->mod_ind.key - 1].name);
			set_error();
		    }
		}
	    }
	}
    } else {                    /* just add module itself to module table */
	add_module(mod, ff_add_field(mod->name, "t", ff));
    }
    check(mod);
    if (!Option_Debug)
	rearrange(mod);
    write_module(mod, stdout);
    if (get_error())
	exit(EXIT_SYNTAX_ERR);
}
