#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "psf_fopen.h"
#include "xtiltype.h"
#include "normalize.h"
#include "main.h"
#include "version.h"

extern int optind;
extern char *optarg;

int Option_Debug = 0;
int Option_Par = 1;
char *Option_Lib = NULL;

char *progname;
char *filename;

static void version()
{
    (void) fprintf(stderr, "mtil_itil version %s, last compiled %s\n", VERSION, __DATE__);
}

static void usage()
{
    fprintf(stderr, "usage: %s [-vh] [mtil-file [itil-library]]\n", progname);
}

int main(argc, argv)
    int argc;
    char *argv[];
{
    int opt;
    char *itil_library_path;
    psf_file pf;
    static suffix suffixes[] = {{NULL, ".mtil"}, {NULL, NULL}};

    progname = psf_basename(argv[0]);
    while ((opt = getopt(argc, argv, "vhdp:L:")) != EOF) {
	switch (opt) {
	case 'd':
	    Option_Debug = 1;
	    break;
	case 'p':
            /*
             * This stems from the time there was no origin rule for
             * parameters, and the user could decide himself what to do
             * with parameters with the same name
             */
	    if (!strcmp(optarg, "0")) {
                /* No origin rule. */
		Option_Par = 0;
		break;
	    }
	    if (!strcmp(optarg, "1")) {
                /* Parameters with the same name and origin are mapped on
                   each other. */
                /* This has become the origin rule, as it is today. */
		Option_Par = 1;
		break;
	    }
	    if (!strcmp(optarg, "2")) {
                /* Parameters with the same name and origin are not allowed. */
		Option_Par = 2;
		break;
	    }
	    fprintf(stderr,
		    "%s: illegal argument \"%s\" for option -p\n",
		    argv[0], optarg);
	    exit(1);
	case 'L':
	    Option_Lib = strdup(optarg);
	    break;
	case 'v':
	    version();
	    break;
	case 'h':
	    usage();
	    exit(0);
	case '?':
	    usage();
	    exit(1);
	}
    }
    switch (argc - optind) {
    case 2:
	pf = psf_fopen(argv[optind], suffixes);
	filename = pf.name;
	itil_library_path = argv[optind + 1];
	break;
    case 1:
	pf = psf_fopen(argv[optind], suffixes);
	filename = pf.name;
	itil_library_path = ".";
	break;
    case 0:
	pf.fp = stdin;
	filename = "stdin";
	itil_library_path = ".";
	break;
    default:
	usage();
	exit(1);
    }
    normalize(pf.fp, itil_library_path);

    /* until we can generate error messages, just return 0 */
    exit (0);
}
