#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_standards.h"

bool name_equal(s, t)
    char *s;
    char *t;
{
    while (*s != ' ' && *s != '\0')
	if (*s++ != *t++)
	    return FALSE;
    if (*t == ' ' || *t == '\0')
	return TRUE;
    return FALSE;
}

char *get_buf_name(s)
    char *s;
{
    char *t;
    static char *buf = NULL;

    if (buf)
	buf = PSF_REALLOC(buf, char, strlen(s) + 1);
    else
	buf = PSF_NMALLOC(char, strlen(s) + 1);
    t = buf;
    while (*s == ' ' && *s != '\0')
	s++;

    while (*s != ' ' && *s != '\0')
	*t++ = *s++;
    *t = '\0';
    return (buf);
}

char *ff_cat(ff, new)
    char *ff;
    char *new;
{
    int len;
    char *nff;

    len = strlen(ff) + strlen(new) + 1;
    nff = PSF_NMALLOC(char, len);
    (void) strcpy(nff, ff);
    (void) strcat(nff, new);
    return (nff);
}

char *search_field(str, ff)
    char *str;
    char *ff;
{
    char *cp;
    char *langl;

    while (1) {
	while (*ff != '<') {
	    if (*ff == '\0')
		return (NULL);
	    ff++;
	}
	langl = ff++;
	cp = str;
	while (*cp == *ff) {
	    cp++;
	    ff++;
	}
	if (*cp != '\0' || *ff != '>')
	    continue;
	return (langl);
    }
}
char *ff_add_field(ff, tag, field)
    char *ff;
    char *tag;
    char *field;
{
    int len;
    char *nff;
    char *on;

    if ((on = search_field("on", field)) != NULL) {
	len = strlen(ff) + strlen(on) + 2;
	nff = PSF_NMALLOC(char, len);
	sprintf(nff, "%s %s", ff, on);
    } else {
	len = strlen(ff) + strlen(tag) + strlen(field) + 4;
	nff = PSF_NMALLOC(char, len);
	sprintf(nff, "%s <%s>%s", ff, tag, field);
    }
    return (nff);
}

static char *get_field(tag, ff)
    char *tag;
    char *ff;
{
    char *s;

    while (1) {
	while (*ff++ != '<')
	    if (*(ff - 1) == '\0')
		return (NULL);
	s = tag;
	while (*s++ == *ff++);
	ff--;
	if (*(s - 1) != '\0' || *ff != '>')
	    continue;
	if (*ff == '\0')
	    return (NULL);
	return (ff + 1);
    }
}

static char buf[2][256];
static int turn = 0;
char *ff_get_on(ff)
    char *ff;
{

    char *s;
    char *t;

    turn = 1 - turn;
    if ((s = get_field("on", ff)) != NULL) {
	t = buf[turn];
	while (*s != ' ' && *s != '\0')
	    *t++ = *s++;
	*t = '\0';
    } else {
	(void) strcpy(buf[turn], ff);
    }
    return buf[turn];
}
