#include <stdio.h>
#include <assert.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "xtiltype.h"
#include "error.h"
#include "ffutil.h"
#include "normutil.h"
#include "prlist.h"
#include "realkey.h"

static int cmp_sor_ind(mod, x, y)
    struct module *mod;
    struct indextype *x;
    struct indextype *y;
{
    if (x->origin == y->origin && x->table == y->table &&
	    x->key == y->key)
	return (0);
    if (x->key == -1)
	return (0);
    if (x->table == SET)
	return (cmp_sor_ind(mod, &mod->set[module_get_real_key
					   (x)].ind, y));
    return (1);
}

static int cmp_sor_real_names(mod, x, y)
    struct module *mod;
    struct indextype *x;
    struct indextype *y;
{
    return (!name_equal
	    (ff_get_on(name_tuple(mod, SOR, module_get_real_key(x))),
	     ff_get_on(name_tuple(mod, SOR, module_get_real_key(y)))));
}

static int cmp_sor_real_ind(mod, x, y)
    struct module *mod;
    struct indextype *x;
    struct indextype *y;
{
    if (x->key == y->key)
	return (0);
    else
	return cmp_sor_real_names(mod, x, y);
}

static int do_real_names = 1;

static int cmp_sor_original_names(mod, x, y)
    struct module *mod;
    struct indextype *x;
    struct indextype *y;
{
    if (x->origin == y->origin && x->table == y->table &&
	    x->key == y->key)
	return (0);
    if (x->origin != y->origin)
	return (1);
    if (x->table == SOR && y->table == SOR)
	if (x->key == -1 || y->key == -1)
	    return (1);
	else
	    if (do_real_names)
		return (cmp_sor_real_names(mod, x, y));
	    else
		return(1);
    return (1);
}

static int cmp_set_original_names(mod, x, y)
    struct module *mod;
    struct indextype *x;
    struct indextype *y;
{
    while (x->table == SET)
	x = &mod->set[module_get_real_key(x)].ind;
    while (y->table == SET)
	y = &mod->set[module_get_real_key(y)].ind;
    return cmp_sor_original_names(mod, x, y);
}

static keytype find_other(mod, type, key, last_arg, last_arg_ind, new_table)
    struct module *mod;
    tabletype type;		/* FUN ATM PRO */
    keytype key;
    int last_arg;
    struct indextype *last_arg_ind;
    tabletype *new_table;
{
    int i, j;

    switch (type) {
    case FUN:
	for (i = 1; i <= mod->entries_table[FUN]; i++) {
	    if (i == key)
		continue;
	    if (remove_tuple(mod, FUN, i))
		continue;
	    if (!name_equal(mod->fun[key].ff, mod->fun[i].ff))
		continue;
	    if (mod->fun[key].sor_indlist.a != mod->fun[i].
		    sor_indlist.a)
		continue;
	    for (j = 0; j < last_arg; j++) {
		if (!index_equal(&mod->fun[key].sor_indlist.indlist[j],
				 &mod->fun[i].sor_indlist.indlist[j]))
		    break;
	    }
	    if (j == last_arg)
		if (index_equal(&mod->fun[i].sor_indlist.
			       indlist[j], last_arg_ind))
		    return (i);
	}
	return (0);
    case ATM:
	for (i = 1; i <= mod->entries_table[ATM]; i++) {
	    if (i == key)
		continue;
	    if (remove_tuple(mod, ATM, i))
		continue;
	    if (!name_equal(mod->atm[key].ff, mod->atm[i].ff))
		continue;
	    if (mod->atm[key].sor_indlist.a != mod->atm[i].
		    sor_indlist.a)
		continue;
	    for (j = 0; j < last_arg; j++) {
		if (cmp_sor_ind(mod, &mod->
				atm[key].sor_indlist.indlist[j],
				 &mod->atm[i].sor_indlist.indlist[j]))
		    break;
	    }
	    if (j == last_arg)
		if (!cmp_sor_ind(mod, last_arg_ind, &mod->
				 atm[i].sor_indlist.indlist[j]))
		    return (i);
	}
	return (0);
    case PRO:
	for (i = 1; i <= mod->entries_table[PRO]; i++) {
	    if (i == key)
		continue;
	    if (remove_tuple(mod, PRO, i))
		continue;
	    if (unknown_tuple(mod, PRO, i))
		continue;
	    if (!name_equal(mod->pro[key].ff, mod->pro[i].ff))
		continue;
	    if (mod->pro[key].sor_indlist.a != mod->pro[i].
		    sor_indlist.a)
		continue;
	    for (j = 0; j < last_arg; j++) {
		if (cmp_sor_ind(mod, &mod->pro[key].sor_indlist.indlist[j],
				&mod->pro[i].sor_indlist.indlist[j]))
		    break;
	    }
	    if (j == last_arg)
		if (!cmp_sor_ind(mod, last_arg_ind,
				 &mod->pro[i].sor_indlist.indlist[j])) {
		    *new_table = PRO;
		    return (i);
		}
	}
	for (i = 1; i <= mod->entries_table[ATM]; i++) {
	    if (remove_tuple(mod, ATM, i))
		continue;
	    if (!name_equal(mod->pro[key].ff, mod->atm[i].ff))
		continue;
	    if (mod->pro[key].sor_indlist.a != mod->atm[i].sor_indlist.a)
		continue;
	    for (j = 0; j < last_arg; j++) {
		if (cmp_sor_ind(mod, &mod->
				pro[key].sor_indlist.indlist[j], &mod
				->atm[i].sor_indlist.indlist[j]))
		    break;
	    }
	    if (j == last_arg)
		if (!cmp_sor_ind(mod, last_arg_ind, &mod->
				 atm[i].sor_indlist.indlist[j])) {
		    *new_table = ATM;
		    return (i);
		}
	}
	return (0);
    default:
	assert(0);		/* should not occur */
	return (0);
    }
}

static struct indextype *type_check_term(mod, term)
    struct module *mod;
    struct ae_term *term;
{
    int i;
    struct indexlist *il;
    struct indextype *ind;
    keytype rkey;
    int flag = 0;
    keytype key_s;
    int dnr;

    rkey = module_get_real_key(&term->ind);

    if (term->ind.table == VAR)
	return (&mod->var[rkey].ind);

    il = &mod->fun[rkey].sor_indlist;
    for (i = 0; i < term->a; i++) {
	ind = type_check_term(mod, &term->ae_list[i]);
	if (!cmp_set_original_names(mod, &il->indlist[i], ind))
	    continue;
	if (il->indlist[i].key == -1 || flag) {
	    key_s = find_other(mod, FUN, rkey, i, ind, &term->
			       ind.table);
	    if (key_s) {
		flag = 1;
		rkey = key_s;
		il = &mod->fun[rkey].sor_indlist;
		continue;
	    }
	}
	fprintf(stderr, "Error in module \"%s\": argument %d of %s \"%s",
		mod->name, i + 1, name_table(term->ind.table),
		get_buf_name(name_tuple(mod, term->ind.table,
					rkey)));
	print_ind_list(stderr, mod, term->ind.table, rkey);
	fprintf(stderr, "\" and %s \"%s",
		name_table(term->ae_list[i].ind.table),
		get_buf_name(name_tuple(mod, term->
			     ae_list[i].ind.table, module_get_real_key(&term->
							   ae_list[i].ind))));
	print_ind_list(stderr, mod, term->
		       ae_list[i].ind.table, module_get_real_key(&
						       term->ae_list[i].ind));
	fprintf(stderr, "\" have different types\n");
	set_error();
    }
    if (flag) {
	/*
	 * If we can find a similar function without using <on>-fields,
	 * it would be better.
	 */
	dnr = do_real_names;
	do_real_names = 0;
	if (key_s =
	    find_other(mod, FUN, rkey, term->a-1, ind, &term->ind.table)) {
	    rkey = key_s;
	}
	do_real_names = dnr;
	term->ind.origin = mod->fun[rkey].o;
	term->ind.key = mod->fun[rkey].k;
    }
    return (&mod->fun[rkey].return_list.indlist[0]);
}

static void type_check_item(mod, term)
    struct module *mod;
    struct ae_term *term;
{
    int i;
    struct indexlist *il;
    struct indextype *ind;
    keytype rkey;
    int flag = 0;
    keytype key_s;
    static struct indexlist no_args = {0, 0};

    rkey = module_get_real_key(&term->ind);

    if (term->ind.table == ATM)
	il = &mod->atm[rkey].sor_indlist;
    else if (term->ind.table == PRO)
	il = &mod->pro[rkey].sor_indlist;
    else if (term->ind.table == FUN)
	il = &mod->fun[rkey].sor_indlist;
    else if (term->ind.table == VAR)
	il = &no_args;
    else
	assert(0);		/* should not occur */
    for (i = 0; i < term->a; i++) {
	ind = type_check_term(mod, &term->ae_list[i]);
	if (!cmp_set_original_names(mod, &il->indlist[i], ind))
	    continue;
	if (il->indlist[i].key == -1 || flag) {
	    key_s = find_other(mod, term->ind.table, rkey, i,
			       ind, &term->ind.table);
	    if (key_s) {
		flag = 1;
		rkey = key_s;
		if (term->ind.table == PRO)
		    il = &mod->pro[rkey].sor_indlist;
		else if (term->ind.table == ATM)
		    il = &mod->atm[rkey].sor_indlist;
		else if (term->ind.table == FUN)
		    il = &mod->fun[rkey].sor_indlist;
		else
		    assert(0);	/* should not occur */
		continue;
	    }
	}
	fprintf(stderr, "Error in module \"%s\": argument %d of\
 %s \"%s", mod->name, i + 1, name_table(term->ind.table), get_buf_name(
				     name_tuple(mod, term->ind.table, rkey)));
	print_ind_list(stderr, mod, term->ind.table, rkey);
	fprintf(stderr, "\" and %s \"%s", name_table(term->
			   ae_list[i].ind.table), get_buf_name(name_tuple(mod,
			     term->ae_list[i].ind.table, module_get_real_key(&
						     term->ae_list[i].ind))));
	print_ind_list(stderr, mod, term->
		       ae_list[i].ind.table, module_get_real_key(&
						       term->ae_list[i].ind));
	fprintf(stderr, "\" have different types\n");
	set_error();
    }
    if (flag) {
	if (term->ind.table == PRO) {
	    term->ind.origin = mod->pro[rkey].o;
	    term->ind.key = mod->pro[rkey].k;
	} else if (term->ind.table == ATM) {
	    term->ind.origin = mod->atm[rkey].o;
	    term->ind.key = mod->atm[rkey].k;
	} else if (term->ind.table == FUN) {
	    term->ind.origin = mod->fun[rkey].o;
	    term->ind.key = mod->fun[rkey].k;
	} else
	    assert(0);		/* should not occur */
    }
}

static void type_check_expr(mod, expr)
    struct module *mod;
    struct process_expr *expr;
{
    int i;
    struct indextype *indx;
    struct indextype *indy;
    keytype rkey;

    switch (expr->fun) {
    case AET:
	type_check_item(mod, &expr->proc_expr.pe2);
	break;
    case SKP:
    case DLK:
	break;
    case ALT:
    case SEQ:
    case PAR:
    case INTR:
    case DISR:
    case STAR:
    case SHARP:
	for (i = 0; i < expr->proc_expr.pe3.a; i++)
	    type_check_expr(mod, &expr->proc_expr.
			    pe3.pe[i]);
	break;
    case SUM:
    case MRG:
	type_check_expr(mod, expr->proc_expr.pe1.pe);
	break;
    case ENC:
    case HID:
	if (expr->proc_expr.pe1.ind.table != SOR ||
	    expr->proc_expr.pe1.ind.key != 0) {
	    if ( mod->set[module_get_real_key(&expr->proc_expr.pe1.ind)].ind.key
		!= 0) {
		fprintf(stderr, "%s \"%s\" %s \"%s\" %s",
			"Error in module", mod->name, ": set",
			get_buf_name(mod->set[expr->proc_expr.pe1.ind.key].ff),
			"should be of type \"set of atoms\".\n");
		set_error();
	    }
	}
	type_check_expr(mod, expr->proc_expr.pe1.pe);
	break;

#ifndef NOIF
    case IF:
	indx = type_check_term(mod, &expr->proc_expr.pe4.aex);
	indy = type_check_term(mod, &expr->proc_expr.pe4.aey);
	type_check_expr(mod, expr->proc_expr.pe4.pe);
	if (cmp_set_original_names(mod, indx, indy)) {
	    indx = &expr->proc_expr.pe4.aex.ind;
	    indy = &expr->proc_expr.pe4.aey.ind;
	    rkey = module_get_real_key(indx);
	    fprintf(stderr, "Error in module \"%s\": %s \"%s",
		    mod->name, name_table(indx->table), get_buf_name
		    (name_tuple(mod, indx->table, rkey)));
	    print_ind_list(stderr, mod, indx->table, rkey);
	    rkey = module_get_real_key(indy);
	    fprintf(stderr, "\" and %s \"%s", name_table(indy->table),
		    get_buf_name(name_tuple(mod, indy->table, rkey)));
	    print_ind_list(stderr, mod, indy->table, rkey);
	    fprintf(stderr, "\" have different types\n");
	    set_error();
	}
	break;
#endif
    case PRIO:
	for (i = 0; i < expr->proc_expr.pe5.sets.a; i ++) {
	    if (expr->proc_expr.pe5.sets.indlist[i].table == SOR &&
		expr->proc_expr.pe5.sets.indlist[i].key == 0)
		continue;
	    if (mod->set[module_get_real_key(
		&expr->proc_expr.pe5.sets.indlist[i])].ind.key != 0) {
		fprintf(stderr, "%s \"%s\" %s \"%s\" %s",
			"Error in module", mod->name, ": set",
			get_buf_name(mod->set[
			    expr->proc_expr.pe5.sets.indlist[i].key].ff),
			"should be of type \"set of atoms\".\n");
		set_error();
	    }
	}
	type_check_expr(mod, expr->proc_expr.pe5.pe);
	break;
    }
}

static void type_check_s_term(mod, st, setkey, sortind)
    struct module *mod;
    struct s_term *st;
    keytype setkey;
    struct indextype *sortind;
{
    int i;

    for (i = 0; i < st->a; i++) {
	if (st->u_tag[i] == 0) {
	    if (st->arr[i].ae_t->ind.table == SOR) {
		if (sortind->key == 0 && st->arr[i].ae_t->ind.key != 0) {
		    fprintf(stderr, "Error in module \"%s\": set-element sort \"%s\"",
		      mod->name, get_buf_name(mod->sor[module_get_real_key(&st
						    ->arr[i].ae_t->ind)].ff));
		    fprintf(stderr, " in set of atoms \"%s\" is not an atom\n",
			    get_buf_name(mod->set[setkey].ff));
		    set_error();
		} else if (st->arr[i].ae_t->ind.key !=
			   sortind->key) {
		    fprintf(stderr, "Error in module \"%s\": the set-type \"%s\"",
			    mod->name, get_buf_name(mod->
				       sor[module_get_real_key(sortind)].ff));
		    fprintf(stderr, " of set \"%s\"", get_buf_name(mod->set[setkey].ff));
		    fprintf(stderr, " differs from set-element sort \"%s\"\n",
			    get_buf_name(mod->sor[module_get_real_key(&st->
						      arr[i].ae_t->ind)].ff));
		    set_error();
		}
	    } else if (st->arr[i].ae_t->ind.table == SET) {
		if (sortind->key == 0 && sort_of_item(mod,
					     &st->arr[i].ae_t->ind)->key == 0)
		    continue;
		if (sortind->key == 0) {
		    fprintf(stderr, "Error in module \"%s\": set-element set \"%s\"",
		      mod->name, get_buf_name(mod->set[module_get_real_key(&st
						    ->arr[i].ae_t->ind)].ff));
		    fprintf(stderr, " in set of atoms \"%s\" is not an atom\n",
			    get_buf_name(mod->set[setkey].ff));
		    set_error();
		} else if (sort_of_item(mod, &st->
					arr[i].ae_t->ind)->key != sortind
			   ->key) {
		    fprintf(stderr, "Error in module \"%s\": the set-type \"%s\"",
			    mod->name, get_buf_name(mod->
				       sor[module_get_real_key(sortind)].ff));
		    fprintf(stderr, " of set \"%s\"", get_buf_name(mod->set[setkey].ff));
		    fprintf(stderr, " differs from the type \"%s\"",
		    get_buf_name(mod->sor[module_get_real_key(sort_of_item(mod,
						&st->arr[i].ae_t->ind))].ff));
		    fprintf(stderr, " of set-element set \"%s\"\n",
			    get_buf_name(mod->set[module_get_real_key(&st->
						      arr[i].ae_t->ind)].ff));
		    set_error();
		}
	    } else {
		type_check_item(mod, st->arr[i].ae_t);
		if (sortind->key == 0) {
		    if (st->arr[i].ae_t->ind.table !=
			    ATM) {
			fprintf(stderr, "Error in module \"%s\":", mod->name);
			if (st->arr[i].ae_t->ind.table == FUN) {
			    fprintf(stderr, " function \"%s", get_buf_name(mod->
				    fun[module_get_real_key(&st->arr[i].ae_t->
							    ind)].ff));
			    print_ind_list(stderr, mod, FUN,
				  module_get_real_key(&st->arr[i].ae_t->ind));
			    set_error();
			} else {
			    fprintf(stderr, " variable \"%s\"\n",
				    get_buf_name(mod->
						 var[module_get_real_key(
						   &st->arr[i].ae_t->ind)].ff));
			}
			fprintf(stderr, "\" in set of atoms \"%s\" is not an atom\n",
				get_buf_name(mod->set[setkey].ff));
			set_error();
		    }
		} else if (cmp_sor_real_ind(mod, sort_of_item
				     (mod, &st->arr[i].ae_t->ind), sortind)) {
		    fprintf(stderr, "Error in module \"%s\": the set-type \"%s\"",
			    mod->name, get_buf_name(mod->
				       sor[module_get_real_key(sortind)].ff));
		    fprintf(stderr, " of set \"%s\"", get_buf_name(mod->set[setkey].ff));
		    fprintf(stderr, " differs from the type \"%s\" of",
		    get_buf_name(mod->sor[module_get_real_key(sort_of_item(mod,
						&st->arr[i].ae_t->ind))].ff));
		    if (st->arr[i].ae_t->ind.table == FUN) {
			fprintf(stderr, " function \"%s", get_buf_name(mod->
				    fun[module_get_real_key(&st->arr[i].ae_t->
							    ind)].ff));
			print_ind_list(stderr, mod, FUN, module_get_real_key(&st->
							   arr[i].ae_t->ind));
			fprintf(stderr, "\"\n");
			set_error();
		    } else {
			fprintf(stderr, " variable \"%s\"\n", get_buf_name(mod->
				    var[module_get_real_key(&st->arr[i].ae_t->
							    ind)].ff));
			set_error();
		    }
		}
	    }
	} else
	    type_check_s_term(mod, st->arr[i].s_t, setkey,
			      sortind);
    }
}

void check_types(mod)
    struct module *mod;
{
    int i, j;
    equ_tuple *eq;
    struct indextype *ind1, *ind2;

    /* checking sets */
    mod->sor[0].ff = PSF_NMALLOC(char, sizeof("atoms"));
    strcpy(mod->sor[0].ff, "atoms");
    /*
     * The above 2 lines were added to make it robust.
     * When there appears a item of type atoms in a set which is not of type
     * atoms, we now don't need to take special actions.
     */

    for (i = 1; i <= mod->entries_table[SET]; i++) {
	if (remove_tuple(mod, SET, i))
	    continue;
	if (parameter_tuple(mod, SET, i)) /* There is no defintion */
	    continue;
	if (mod->set[i].u_tag == 0)
	    continue;
	if (mod->set[i].ind.key == 0)
	    type_check_s_term(mod, &mod->
			      set[i].construct.set_term, i, &mod->
			      set[i].ind);
	else
	    type_check_s_term(mod, &mod->
			      set[i].construct.set_term, i, sort_of_item(mod,
							   &mod->set[i].ind));
    }
    /* checking communications */
    for (i = 1; i <= mod->entries_table[COM]; i++) {
	type_check_item(mod, &mod->com[i].aet[0]);
	type_check_item(mod, &mod->com[i].aet[1]);
	type_check_item(mod, &mod->com[i].aet[2]);
    }

    /* checking equations */
    for (i = 1; i <= mod->entries_table[EQU]; i++) {
	if (remove_tuple(mod, EQU, i))
	    continue;
	eq = &mod->equ[i];
	ind1 = type_check_term(mod, &eq->aet1);
	ind2 = type_check_term(mod, &eq->aet2);
	if (cmp_sor_original_names(mod, ind1, ind2)) {
	    fprintf(stderr, "Error in module \"%s\": left and right\
 side of equation \"%s\" have different types\n", mod->name, get_buf_name(eq
								       ->ff));
	    set_error();
	}
	for (j = 0; j < eq->a; j++) {
	    ind1 = type_check_term(mod, &eq->guard[j].aet1);
	    ind2 = type_check_term(mod, &eq->guard[j].aet2);
	    if (cmp_sor_original_names(mod, ind1, ind2)) {
		fprintf(stderr, "Error in module \"%s\": left \
and right side of guard %d of equation \"%s\" have different types\n", mod->
			name, j + 1, get_buf_name(eq->ff));
		set_error();
	    }
	}
    }

    /* checking definitions */
    for (i = 1; i <= mod->entries_table[DEF]; i++) {
	if (remove_tuple(mod, DEF, i))
	    continue;
	type_check_item(mod, &mod->def[i].ae_t);
	type_check_expr(mod, &mod->def[i].p_expr);
    }
}
