#include <stdio.h>
#include "psf_prototype.h"
#include "xtiltype.h"
#include "error.h"
#include "ffutil.h"
#include "normutil.h"
#include "prlist.h"
#include "realkey.h"

void check_forbid(mod)
    struct module *mod;
{
    fun_tuple *ft;
    set_tuple *st;
    int ent;
    int i, j, k;
    int eq;

    ent = mod->entries_table[FUN];
    ft = mod->fun;
    ft ++;
    for (i = 1; i <= ent; i ++, ft ++) {
	if (ft->t == DELETE)
	    continue;
	for (j = i + 1; j <= ent; j ++) {
	    if (mod->fun[j].t == IMPORTS)
		continue;
	    if (!name_equal(ft->ff, mod->fun[j].ff))
		continue;
	    if (ft->o != mod->fun[j].o)
		continue;
	    if (ft->sor_indlist.a != mod->fun[j].sor_indlist.a)
		continue;
	    eq = 1;
	    for (k = 0; k < ft->sor_indlist.a; k ++) {
		if (!index_equal(&ft->sor_indlist.indlist[k], &mod->fun[j].
		    sor_indlist.indlist[k])) {
		    eq = 0;
		    break;
		}
	    }
	    if (!eq)
		continue;
	    eq = 1;
	    for (k = 0; k < ft->return_list.a; k ++) {
		if (!index_equal(&ft->return_list.indlist[k], &mod->fun[j].
		    return_list.indlist[k])) {
		    eq = 0;
		    break;
		}
	    }
	    if (eq)    /* shouldn't happen */
		continue;
	    fprintf(stderr, "Error in module \"%s\": functions \"%s",
		mod->name, get_buf_name(ft->ff));
	    print_ind_list(stderr, mod, FUN, i);
	    fprintf(stderr, "\" with output-type \"%s\" and ",
		get_buf_name(name_tuple(mod,
		ft->return_list.indlist[0].table == SET ? SET : SOR,
		module_get_real_key(&ft->return_list.indlist[0]))));
	    fprintf(stderr, "\"%s", get_buf_name(mod->fun[j].ff));
	    print_ind_list(stderr, mod, FUN, j);
	    fprintf(stderr, "\" with output-type \"%s\" violate the origin rule\n",
		get_buf_name(name_tuple(mod,
		mod->fun[j].return_list.indlist[0].table == SET ? SET : SOR,
		module_get_real_key(&mod->fun[j].return_list.indlist[0]))));
	}
    }
    /*
     * Sets with the same name and origin but with different type are
     * forbidden.
     */
    ent = mod->entries_table[SET];
    st = mod->set;
    st ++;
    for (i = 1; i <= ent; i++, st++) {
	if (st->t == DELETE)
	    continue;
	for (j = i + 1; j <= ent; j ++) {
	    if (!name_equal(st->ff, mod->set[j].ff))
		continue;
	    if (st->o != mod->set[j].o)
		continue;
	    if (index_equal(&st->ind, &mod->set[j].ind))
		continue;
	    fprintf(stderr, "Error in module \"%s\": sets \"%s\" with type ",
		mod->name, get_buf_name(st->ff));
	    fprintf(stderr, "\"%s\" and ", get_buf_name(name_tuple(mod,
		st->ind.table == SET ? SET : SOR,
		module_get_real_key(&st->ind))));
	    fprintf(stderr, "\"%s\" with type ", get_buf_name(mod->set[j].ff));
	    fprintf(stderr, "\"%s\" violate the origin rule\n",
		get_buf_name(name_tuple(mod, mod->set[j].ind.table == SET ?
		SET : SOR, module_get_real_key(&mod->set[j].ind))));
	}
    }
}
