#include <stdio.h>
#include "psf_prototype.h"
#include "xtiltype.h"
#include "normutil.h"
#include "error.h"
#include "ffutil.h"
#include "realkey.h"

static void comm_error(mod, key)
    struct module *mod;
    keytype key;
{
    fprintf(stderr, "Error in module \"%s\": atom \"%s\" appears on ",
			mod->name, get_buf_name( name_tuple(mod, ATM, key)));
    fprintf(stderr, "the left and right hand side of a communication\n");
    set_error();
}

void check_communications(mod)
    struct module *mod;
{
    int i;
    int j;
    int a;
    com_tuple *ct, *ct2;
    origintype o;

    a = mod->entries_table[COM];
    ct = mod->com + 1;
    for (i = 1; i <= a; i++, ct ++) {
	if (origin(mod, COM, i) != 1) {
	    /*
	     * Combining modules may cause inconsistency
	     */
	    for (j = i + 1, ct2 = ct + 1; j <= a; j ++, ct2 ++) {
		if (origin(mod, COM, j) == 1)
		    /*
		     * Checked elsewhere, and we don't want 2 error-messages
		     */
		    continue;
		if ((index_equal(&ct->aet[0].ind, &ct2->aet[0].ind) &&
		    index_equal(&ct->aet[1].ind, &ct2->aet[1].ind)) ||
		    (index_equal(&ct->aet[0].ind, &ct2->aet[1].ind) &&
		    index_equal(&ct->aet[1].ind, &ct2->aet[0].ind))) {
		    if (!index_equal(&ct->aet[2].ind, &ct2->aet[2].ind)) {
			fprintf(stderr, "Error in module \"%s\": ", mod->name);
			fprintf(stderr, "communications \"%s | ",
			    get_buf_name(name_tuple(mod, ATM,
			    module_get_real_key(&ct->aet[0].ind))));
			fprintf(stderr, "%s = ",
			    get_buf_name(name_tuple(mod, ATM,
			    module_get_real_key(&ct->aet[1].ind))));
			fprintf(stderr, "%s\" from module ",
			    get_buf_name(name_tuple(mod, ATM,
			    module_get_real_key(&ct->aet[2].ind))));
			fprintf(stderr, "\"%s\" and ",
			    get_buf_name(name_tuple(mod, MOD, origin(mod, COM,
			    i))));
			fprintf(stderr, "\"%s | ",
			    get_buf_name(name_tuple(mod, ATM,
			    module_get_real_key(&ct2->aet[0].ind))));
			fprintf(stderr, "%s = ",
			    get_buf_name(name_tuple(mod, ATM,
			    module_get_real_key(&ct2->aet[1].ind))));
			fprintf(stderr, "%s\" from module ",
			    get_buf_name(name_tuple(mod, ATM,
			    module_get_real_key(&ct2->aet[2].ind))));
			fprintf(stderr, "\"%s\" are inconsistent\n",
			    get_buf_name(name_tuple(mod, MOD, origin(mod, COM,
			    j))));
			set_error();
		    }
		}
	    }
	    break;
	}
	/* new communications only in module 1 */
	/* consistency of export */
	if (export_tuple(mod, ATM, module_get_real_key(&ct->aet[0].ind)) &&
		export_tuple(mod, ATM, module_get_real_key(&ct->aet[1].ind))) {
	    if (!export_tuple(mod, ATM, module_get_real_key(&ct->aet[2].ind))) {
		fprintf(stderr,
			"Error in module \"%s\": atom \"%s\", which is the ",
			mod->name,
			get_buf_name(name_tuple(mod, ATM,
					module_get_real_key(&ct->aet[2].ind))));
		fprintf(stderr,
			"result of a communication between the exported ");
		fprintf(stderr,
			"atoms \"%s\" and ",
			get_buf_name(name_tuple(mod, ATM,
					module_get_real_key(&ct->aet[0].ind))));
		fprintf(stderr, "\"%s\", is not exported\n",
			get_buf_name(name_tuple(mod, ATM,
				      module_get_real_key(&ct->aet[1].ind))));
		set_error();
	    }
	}
	/* consistency of communications  part 1/2 */
	o = origin(mod, ATM, module_get_real_key(&ct->aet[0].ind));
	if (o == origin(mod, ATM,
			module_get_real_key(&ct->aet[1].ind)) && o != 1) {
	    fprintf(stderr,
		"Error in module \"%s\": communication between the atoms ",
		mod->name);
	    fprintf(stderr,
		"\"%s\" and ", get_buf_name(name_tuple(mod, ATM,
				      module_get_real_key(&ct->aet[0].ind))));
	    fprintf(stderr, "\"%s\", both originating from module ",
		    get_buf_name(name_tuple(mod, ATM,
				      module_get_real_key(&ct->aet[1].ind))));
	    fprintf(stderr, "\"%s\", is redefined\n",
			get_buf_name(name_tuple(mod, MOD, (keytype) o)));
	    set_error();
	} else {
	    ct2 = ct;
	    for (j = i; j <= a; j++, ct2++) {
		/* firm handshaking */
		if (index_equal(&ct->aet[0].ind, &ct2->aet[2].ind) ||
			index_equal(&ct->aet[1].ind, &ct2->aet[2].ind)) {
		    comm_error(mod, module_get_real_key(&ct2->aet[2].ind));
		}
		if (index_equal(&ct->aet[2].ind, &ct2->aet[0].ind) ||
			index_equal(&ct->aet[2].ind, &ct2->aet[1].ind)) {
		    comm_error(mod, module_get_real_key(&ct->aet[2].ind));
		}
		if (j == i)
		    continue;
		/* consistency of communications  part2/2 */
		if ((index_equal(&ct->aet[0].ind, &ct2->aet[0].ind) &&
                    index_equal(&ct->aet[1].ind, &ct2->aet[1].ind)) ||
		    (index_equal(&ct->aet[0].ind, &ct2->aet[1].ind) &&
                    index_equal(&ct->aet[1].ind, &ct2->aet[0].ind))) {
		    fprintf(stderr,
			"Error in module \"%s\": communication between the ",
			mod->name);
		    fprintf(stderr, "atoms \"%s\" and ",
			get_buf_name(name_tuple(mod, ATM,
				   module_get_real_key(&ct->aet[0].ind))));
                    fprintf(stderr, "\"%s\" is redefined\n",
			get_buf_name(name_tuple(mod, ATM,
				   module_get_real_key(&ct->aet[1].ind))));
		    set_error();
		}
	    }
	}
    }
}
