#include <stdio.h>
#include "psf_prototype.h"
#include "error.h"
#include "ffutil.h"
#include "normutil.h"
#include "prlist.h"
#include "xtiltype.h"

void check_clashes(mod)
    struct module *mod;
{
    var_tuple *vt;
    fun_tuple *ft;
    atm_tuple *at;
    int ent1, ent2;
    int i, j;

    ent1 = mod->entries_table[VAR];
    ent2 = mod->entries_table[FUN];
    vt = mod->var;
    vt++;
    for (i = 1; i <= ent1; i++, vt++) {
	if (vt->o > 1)
	    break;
        if (vt->t == DELETE)
            continue;
        if (vt->t == LOCAL)	/* cannot clash with placeholder, becasue
                                   we have a new scope */
            continue;
	ft = mod->fun;
	ft++;
	for (j = 1; j <= ent2; j++, ft++) {
	    if (!name_equal(vt->ff, ft->ff))
		continue;
	    if (ft->sor_indlist.a > 0)
		continue;
	    if (ft->o > 1 && ft->t != EXPORTS)
		continue;
	    fprintf(stderr, "Error in module \"%s\": ", mod->name);
	    fprintf(stderr, "variable \"%s\" ",
		    get_buf_name(vt->ff));
	    fprintf(stderr, "clashes with constant \"%s\" ",
		    get_buf_name(ft->ff));
	    fprintf(stderr, "from module \"%s\"\n",
		    get_buf_name(name_tuple(mod, MOD, (keytype) ft->o)));
	    set_error();
	}
    }

    ent1 = mod->entries_table[ATM];
    at = mod->atm;
    at++;
    for (i = 1; i <= ent1; i++, at++) {
	j = cmp_tuples(mod, mod, PRO, ATM, i, (char *) NULL);
	if (j) {
	    fprintf(stderr, "Error in module \"%s\": ", mod->name);
	    fprintf(stderr, "atom \"%s\" ",
		    get_buf_name(at->ff));
	    fprintf(stderr, "from module \"%s\" ",
		    get_buf_name(name_tuple(mod, MOD,
					    (keytype) at->o)));
	    fprintf(stderr, "clashes with process \"%s\" ",
		    get_buf_name(at->ff));
	    fprintf(stderr, "from module \"%s\"\n",
		    get_buf_name(name_tuple(mod, MOD,
					    (keytype) origin(mod, PRO, j))));
	    set_error();
	}
    }
}
