#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "xtiltype.h"
#include "normutil.h"
#include "ffutil.h"
#include "error.h"
#include "realkey.h"

struct stack_el {
    origintype o;
    keytype k;
};

static struct stack_el *stack = NULL;
static int size_stack = 0;
static int top_stack = 0;

static void push(ind)
    struct indextype *ind;
{
    if (top_stack == size_stack) {
	if (stack == NULL) {
	    size_stack = 16;
	    stack = PSF_NMALLOC(struct stack_el, size_stack);
	} else {
	    size_stack += 8;
	    stack = PSF_REALLOC(stack, struct stack_el, size_stack);
	}
    }
    stack[top_stack].o = ind->origin;
    stack[top_stack].k = ind->key;
    top_stack++;
}

/*
static void pop()
{
    top_stack--;
}
*/

static void reset_stack()
{
    top_stack = 0;
}

static int on_stack(ind)
    struct indextype *ind;
{
    int i;

    i = top_stack;
    while (i) {
	i--;
	if (stack[i].o == ind->origin && stack[i].k == ind->key)
	    return (1);
    }
    return (0);
}

static void push_var(aet)
    struct ae_term *aet;
{
    int i;

    if (aet->ind.table == VAR) {
	push(&aet->ind);
	return;
    }
    for (i = 0; i < aet->a; i++)
	push_var(&aet->ae_list[i]);
}

static void check_ae_term(mod, aet)
    struct module *mod;
    struct ae_term *aet;
{
    int a;
    struct ae_term *t;

    if (aet->ind.table == VAR) {
	if (!on_stack(&aet->ind)) {
	    fprintf(stderr, "Error in module \"%s\": variable \"%s\" \
is used outside the scope\n", mod->name, get_buf_name(name_tuple(mod,
				       VAR, module_get_real_key(&aet->ind))));
	    set_error();
	}
    } else {
	a = aet->a;
	t = aet->ae_list;
	while (a--)
	    check_ae_term(mod, t++);
    }
}

static void check_process_expr(mod, expr)
    struct module *mod;
    struct process_expr *expr;
{
    int i;
    int arg;

    switch (expr->fun) {
    case AET:
	check_ae_term(mod, &expr->proc_expr.pe2);
	break;
    case ALT:
    case SEQ:
    case PAR:
    case INTR:
    case DISR:
    case STAR:
    case SHARP:
	arg = expr->proc_expr.pe3.a;
	for (i = 0; i < arg; i++)
	    check_process_expr(mod, &expr->proc_expr.pe3.pe[i]);
	break;
    case SKP:
    case DLK:
	break;
    case SUM:
    case MRG:
	push(&expr->proc_expr.pe1.ind);
	check_process_expr(mod, expr->proc_expr.pe1.pe);
	break;
    case ENC:
    case HID:
	check_process_expr(mod, expr->proc_expr.pe1.pe);
	break;

#ifndef NOIF
    case IF:
	check_ae_term(mod, &expr->proc_expr.pe4.aex);
	check_ae_term(mod, &expr->proc_expr.pe4.aey);
	check_process_expr(mod, expr->proc_expr.pe4.pe);
	break;
#endif
    case PRIO:
	check_process_expr(mod, expr->proc_expr.pe5.pe);
	break;
    }
}

void check_bindings(mod)
    struct module *mod;
{
    int i;
    def_tuple *def_t;

    def_t = mod->def + 1;
    for (i = 1; i <= mod->entries_table[DEF]; i++, def_t++) {
	push_var(&def_t->ae_t);
	check_process_expr(mod, &def_t->p_expr);
	reset_stack();
    }
}
