#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "psf_prototype.h"
#include "xtiltype.h"
#include "readxtiltype.h"
#include "rememberbin.h"

static void changeref_index(index)
    struct indextype *index;
{
    struct indextype *bi;

    if ((bi = get_actual_object(index)) != NULL) {
	index->origin = bi->origin;
	index->table = bi->table;
	index->key = bi->key;
    }
}

static void changeref_indexarr(nr, indlist)
    unsigned int nr;
    struct indextype *indlist;
{
    int i;

    for (i = 0; i < nr; i++) {
	changeref_index(&indlist[i]);
    }
}

static void changeref_indexlist(il)
    struct indexlist *il;
{
    changeref_indexarr(il->a, il->indlist);
}

static void changeref_ae_term(term)
    struct ae_term *term;
{
    int i;

    if (term->t == TUPLE) {
	for (i = 0; i < term->a; i++)
	    changeref_ae_term(&(term->ae_list[i]));
    } else {
	changeref_index(&term->ind);
	for (i = 0; i < term->a; i++)
	    changeref_ae_term(&(term->ae_list[i]));
    }
}

static void changeref_s_term(term)
    struct s_term *term;
{
    int i;

    for (i = 0; i < term->a; i++) {
	if (term->u_tag[i] == 0) {
	    changeref_ae_term(term->arr[i].ae_t);
	} else {
	    changeref_s_term(term->arr[i].s_t);
	}
    }
}

static void changeref_process_expr(p_expr)
    struct process_expr *p_expr;
{
    int i;
    arity arg;

    if (p_expr->fun == AET) {
	changeref_ae_term(&p_expr->proc_expr.pe2);
    } else {
	switch (p_expr->fun) {
	case ALT:
	case SEQ:
	case PAR:
	case INTR:
	case DISR:
	case STAR:
	case SHARP:
	    arg = p_expr->proc_expr.pe3.a;
	    for (i = 0; i < arg; i++)
		changeref_process_expr(&p_expr->
				       proc_expr.pe3.pe[i]);
	    break;
	case SKP:
	case DLK:
	    break;
	case SUM:
	case MRG:
	case ENC:
	case HID:
	    changeref_index(&p_expr->proc_expr.pe1.ind);
	    changeref_process_expr(p_expr->proc_expr.pe1.pe);
	    break;

#ifndef NOIF
	case IF:
	    changeref_ae_term(&p_expr->proc_expr.pe4.aex);
	    changeref_ae_term(&p_expr->proc_expr.pe4.aey);
	    changeref_process_expr(p_expr->proc_expr.pe4.pe);
	    break;
#endif
	case PRIO:
	    changeref_indexlist(&p_expr->proc_expr.pe5.sets);
	    changeref_process_expr(p_expr->proc_expr.pe5.pe);
	    break;
	}
    }
}

static void changeref_fun_tuple(fun_t)
    fun_tuple *fun_t;
{
    changeref_indexlist(&fun_t->sor_indlist);
    changeref_indexlist(&fun_t->return_list);
}

static void changeref_atm_tuple(atm_t)
    atm_tuple *atm_t;
{
    changeref_indexlist(&atm_t->sor_indlist);
}

static void changeref_pro_tuple(pro_t)
    pro_tuple *pro_t;
{
    changeref_atm_tuple(pro_t);
}

static void changeref_set_tuple(set_t)
    set_tuple *set_t;
{
    changeref_index(&set_t->ind);
    if (set_t->t != IMPORTS && set_t->t != PARAMETER) {
	if (set_t->u_tag == 0) {
	    changeref_index(&set_t->construct.sort);
	} else {
	    changeref_s_term(&set_t->construct.set_term);
	}
    }
}

/*
static void changeref_com_tuple(com_t)
    com_tuple *com_t;
{
    changeref_ae_term(&com_t->aet[0]);
    changeref_ae_term(&com_t->aet[1]);
    changeref_ae_term(&com_t->aet[2]);
}

static void changeref_var_tuple(var_t)
    var_tuple *var_t;
{
    changeref_index(&var_t->ind);
}

static void changeref_equ_tuple(equ_t)
    equ_tuple *equ_t;
{
    int i;

    changeref_ae_term(&equ_t->aet1);
    changeref_ae_term(&equ_t->aet2);
    for (i = 0; i < equ_t->a; i++) {
	changeref_ae_term(&equ_t->guard[i].aet1);
	changeref_ae_term(&equ_t->guard[i].aet2);
    }
}

static void changeref_def_tuple(def_t)
    def_tuple *def_t;
{
    changeref_ae_term(&def_t->ae_t);
    changeref_process_expr(&def_t->p_expr);
}
*/

void changerefpar(mod, t, k)
    struct module *mod;
    tabletype t;
    keytype k;
{
    switch (t) {
    case SOR:			/* empty */
	break;
    case FUN:
	changeref_fun_tuple(&mod->fun[k]);
	break;
    case ATM:
	changeref_atm_tuple(&mod->atm[k]);
	break;
    case PRO:
	changeref_pro_tuple(&mod->pro[k]);
	break;
    case SET:
	changeref_set_tuple(&mod->set[k]);
	break;
    default:
	assert(0);
    }
}
