#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "normutil.h"
#include "xtiltype.h"
#include "readxtiltype.h"

static origintype old_origin;
static tabletype old_table;
static keytype old_key;
static struct indextype new_index;

static void changeref_index(index)
    struct indextype *index;
{
    if (index->origin == old_origin && index->table == old_table &&
	    index->key == old_key)
	*index = new_index;
}

static void changeref_indexlist(il)
    struct indexlist *il;
{
    int a;
    struct indextype *list;

    a = il->a;
    list = il->indlist;
    while (a--)
	changeref_index(list++);
}

static void changeref_ae_term(term)
    struct ae_term *term;
{
    int a;
    struct ae_term *aet;

    if (term->t != TUPLE)
	changeref_index(&term->ind);
    a = term->a;
    aet = term->ae_list;
    while (a--)
	changeref_ae_term(aet++);
}

static void changeref_s_term(term)
    struct s_term *term;
{
    int i;

    for (i = 0; i < term->a; i++) {
	if (term->u_tag[i] == 0) {
	    changeref_ae_term(term->arr[i].ae_t);
	} else {
	    changeref_s_term(term->arr[i].s_t);
	}
    }
}

static void changeref_process_expr(p_expr)
    struct process_expr *p_expr;
{
    int i;
    arity arg;

    if (p_expr->fun == AET) {
	changeref_ae_term(&p_expr->proc_expr.pe2);
    } else {
	switch (p_expr->fun) {
	case AET:
	    if (old_table == ATM || old_table == PRO)
		changeref_index(&p_expr->proc_expr.pe2.ind);
	    else
		changeref_ae_term(&p_expr->proc_expr.pe2);
	    break;
	case ALT:
	case SEQ:
	case PAR:
	case INTR:
	case DISR:
	case STAR:
	case SHARP:
	    arg = p_expr->proc_expr.pe3.a;
	    for (i = 0; i < arg; i++)
		changeref_process_expr(&p_expr->proc_expr.pe3.pe[i]);
	    break;
	case SKP:
	case DLK:
	    break;
	case SUM:
	case MRG:
	case ENC:
	case HID:
	    changeref_index(&p_expr->proc_expr.pe1.ind);
	    changeref_process_expr(p_expr->proc_expr.pe1.pe);
	    break;

#ifndef NOIF
	case IF:
	    changeref_ae_term(&p_expr->proc_expr.pe4.aex);
	    changeref_ae_term(&p_expr->proc_expr.pe4.aey);
	    changeref_process_expr(p_expr->proc_expr.pe4.pe);
	    break;
#endif
	case PRIO:
	    changeref_indexlist(&p_expr->proc_expr.pe5.sets);
	    changeref_process_expr(p_expr->proc_expr.pe5.pe);
	    break;
	default:
	    PSF_ASSERT(p_expr->fun ? 0 : 0);
	    break;
	}
    }
}

static void changeref_fun_tuple(fun_t, a)
    fun_tuple *fun_t;
    unsigned int a;
{
    while (a--) {
	fun_t++;
	changeref_indexlist(&fun_t->sor_indlist);
	changeref_indexlist(&fun_t->return_list);
    }
}

static void changeref_atm_tuple(atm_t, a)
    atm_tuple *atm_t;
    unsigned int a;
{
    while (a--) {
	atm_t++;
	changeref_indexlist(&atm_t->sor_indlist);
    }
}

static void changeref_pro_tuple(pro_t, a)
    pro_tuple *pro_t;
    unsigned int a;
{
    changeref_atm_tuple(pro_t, a);
}

static void changeref_set_tuple(set_t, a)
    set_tuple *set_t;
    unsigned int a;
{
    while (a--) {
	set_t++;
	changeref_index(&set_t->ind);
	if (set_t->t!=IMPORTS && set_t->t!=PARAMETER && set_t->t!=DELETE) {
	    if (set_t->u_tag == 0) {
		changeref_index(&set_t->construct.sort);
	    } else {
		changeref_s_term(&set_t->construct.set_term);
	    }
	}
    }
}

static void changeref_com_tuple(com_t, a)
    com_tuple *com_t;
    unsigned int a;
{
    while (a--) {
	com_t++;
	changeref_ae_term(&com_t->aet[0]);
	changeref_ae_term(&com_t->aet[1]);
	changeref_ae_term(&com_t->aet[2]);
    }
}

static void changeref_var_tuple(var_t, a)
    var_tuple *var_t;
    unsigned int a;
{
    while (a--) {
	var_t++;
	changeref_index(&var_t->ind);
    }
}

static void changeref_equ_tuple(equ_t, a)
    equ_tuple *equ_t;
    unsigned int a;
{
    int i;

    while (a--) {
	equ_t++;
	changeref_ae_term(&equ_t->aet1);
	changeref_ae_term(&equ_t->aet2);
	for (i = 0; i < equ_t->a; i++) {
	    changeref_ae_term(&equ_t->guard[i].aet1);
	    changeref_ae_term(&equ_t->guard[i].aet2);
	}
    }
}

static void changeref_def_tuple(def_t, a)
    def_tuple *def_t;
    unsigned int a;
{
    while (a--) {
	def_t++;
	if (old_table == PRO)
	    changeref_index(&def_t->ae_t.ind);
	else
	    changeref_ae_term(&def_t->ae_t);
	changeref_process_expr(&def_t->p_expr);
    }
}

static void changeref_par_tuple(par_t, a)
    par_tuple *par_t;
    unsigned int a;
{
    while (a--) {
	par_t++;
	changeref_indexlist(&par_t->par_attr);
    }
}

void changeref(mod, oo, ot, ok, no, nt, nk)
    struct module *mod;
    origintype oo;
    tabletype ot;
    keytype ok;
    origintype no;
    tabletype nt;
    keytype nk;
{
    old_origin = oo;
    old_table = ot;
    old_key = ok;
    new_index.origin = no;
    new_index.table = nt;
    new_index.key = nk;

#ifdef	DEBUG
    fprintf(stderr, "[%u.%u.%d] ==> [%u.%u.%d]\n", oo, ot, ok, no, nt, nk);
#endif

    switch (ot) {
    case SOR:
	changeref_fun_tuple(mod->fun, mod->entries_table[FUN]);
	changeref_atm_tuple(mod->atm, mod->entries_table[ATM]);
	changeref_pro_tuple(mod->pro, mod->entries_table[PRO]);
	changeref_set_tuple(mod->set, mod->entries_table[SET]);
	changeref_com_tuple(mod->com, mod->entries_table[COM]);
	changeref_var_tuple(mod->var, mod->entries_table[VAR]);
	changeref_def_tuple(mod->def, mod->entries_table[DEF]);
	changeref_par_tuple(mod->par, mod->entries_table[PRM]);
	break;
    case FUN:
	changeref_set_tuple(mod->set, mod->entries_table[SET]);
	changeref_com_tuple(mod->com, mod->entries_table[COM]);
	changeref_equ_tuple(mod->equ, mod->entries_table[EQU]);
	changeref_def_tuple(mod->def, mod->entries_table[DEF]);
	changeref_par_tuple(mod->par, mod->entries_table[PRM]);
	break;
    case ATM:
	changeref_set_tuple(mod->set, mod->entries_table[SET]);
	changeref_com_tuple(mod->com, mod->entries_table[COM]);
	changeref_def_tuple(mod->def, mod->entries_table[DEF]);
	changeref_par_tuple(mod->par, mod->entries_table[PRM]);
	break;
    case PRO:
	changeref_def_tuple(mod->def, mod->entries_table[DEF]);
	changeref_par_tuple(mod->par, mod->entries_table[PRM]);
	break;
    case SET:
	changeref_set_tuple(mod->set, mod->entries_table[SET]);
	changeref_com_tuple(mod->com, mod->entries_table[COM]);
	changeref_var_tuple(mod->var, mod->entries_table[VAR]);
	changeref_def_tuple(mod->def, mod->entries_table[DEF]);
	changeref_par_tuple(mod->par, mod->entries_table[PRM]);
	break;
    case COM:
	break;
    case VAR:
	changeref_set_tuple(mod->set, mod->entries_table[SET]);
	changeref_com_tuple(mod->com, mod->entries_table[COM]);
	changeref_equ_tuple(mod->equ, mod->entries_table[EQU]);
	changeref_def_tuple(mod->def, mod->entries_table[DEF]);
	break;
    case EQU:
	break;
    case DEF:
	break;
    case PRM:
	break;
    }
}
