#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_standards.h"
#include "psf_fopen.h"
#include "psf_exits.h"
#include "version.h"
#include "xtiltype.h"
#include "readxtil.h"
#include "writetil.h"

char *progname;
char *filename;

static void version()
{
    (void) fprintf(stderr, "itil_til version %s, last compiled %s\n",
		   VERSION, __DATE__);
}
static void usage()
{
    fprintf(stderr, "usage: %s [-vh] [itil-file]\n", progname);
}

int main(argc, argv)
    int argc;
    char *argv[];
{
    struct module *mod;
    int i;
    extern int optind;
    psf_file pf;
    static suffix suffixes[] = {{NULL, ".itil"}, {NULL, NULL}};

    progname = psf_basename(argv[0]);

    while ((i = getopt(argc, argv, "vh")) != EOF)
	switch (i) {
	case 'v':
	    version();
	    break;
	case 'h':
	    usage();
	    exit(0);
	    break;
	default:
	    usage();
	    exit(EXIT_CMD_LINE_ERR);
	};
    switch (argc - optind) {
    case 0:
	pf.fp = stdin;
	filename = "stdin";
	break;
    case 1:
	pf = psf_fopen(argv[optind], suffixes);
	filename = pf.name;
	break;
    default:
	usage();
	exit(EXIT_CMD_LINE_ERR);
    }

    write_til_init();

    mod = PSF_MALLOC(struct module);
    if (read_module(mod, 0, pf.fp)) {	/* 0 = itil */
	(void) fprintf(stderr, "%s: file %s contains no module\n", progname,
	    filename);
	exit(EXIT_SYNTAX_ERR);
    }
    if (mod->entries_table[PRM]) {
	for (i = 1; i <= mod->entries_table[PRM]; i++)
	    fprintf(stderr, "unbound parameter '%s' left\n", mod->par[i].ff);
	exit(1);
    }
    write_module(mod, stdout);

    /* until we can generate error messages, just exit with 0 */
    exit(0);
}
