#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_standards.h"
#include "tiltype.h"
#include "fieldex.h"
#include "prtilmcrlparts.h"

#ifndef NEWREADTIL
bool duplicate_names_allowed = FALSE;
#endif /* NEWREADTIL */

bool Option_skipnr = FALSE;

static struct module *current_module;
static FILE *output;

void set_print_current_module(mod)
    struct module *mod;
{
    current_module = mod;
}

void set_print_output_file(fp)
    FILE *fp;
{
    output = fp;
}

char *freeformat_name(table, key)
    tabletype table;
    keytype key;
{
    freeformat ff;

    switch (table) {
    case SOR:
	ff = current_module->sor[key].ff;
	break;
    case FUN:
	ff = current_module->fun[key].ff;
	break;
    case ATM:
	ff = current_module->atm[key].ff;
	break;
    case PRO:
	ff = current_module->pro[key].ff;
	break;
    case SET:
	ff = current_module->set[key].ff;
	break;
    case COM:
	ff = current_module->com[key].ff;
	break;
    case VAR:
	ff = current_module->var[key].ff;
	break;
    case EQU:
	ff = current_module->equ[key].ff;
	break;
    case DEF:
	ff = current_module->def[key].ff;
	break;
    }
    return ffname(ff, table, key);
}

void print_freeformat(table, key)
    tabletype table;
    keytype key;
{
	char *s = freeformat_name(table,key);
	fprintf(stdout, "%s", s);
	PSF_FREE(s);
}

static char opnum[] = "!@$%^&+*:?~/|\\_.";

#ifdef NEWREADTIL
char *ffname(ff, table, key)
    freeformat ff;
    tabletype table;
    keytype key;
{
    return field_extract("n", ff, table, key));
}

void print_ffname(ff, table, key)
    freeformat ff;
    tabletype table;
    keytype key;
{
    (void) fprintf(output, "%s", ffname(ff, table, key));
}
#else /* NEWREADTIL */

char *ffname(ff, table, key)
    freeformat ff;
    tabletype table;
    keytype key;
{
	char *s = PSF_NMALLOC(char,1024);
    char *p, *underscore, *post, *t, *lastp;
    bool operator, dot;
    int i;

    p = psf_strdup(field_extract("n", ff, table, key));
    if (duplicate_names_allowed) {
	post = psf_strdup(field_extract("o", ff, table, key));
	lastp = p + strlen(p) -1;
	operator = FALSE;
	dot = FALSE;
	if (table == FUN)
	    for (i = 0; i < sizeof opnum; i++)
		if (*p == opnum[i]) {
		    operator = TRUE;
		    break;
		}
	if (operator) {
	    if (*lastp == '_') {
		*lastp-- = '\0';
		if (*lastp == '.') {
		    *lastp-- = '\0';
		    underscore = "._";
		    dot = TRUE;
		} else
		    underscore = "_";
	    } else
		underscore = "";
	    if (!dot) {
		for (t = post; *t != '\0'; t++)
		    if (isalnum(*t))
			*t = opnum[(*t - '0') % 10];
	    }
	    (void) sprintf(s, "%s%c%s%s", p, *lastp == '-' ? '~' : '-',
							post, underscore);
	} else
	    (void) sprintf(s, "%s%c%s", p, *lastp=='-'?'~':'-', post);
	PSF_FREE(post);
    } else
	(void) sprintf(s, "%s", p);
    PSF_FREE(p);
	if (table == VAR) sprintf(s, "%s%d", s, key);
	return s;
}

void print_ffname(ff, table, key)
    freeformat ff;
    tabletype table;
    keytype key;
{
	char	*s = ffname(ff, table, key);

	fprintf(output, "%s", s);
	PSF_FREE(s);
}

#endif /* NEWREADTIL */

char *term_name(index)
    struct indextype index;
{
    freeformat ff;
    char *p, *lastp;
    char *name;

#ifndef NEWREADTIL
    char *post, *t, *underscore;
    bool operator, dot;
    int i;
#endif /* ! NEWREADTIL */

    switch (index.table) {
    case SOR:
	ff = current_module->sor[index.key].ff;
	break;
    case FUN:
	ff = current_module->fun[index.key].ff;
	break;
    case ATM:
	ff = current_module->atm[index.key].ff;
	break;
    case PRO:
	ff = current_module->pro[index.key].ff;
	break;
    case SET:
	ff = current_module->set[index.key].ff;
	break;
    case VAR:
	ff = current_module->var[index.key].ff;
	break;
    default:
	PSF_ASSERT(THIS_CANNOT_HAPPEN);
	break;
    }

    name = field_extract("n", ff, index.table, index.key);

#ifndef NEWREADTIL
    if (duplicate_names_allowed) {
	p = psf_strdup(name);
	lastp = p + strlen(p) - 1;
	post = psf_strdup(field_extract("o", ff, index.table, index.key));
	operator = FALSE;
	dot = FALSE;
	if (index.table == FUN)
	    for (i = 0; i < sizeof opnum; i++)
		if (*p == opnum[i]) {
		    operator = TRUE;
		    break;
		}
	if (operator) {
	    if (*lastp == '_') {
		*lastp-- = '\0';
		if (*lastp == '.') {
		    *lastp-- = '\0';
		    underscore = ".";
		    dot = TRUE;
		} else
		    underscore = "";
	    } else
		underscore = "";
	    if (!dot) {
		for (t = post; *t != '\0'; t++)
		    if (isalnum(*t))
			*t = opnum[(*t - '0') % (sizeof opnum - 1)];
	    }
	    (void) fprintf(output, "%s%c%s%s", p[0] == '_' ? p + 1 : p,
				*lastp == '-' ? '~' : '-', post, underscore);
	} else
	    (void) fprintf(output, "%s%c%s", p,
				*lastp == '-' ? '~' : '-', post);
	PSF_FREE(post);
    } else {
#endif /* ! NEWREADTIL */

	p = psf_strdup(name[0] == '_' ? name + 1 : name);
	lastp = p + strlen(p) - 1;
	if (*lastp == '_')
	    *lastp-- = '\0';
	if (p[0] == '_') p++;

#ifndef NEWREADTIL
    }
#endif /* ! NEWREADTIL */

    if (index.table == VAR) {
	PSF_FREE(p);
	p = PSF_NMALLOC(char, strlen(name) + 5 + 1); /* is 5 enough? */
	sprintf(p, "%s%d", name, index.key);
    }
    return p;
}

void print_term_name (index)
    struct indextype index;
{
	char	*s = term_name(index);
	fprintf(output,"%s",s);
	PSF_FREE(s);
}

void print_sorlist(a, ind, sep)
    arity a;
    struct indextype *ind;
    char *sep;
{
    int i;
    bool first;

    if (!a) return;
    first = TRUE;
	for (i = 0; i < a; i++) {
		if (!first)
			(void) fprintf(output, "%s", sep);
		else
			first = FALSE;
		print_freeformat(ind[i].table, ind[i].key);
    }
}

void printline()
{
    (void) fprintf(output, "\n");
}

static bool infix_operator(t, k)
    tabletype t;
    keytype k;
{
    if (t != FUN)
	return (FALSE);

#ifdef NEWTILPSF
    return field_extract("arity", current_module->fun[k].ff, t, k)[0] == '2';
#else /* NEWTILPSF */
    return field_extract("n", current_module->fun[k].ff, t, k)[0] == '_';
#endif /* NEWTILPSF */
}

char *cae_term(term)
    ae_term *term;
{
	char	*s = PSF_NMALLOC(char,1024);
	char	*t;
	int		i, infix;

    *s = '\0';
    if (term->t == TUPLE) {
		(void) sprintf(s, "%s<", s);
		for (i = 0; i < term->a; i++) {
		    if (i) (void) sprintf(s, "%s, ", s);
		    t = cae_term(&term->ae_list[i]);
			(void) sprintf(s, "%s%s", s, t);
			PSF_FREE(t);
		}
		(void) sprintf(s, "%s>",s);
    } else { 
		if (term->t != TERM) {
			PSF_ASSERT(THIS_CANNOT_HAPPEN);
	    } else {
			if (term->a == 0) {
				t = term_name(term->ind);
				(void) sprintf(s, "%s%s",s ,t);
				PSF_FREE(t);
			} else {
				if (infix_operator(term->ind.table, term->ind.key)) {
					infix = infix_operator(term->ae_list[0].ind.table,
	   						 term->ae_list[0].ind.key);
					if (infix) (void) sprintf(s, "%s(", s);
					t = cae_term(&term->ae_list[0]);
					(void) sprintf(s, "%s%s", s, t);
					PSF_FREE(t);
					if (infix) (void) sprintf(s, "%s)", s);
					(void) sprintf (s, "%s ", s);
					t = term_name(term->ind);
					(void) sprintf(s, "%s%s", s, t);
					PSF_FREE(t);
					(void) sprintf (s, "%s ", s);
					for (i = 1; i < term->a; i++) {
					    if (i > 1) (void) sprintf(s, "%s, ", s); 
						infix = infix_operator(term->ae_list[i].ind.table,
									term->ae_list[i].ind.key);
						if (infix) (void) sprintf(s, "%s(", s);
					    t = cae_term(&term->ae_list[i]);
						(void) sprintf(s, "%s%s", s, t);
						PSF_FREE(t);
					    if (infix) (void) sprintf(s, "%s)", s);
					}
				} else {
					t = term_name(term->ind);
					(void) sprintf(s, "%s%s", s, t);
					PSF_FREE(t);
					(void) sprintf(s, "%s(", s);
					for (i = 0; i < term->a; i++) {
					    if (i) (void) sprintf(s, "%s, ", s);
					    t = cae_term(&term->ae_list[i]);
						(void) sprintf(s, "%s%s", s, t);
						PSF_FREE(t);
					}
					(void) sprintf(s, "%s)", s);
				}
			}
		}
	}
	return s;
}

void print_ae_term(term)
    ae_term *term;
{
	char	*s = cae_term(term);

	fprintf(output,"%s",s);
	PSF_FREE(s);
}

void print_process_def(term)
    ae_term *term;
{
    int i;

    if (term->t != TERM)
		PSF_ASSERT(THIS_CANNOT_HAPPEN);
    else if (term->a == 0)
		print_term_name(term->ind);
    else {
		print_term_name(term->ind);
		(void) fprintf(output, "(");
		for (i = 0; i < term->a; i++) {
			if (i)
				fprintf(output, ", ");
			print_placeholder(term->ae_list[i].ind.key);
		}
		(void) fprintf(output, ")");
    }
}

static bool first_placeholder;
static int *var_placeholder;
static char *sep_placeholders;

void print_placeholder(key)
    keytype key;
{
    var_tuple *var_t;

    var_t = &current_module->var[key];
    print_ffname(var_t->ff, VAR, key);
    (void) fprintf(output, ":");
    print_freeformat(var_t->ind.table, var_t->ind.key);
}

void print_placeholders(term)
    ae_term *term;
{
    int i;

    if (term->ind.table == VAR) {
	if (!var_placeholder[term->ind.key]) {
	    if (first_placeholder) {
		(void) fprintf(output, "%s",
			       sep_placeholders);
		first_placeholder = FALSE;
	    } else
		(void) fprintf(output, ", ");
	    print_placeholder(term->ind.key);
	    var_placeholder[term->ind.key] = 1;
	}
    }
    if (term->a) {
	for (i = 0; i < term->a; i++)
	    print_placeholders(&term->ae_list[i]);
    }
}

static int *MarkVariable;

void mark_placeholders(mod)
    struct module *mod;
{
    unsigned int ent;
    int i, j;

    ent = mod->entries_table[VAR];
    MarkVariable = PSF_NMALLOC(int, ent + 1);
    for (i = 0; i <= ent; i++)
	MarkVariable[i] = 0;

    ent = mod->entries_table[SET];
    for (i = 1; i <= ent; i++) {
	if (/*mod->set[i].defined &&*/ mod->set[i].u_tag)
	    mark_s_term(&mod->set[i].construct.set_term);
    }

    ent = mod->entries_table[COM];
    for (i = 1; i <= ent; i++) {
/*
	if (mod->com[i].defined) {
*/
	    mark_ae_term(&mod->com[i].aet[0]);
	    mark_ae_term(&mod->com[i].aet[1]);
	    mark_ae_term(&mod->com[i].aet[2]);
/*
	}
*/
    }

    ent = mod->entries_table[DEF];
    for (i = 1; i <= ent; i++) {
/*
	if (mod->def[i].defined)
*/
	    mark_process_expr(&mod->def[i].p_expr);
    }

    ent = mod->entries_table[EQU];
    for (i = 1; i <= ent; i++) {
/*
	if (mod->equ[i].defined) {
*/
	    unmark_ae_term(&mod->equ[i].aet1);
	    unmark_ae_term(&mod->equ[i].aet2);
	    if (mod->equ[i].a) {
		for (j = 0; j < mod->equ[i].a; j++) {
		    unmark_ae_term(&mod->equ[i].guard[j].aet1);
		    unmark_ae_term(&mod->equ[i].guard[j].aet2);
		}
	    }
/*
	}
*/
    }
}

void mark_s_term(term)
    struct s_term *term;
{
    int i;

    for (i = 0; i < term->a; i++) {
	if (term->u_tag[i] == 0)
	    mark_ae_term(term->arr[i].ae_t);
	else
	    mark_s_term(term->arr[i].s_t);
    }
}

void mark_ae_term(term)
    ae_term *term;
{
    int i;

    if (term->ind.table == VAR)
	MarkVariable[term->ind.key] = 1;
    for (i = 0; i < term->a; i++)
	mark_ae_term(&term->ae_list[i]);
}

void mark_process_expr(pe)
    struct process_expr *pe;
{
    int i;
    unsigned int narg;

    switch (pe->fun) {
    case SKP:
	break;
    case ALT:
    case SEQ:
    case PAR:
    case INTR:
    case DISR:
    case STAR:
    case SHARP:
	narg = pe->proc_expr.pe3.a;
	for (i = 0; i < narg; i++)
	    mark_process_expr(&pe->proc_expr.pe3.pe[i]);
	break;
    case SUM:
    case MRG:
	MarkVariable[pe->proc_expr.pe1.ind.key] = 1;
	mark_process_expr(pe->proc_expr.pe1.pe);
    case ENC:
    case HID:
	mark_process_expr(pe->proc_expr.pe1.pe);
	break;
    case DLK:
	break;
    case IF:
	mark_process_expr(pe->proc_expr.pe4.pe);
	break;
    case PRIO:
	mark_process_expr(pe->proc_expr.pe5.pe);
	break;
    case AET:
	break;
    }
}

void unmark_ae_term(term)
    ae_term *term;
{
    int i;

    if (term->ind.table == VAR)
	MarkVariable[term->ind.key] = 0;
    for (i = 0; i < term->a; i++)
	unmark_ae_term(&term->ae_list[i]);
}

char *cs_term(term)
    struct s_term *term;
{
    int i;
    bool first;
	char *s;
	char *t = PSF_NMALLOC(char, 1024);

    if (term->fun == ENU)
		(void) sprintf(t,"{");
    first = TRUE;
    for (i = 0; i < term->a; i++) {
		if (first)
			first = FALSE;
		else {
			if (term->fun == ENU)
				(void) sprintf(t, "%s,", t);
			else
				(void) sprintf(t, "%s%c", t, term->fun);
		}
		if (term->u_tag[i] == 0)
			s = term_name(term->arr[i].ae_t->ind);
		else
			s = cs_term(term->arr[i].s_t);
		sprintf(t,"%s%s", t, s);
		PSF_FREE(s);
    }
    if (term->fun == ENU) {
		(void) sprintf(t, "%s}", t);
    }
	return t;
}

void print_s_term(term)
    struct s_term *term;
{
	char *s = cs_term(term);
	fprintf(output, "%s", s);
	PSF_FREE(s);
}

void print_sor_tuple(tuple, key)
    sor_tuple *tuple;
    keytype key;
{
    print_ffname(tuple->ff, SOR, key);
}

void print_fun_tuple(tuple, key)
    fun_tuple *tuple;
    keytype key;
{

#ifdef NEWREADTIL
    switch (get_ff_field("arity", tuple->ff)[0]) {
	case '0':
	    print_ffname(tuple->ff, FUN, key);
	    break;
	case '1':
	    print_ffname(tuple->ff, FUN, key);
	    (void) fprintf(output, "_");
	    break;
	case '2':
	    (void) fprintf(output, "_");
	    print_ffname(tuple->ff, FUN, key);
	    (void) fprintf(output, "_");
	    break;
	default:
	    PSF_ASSERT(THIS_CANNOT_HAPPEN);
    }
#else /* NEWREADTIL */
    print_ffname(tuple->ff, FUN, key);
#endif /* NEWREADTIL */

    (void) fprintf(output, " :");
	if (tuple->sor_indlist.a) (void) fprintf(output, " ");
    print_sorlist(tuple->sor_indlist.a,
		  tuple->sor_indlist.indlist, "#");
	(void) fprintf(output, " -> ");
    print_sorlist(tuple->return_list.a,
		  tuple->return_list.indlist, "#");
}

char *cset_tuple(tuple,key)
	set_tuple *tuple;
    keytype	key;
{
	char *u = PSF_NMALLOC(char,1024);
	char *v = PSF_NMALLOC(char,1024);
	char *r,*s,*t;

	if (tuple[key].u_tag)
		s = cs_term(&tuple[key].construct.set_term);
	else
		s = freeformat_name(tuple[key].construct.sort.table,
				 tuple[key].construct.sort.key);
	/* remove duplicates... */
	t = s;
	(void)sprintf(u,"{");
	for (r = strtok((char *)(t+1),",}"); r; r = strtok(NULL,",}")) {
		sprintf(v,"%s,",r);
		if (strstr(u,v) == NULL) sprintf(u,"%s%s",u,v);
	}
	PSF_FREE(s);
	PSF_FREE(v);
	s = (char *)strrchr(u,',');
    *s = '}';
	return u;
}

void print_set_tuple(tuple,key)
	set_tuple *tuple;
    keytype	key;
{
	char *s = cset_tuple(tuple,key);
	fprintf(output, "%s", s);
	PSF_FREE(s);
}

void print_atmpro_tuple(tuple, table, key)
    atm_tuple *tuple;
    tabletype table;
    keytype key;
{
    print_ffname(tuple->ff, table, key);
    if (tuple->sor_indlist.a) {
	(void) fprintf(output, " : ");
	print_sorlist(tuple->sor_indlist.a,
		      tuple->sor_indlist.indlist, "#");
    }
}

void print_exp_section(mod)
    struct module *mod;
{
    sor_tuple *sor_t;
    fun_tuple *fun_t;
    int i;
    bool first;
    unsigned int ent;

    sor_t = mod->sor;
    if (ent = mod->entries_table[SOR]) {
		first = TRUE;
		for (i = 1; i <= ent; i++)
		    if (sor_t[i].ff != NULL) {
				if (first) {
				    (void) fprintf(output, "sort\n");
					first = FALSE;
				}
				(void) fprintf(output, "  ");
				print_sor_tuple(&sor_t[i], i);
				fprintf(output, "\n");
		    }
		if (!first) printline();
	}
    fun_t = mod->fun;
    if (ent = mod->entries_table[FUN]) {
		first = TRUE;
		for (i = 1; i <= ent; i++)
		    if (fun_t[i].ff != NULL) {
				if (first) {
				    (void) fprintf(output, "func\n");
					first = FALSE;
				}
				(void) fprintf(output, "  ");
				print_fun_tuple(&fun_t[i], i);
				printline();
		    }
		if (!first) printline();
	}
}

void print_sor_section(ent, tuple)
    unsigned int ent;
    sor_tuple *tuple;
{
    int i;
    bool first;

    if (!ent) return;
    first = TRUE;
    for (i = 1; i <= ent; i++)
	if (tuple[i].ff != NULL) {
	    if (first) {
			(void) fprintf(output, "sort\n");
			first = FALSE;
		}
	    (void) fprintf(output, "  ");
	    print_sor_tuple(&tuple[i], i);
	    fprintf(output, "\n");
	}
    if (! first) printline();
}

void print_fun_section(ent, tuple)
    unsigned int ent;
    fun_tuple *tuple;
{
    int i;
	bool first;

    if (!ent) return;
    first = TRUE;
    for (i = 1; i <= ent; i++)
	if (tuple[i].ff != NULL) {
	    if (first) {
			(void) fprintf(output, "func\n");
			first = FALSE;
		}
	    (void) fprintf(output, "  ");
	    print_fun_tuple(&tuple[i], i);
	    printline();
	}
    if (! first) printline();
}

void print_atmpro_tuples(ent, tuple, id, table)
    unsigned int ent;
    atm_tuple *tuple;
    char *id;
    tabletype table;
{
    int i;
	bool first;

    if (!ent) return;
    first = TRUE;
    for (i = 1; i <= ent; i++)
	if (tuple[i].ff != NULL) {
	    if (first) {
			(void) fprintf(output, "%s\n", id);
			first = FALSE;
		}
	    (void) fprintf(output, "  ");
	    print_atmpro_tuple(&tuple[i], table, i);
	    printline();
	}
    if (! first) printline();
}

void print_act_section(ent, tuple)
    unsigned int ent;
    atm_tuple *tuple;
{
    print_atmpro_tuples(ent, tuple, "act", ATM);
}

void print_pro_section(ent, tuple)
    unsigned int ent;
    pro_tuple *tuple;
{
    print_atmpro_tuples(ent, tuple, "processes", PRO);
}

void print_com_section(ent, tuple)
    unsigned int ent;
    com_tuple *tuple;
{
    int i;

    if (!ent) return;
    (void) fprintf(output, "comm\n");
    for (i = 1; i <= ent; i++)
	if (tuple[i].ff != NULL) {
	    (void) fflush(output);
	    (void) fprintf(output, "  ");
	    print_term_name(tuple[i].aet[0].ind);
	    (void) fprintf(output, " | ");
	    print_term_name(tuple[i].aet[1].ind);
	    (void) fprintf(output, " = ");
	    print_term_name(tuple[i].aet[2].ind);
	    (void) fflush(output);
	    printline();
	}
    printline();
}

int check_mod_type(ff, c, table, key)
    freeformat ff;
    int c;
    tabletype table;
    keytype key;
{
    unsigned int ent;
    keytype i;
    char *p;
    unsigned int onr, mnr;

    p = field_extract("o", ff, table, key);
    if (sscanf(p, "%u", &onr) != 1)
	onr = 0;
    ent = current_module->entries_table[ADM];
    for (i = 1; i <= ent; i++)
	if (current_module->adm[i].ff != NULL) {
	    if (!(p = field_extract("m", current_module->adm[i].ff, ADM, i)))
		continue;
	    if (sscanf(p, "%u", &mnr) != 1)
		mnr = 0;
	    if (onr != mnr)
		continue;
	    p = field_extract("t", current_module->adm[i].ff, ADM, i);
	    while (*p == ' ')
		p++;
	    if (*p == c)
		return (1);
	}
    return (0);
}

void print_var_section(ent, tuple, type)
    unsigned int ent;
    var_tuple *tuple;
    int type;
{
    int i;
    bool first;

    if (!ent) return;
    first = TRUE;
    for (i = 1; i <= ent; i++)
	if (tuple[i].ff != NULL) {
	    if (MarkVariable[i]) continue;
/*	    if (!check_mod_type(tuple[i].ff, type, VAR, i)) continue; */
	    if (first) {
			(void) fprintf(output, "var\n");
			first = FALSE;
		}
	    (void) fprintf(output, "  ");
	    print_ffname(tuple[i].ff, VAR, i);
	    (void) fprintf(output, " : ");
	    print_freeformat(tuple[i].ind.table, tuple[i].ind.key);
	    printline();
	}
    if (! first) printline();
}

void print_equation(aet1, aet2)
    ae_term *aet1;
    ae_term *aet2;
{
    print_ae_term(aet1);
    (void) fprintf(output, " = ");
    print_ae_term(aet2);
}

void print_rew_section(ent, tuple)
    unsigned int ent;
    equ_tuple *tuple;
{
    int i;

    if (!ent) return;
    (void) fprintf(output, "rew\n");
    for (i = 1; i <= ent; i++)
	if (tuple[i].ff != NULL) {
	    (void) fprintf(output, "  ");
	    print_equation(&tuple[i].aet1, &tuple[i].aet2);
	    printline();
	}
    printline();
}

static int precedence(fun)
char fun;
{
    switch (fun) {
    case ALT:
	return(1);
    case MRG:
    case STAR:
    case SHARP:
	return(2);
    case SEQ:
	return(3);
    case AET:
	return(5); /* highest */
    default:
	return(4);
    }
}

void print_process_expr(pe)
    struct process_expr *pe;
{
    struct process_expr *pexpr;
    bool hook;
	bool fclause;
	char *t;

    switch (pe->fun) {
    case SKP:
	(void) fprintf(output, "tau");
	if (Option_skipnr)
	    (void) fprintf(output, "<%u>", pe->proc_expr.nr);
	break;
    case ALT:
	print_process_expr(&pe->proc_expr.pe3.pe[0]);
	(void) fprintf(output, "+");
	print_process_expr(&pe->proc_expr.pe3.pe[1]);
	break;
    case SEQ:
	if (precedence(pe->proc_expr.pe3.pe[0].fun) < precedence(pe->fun)) {
	    hook = TRUE;
	    (void) fprintf(output, "(");
	} else
	    hook = FALSE;
	print_process_expr(&pe->proc_expr.pe3.pe[0]);
	if (hook)
	    (void) fprintf(output, ")");
	fprintf(output, ".");
	if (precedence(pe->proc_expr.pe3.pe[1].fun) <= precedence(pe->fun)) {
	    hook = TRUE;
	    (void) fprintf(output, "(");
	} else
	    hook = FALSE;
	print_process_expr(&pe->proc_expr.pe3.pe[1]);
	if (hook)
	    (void) fprintf(output, ")");
	break;
    case PAR:
	if (precedence(pe->proc_expr.pe3.pe[0].fun) < precedence(pe->fun)) {
	    hook = TRUE;
	    (void) fprintf(output, "(");
	} else
	    hook = FALSE;
	print_process_expr(&pe->proc_expr.pe3.pe[0]);
	if (hook)
	    (void) fprintf(output, ")");
	fprintf(output, "||");
	if (precedence(pe->proc_expr.pe3.pe[1].fun) <= precedence(pe->fun)) {
	    hook = TRUE;
	    (void) fprintf(output, "(");
	} else
	    hook = FALSE;
	print_process_expr(&pe->proc_expr.pe3.pe[1]);
	if (hook)
	    (void) fprintf(output, ")");
	break;
    case SUM:
	(void) fprintf(output, "sum(");
	print_placeholder(pe->proc_expr.pe1.ind.key);
	(void) fprintf(output, ", ");
	print_process_expr(pe->proc_expr.pe1.pe);
	(void) fprintf(output, ")");
	break;
    case ENC:
	(void) fprintf(output, "encap(");
	print_set_tuple(current_module->set,pe->proc_expr.pe1.ind.key);
	(void) fprintf(output, ", ");
	print_process_expr(pe->proc_expr.pe1.pe);
	(void) fprintf(output, ")");
	break;
    case HID:
	(void) fprintf(output, "hide(");
	print_set_tuple(current_module->set,pe->proc_expr.pe1.ind.key);
	(void) fprintf(output, ", ");
	print_process_expr(pe->proc_expr.pe1.pe);
	(void) fprintf(output, ")");
	break;
    case DLK:
	(void) fprintf(output, "delta");
	break;
    case IF:
	pexpr = pe->proc_expr.pe4.pe;
	t = cae_term(&pe->proc_expr.pe4.aey);
	/* check if it's true ("T") or false ("F") */
	fclause = !strcmp(t,"F");
	PSF_FREE(t);
	if (fclause) {
		fprintf(output,"delta");
	} else { 
		if (pexpr->fun == ALT || pexpr->fun == SEQ ||
			pexpr->fun == PAR) {
		    hook = TRUE;
		    (void) fprintf(output, "(");
		} else
		    hook = FALSE;
		print_process_expr(pe->proc_expr.pe4.pe);
		if (hook)
		    (void) fprintf(output, ")");
	};
	fprintf(output,"<|");
	print_ae_term(&pe->proc_expr.pe4.aex);
	fprintf(output,"|>");
	if (fclause) { 
		if (pexpr->fun == ALT || pexpr->fun == SEQ ||
			pexpr->fun == PAR) {
		    hook = TRUE;
		    (void) fprintf(output, "(");
		} else
		    hook = FALSE;
		print_process_expr(pe->proc_expr.pe4.pe);
		if (hook)
		    (void) fprintf(output, ")");
	} else { 
		fprintf(output,"delta");
	};
	break;
    case PRIO:
	(void) fprintf(output, "prio(");
	print_sorlist(pe->proc_expr.pe5.sets.a, pe->proc_expr.pe5.sets.indlist,
	    ">");
	(void) fprintf(output, ", ");
	print_process_expr(pe->proc_expr.pe5.pe);
	(void) fprintf(output, ")");
	break;
    case AET:
	print_ae_term(&pe->proc_expr.pe2);
	break;
    }
}

void print_def_section(ent, tuple)
    unsigned int ent;
    def_tuple *tuple;
{
    int i;

    if (!ent) return;
    (void) fprintf(output, "proc\n");
    for (i = 1; i <= ent; i++)
	if (tuple[i].ff != NULL) {
	    (void) fprintf(output, "  ");
	    print_process_def(&tuple[i].ae_t);
	    (void) fprintf(output, " = ");
	    print_process_expr(&tuple[i].p_expr);
	    printline();
	}
    printline();
}
