#include <stdio.h>
#include "psf_prototype.h"
#include "psf_fopen.h"
#include "psf_exits.h"
#include "psf_standards.h"
#include "psf_malloc.h"
#include "env_variables.h"
#include "tiltype.h"
#include "readtil.h"
#include "prtilmcrl.h"
#include "version.h"
#include "main.h"

char *progname;
char *filename = "stdin";	/* default */

static void version()
{
    fprintf(stderr, "til_mcrl version %s, last compiled %s\n", VERSION,
	    __DATE__);
}

static void usage()
{
    fprintf(stderr, "usage: %s [-vh] [til-file] \n", progname);
}


static void til_to_mcrl(fp)
    FILE *fp;
{
    struct module *mod;

    mod = PSF_MALLOC(struct module);
    if (read_module(mod, fp)) {
	fprintf(stderr, "error in input\n");
	exit(EXIT_SYNTAX_ERR);
    }
    print_mcrl(mod,stdout);
}

int main(argc, argv)
    int argc;
    char *argv[];
{
    psf_file pf;
    int c;
    extern int optind;
    static suffix suffixes[] = {{TILSUFFIX, TILSUFFIX_DEFAULT}, {NULL, NULL}};

    if (argc == 0) {
	(void) fprintf(stderr, "who am I ?\n");
	exit(EXIT_HELP);
    };

    progname = psf_basename(argv[0]);


    while ((c = getopt(argc, argv, "hv")) != EOF)
	switch (c) {
	case 'v':
	    version();
	    break;
	case 'h':
	    usage();
	    exit(EXIT_SUCCESS);
	    break;
	default:
	    usage();
	    exit(EXIT_CMD_LINE_ERR);
	};
    if (optind > argc)
	exit(EXIT_CMD_LINE_ERR);
    if (optind == argc)
	pf.fp = stdin;
    else {
	pf = psf_fopen(argv[optind], suffixes);
	filename = pf.name;
    }

    til_to_mcrl(pf.fp);
	return EXIT_SUCCESS;
}
