#define	ALT	1	/* alternative composition */
#define	PAR	2	/* parallel composition */
#define	LMG	3	/* left merge */
#define	CMG	4	/* communication merge */
#define	HIF	5	/* Hoare's if */
#define	SEQ	6	/* sequential composition */
#define	DLK	7	/* delta/deadlock */
#define	TAU	8	/* tau/silent step */
#define	REN	9	/* renaming */
#define	SUM	10	/* summation */
#define	PRY	11	/* process 'call' with parameters */
#define	PRN	12	/* process 'call' without parameters */
#define ENC	13	/* encapsulation operator */
#define HID	14	/* abstraction operator */

#define SRT	1	/* sort specification */
#define FNC	2	/* function specification */
#define REW	3	/* rewrite specification */
#define ACT	4	/* atomic action specification */
#define CMM	5	/* communication specification */
#define PRC	6	/* process specification */


struct specification {
  int 	type;
  DLL	spec;
};

struct data_term {
  OBJ_PTR	head;
  DLL		arg;
};

struct func_decl {
  DLL		functions;
  DLL		input_type;
  OBJ_PTR	output_type;
};

struct comm_decl {
  OBJ_PTR	left;
  OBJ_PTR 	right;
  OBJ_PTR 	result;
};	

struct act_decl {
  DLL	actions;
  DLL	type;
};

struct proc_expr {
  int			class;
  struct proc_expr 	*pe1;
  struct proc_expr 	*pe2;
  DLL			list;
};

struct proc_decl {
  OBJ_PTR		process;
  DLL			vars;
  struct proc_expr*	expr;
};

struct renaming {
  OBJ_PTR	from;
  OBJ_PTR	to;
};

extern int yyparse PROTO_ARGS((void));
extern int yylex PROTO_ARGS((void));
