/* type checker include file */

struct fun_info {
    OBJ_PTR obj;
    int arity;
    int *i_type;
    int o_type;
};


struct atm_info {
    OBJ_PTR obj;
    int arity;
    int *type;
};


struct pro_info {
    OBJ_PTR obj;
    int arity;
    int *type;
};


struct var_info {
    char *name;
    int type;
    int index;
};


struct com_info {
    int line;
    int left;
    int right;
    int result;
};

struct set_info {
    int length;
    int *set;
};

struct equ_info {
    struct data_term *lhs;
    struct data_term *rhs;
};


#define	ADM	0
#define	SOR	1
#define	FUN	2
#define	ATM	3
#define	PRO	4
#define	SET	5
#define	COM	6
#define	VAR	7
#define	EQU	8
#define	DEF	9

#define TIL_ENTRIES	10
#define NOT_FOUND	-1


/* functions */

/* typecheck.c */
extern void count_objects PROTO_ARGS((void));
extern int find_sort PROTO_ARGS((char *name));
extern void type_sorts PROTO_ARGS((void));
extern int find_function PROTO_ARGS((char *name, int arity, int *itype));
extern void type_Booleans PROTO_ARGS((void));
extern void type_functions PROTO_ARGS((void));
extern int find_atom PROTO_ARGS((char *name, int arity, int *type));
extern void type_actions PROTO_ARGS((void));
extern int find_process PROTO_ARGS((char *name, int arity, int *type));
extern DLL_ITEM find_var_name PROTO_ARGS((char *name, DLL var_list_list));
extern void unique_var_names PROTO_ARGS((DLL var_list_list));
extern void type_processes PROTO_ARGS((void));
extern int *all_atoms PROTO_ARGS((char *name));
extern int equal_type PROTO_ARGS((int x, int y));
extern void print_type PROTO_ARGS((int *type, int len));
extern void comm_compatible PROTO_ARGS((int line, int *s, int *r, int *c));
extern void init_varlist PROTO_ARGS((void));
extern int add_variable PROTO_ARGS((char *name, int type));
extern int var_index PROTO_ARGS((int type, DLL_ITEM ptr));
extern void print_variable_table PROTO_ARGS((void));
extern void type_variables PROTO_ARGS((void));
extern void comm_consistency PROTO_ARGS((void));
extern void type_sets PROTO_ARGS((void));
extern void type_communications PROTO_ARGS((void));
extern int find_variable PROTO_ARGS((char *name, int type));
extern void delete_from_scope PROTO_ARGS((void));
extern void print_scope PROTO_ARGS((void));
extern int var_in_scope PROTO_ARGS((char *name));
extern void add_to_scope PROTO_ARGS((DLL list));
extern int type_data_term PROTO_ARGS((struct data_term *trm));
extern void type_equations PROTO_ARGS((void));
extern void issue_warning PROTO_ARGS((int class, int line));
extern void type_var_list PROTO_ARGS((DLL list));
extern void type_proc_expr PROTO_ARGS((struct proc_expr *expr, int line));
extern void type_definitions PROTO_ARGS((void));
extern void empty_sort_check PROTO_ARGS((void));
extern void print_assoc PROTO_ARGS((int a1, int a2, int a3, int res));
extern void comm_assoc_check PROTO_ARGS((void));
extern void clear_counters PROTO_ARGS((void));
extern void alloc_tables PROTO_ARGS((void));
extern void type_check PROTO_ARGS((void));
