#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "dll.h"
#include "symtab.h"
#include "ystructs.h"
#include "typecheck.h"
#include "tabout.h"

extern DLL object_table;
extern DLL parse_table;
extern int counter[];
extern void **til[];
extern DLL variables;
extern int Bool_index, True_index, False_index;




void print_modules()
{
    (void) fprintf(stdout, "[0.1]\t{ <m>1 mu-CRL <t>m <language>mcrl }\n");
}


void print_sorts()
{
    int i;

    for (i = 1; i <= counter[SOR]; i++) {
	(void) fprintf(stdout, "[%d.%d]\t{ <n>%s <o>1 }\n", SOR, i, ((OBJ_PTR) til[SOR][i])->name);
    }
}


void print_functions()
{
    int i, j;
    struct fun_info *the_fun;

    for (i = 1; i <= counter[FUN]; i++) {
	the_fun = (struct fun_info *) til[FUN][i];
	(void) fprintf(stdout, "[%d.%d]\t%2d ", FUN, i, the_fun->arity);
	for (j = 0; j < the_fun->arity; j++) {
	    (void) fprintf(stdout, "[%d.%d] ", SOR, the_fun->i_type[j]);
	}
	(void) fprintf(stdout, "1 [%d.%d]\t{ <n>%s <o>1 }\n",
		       SOR, the_fun->o_type, the_fun->obj->name);
    }
}


void print_actions()
{
    int i, j;
    struct atm_info *the_act;

    for (i = 1; i <= counter[ATM]; i++) {
	the_act = (struct atm_info *) til[ATM][i];
	(void) fprintf(stdout, "[%d.%d]\t%2d ", ATM, i, the_act->arity);
	for (j = 0; j < the_act->arity; j++) {
	    (void) fprintf(stdout, "[%d.%d] ", SOR, the_act->type[j]);
	}
	(void) fprintf(stdout, "\t{ <n>%s <o>1 }\n", the_act->obj->name);
    }
}


void print_processes()
{
    int i, j;
    struct pro_info *the_pro;

    for (i = 1; i <= counter[PRO]; i++) {
	the_pro = (struct pro_info *) til[PRO][i];
	(void) fprintf(stdout, "[%d.%d]\t%2d ", PRO, i, the_pro->arity);
	for (j = 0; j < the_pro->arity; j++) {
	    (void) fprintf(stdout, "[%d.%d] ", SOR, the_pro->type[j]);
	}
	(void) fprintf(stdout, "\t{ <n>%s <o>1 }\n", the_pro->obj->name);
    }
}


static int *make_arg_index(t, n)
    int *t;
    int n;
{
    int *argindex;
    int i;
    char *s;

    argindex = PSF_NMALLOC(int, n);
    for (i = 0; i < n; i ++) {
	s = PSF_NMALLOC(char, 4);
	sprintf(s, "#%d", i);
	argindex[i] = add_variable(s, t[i]);
    }
    return(argindex);
}

void print_open_atom(index, argindex)
    int index;
    int *argindex;
{
    struct atm_info *atom;
    int i, the_var;

    atom = (struct atm_info *) til[ATM][index];
    (void) fprintf(stdout, "[%d.%d]", ATM, index);
    if (atom->arity == 0) {
	(void) fprintf(stdout, " ");
    } else {
	(void) fprintf(stdout, "(");
	for (i = 0; i < atom->arity; i++) {
	    (void) fprintf(stdout, "[%d.%d] ", VAR, argindex[i]);
	}
	(void) fprintf(stdout, ")");
    }
}


void print_sets()
{
    int i, j;
    struct set_info *the_set;
    int *argindex;
    struct atm_info *the_atm;

    for (i = 1; i <= counter[SET]; i++) {
	the_set = (struct set_info *) til[SET][i];
	(void) fprintf(stdout, "[%d.%d]\t", SET, i);
	(void) fprintf(stdout, "[1.0] <:,%d>(", the_set->length);
	for (j = 0; j < the_set->length; j++) {
	    the_atm = (struct atm_info *) til[ATM][the_set->set[j]];
	    argindex = make_arg_index(the_atm->type, the_atm->arity);
	    print_open_atom(the_set->set[j], argindex);
	    PSF_FREE(argindex);
	    /*
	     * (void)fprintf(stdout,"[%d.%d] ",ATM,the_set->set[j]);
	     */
	}
	(void) fprintf(stdout, ")\t{ <n>mu-CRL-Set-%d <o>1 }\n", i);
    }
}


void print_communications()
{
    int i;
    struct com_info *the_com;
    int *argindex;
    struct atm_info *the_atm;

    for (i = 1; i <= counter[COM]; i++) {
	the_com = (struct com_info *) til[COM][i];
	(void) fprintf(stdout, "[%d.%d]\t", COM, i);
	the_atm = (struct atm_info *) til[ATM][the_com->left];
	argindex = make_arg_index(the_atm->type, the_atm->arity);
	print_open_atom(the_com->left, argindex);
	print_open_atom(the_com->right, argindex);
	print_open_atom(the_com->result, argindex);
	PSF_FREE(argindex);
	(void) fprintf(stdout, "\t{ <o>1 }\n");
    }
}


void print_variables()
{
    DLL_ITEM ptr;
    int ad_hoc = 0;
    struct var_info *the_var;

    DLL_FORALL(variables, ptr) {
	the_var = (struct var_info *) dll_inspect(ptr);
	(void) fprintf(stdout, "[%d.%d]\t[%d.%d]\t{ <n>", VAR, the_var->index, SOR, the_var->type);

	if (the_var->name[0] == '#') {	/* ad hoc variable */
	    (void) fprintf(stdout, "mu-CRL-%d", ad_hoc++);
	} else {
	    (void) fprintf(stdout, "%s", the_var->name);
	}

	(void) fprintf(stdout, " <o>1 }\n");

    }
}


void print_data_term(trm)
    struct data_term *trm;
{
    DLL_ITEM ptr;
    int cnt = 0;

    (void) fprintf(stdout, "[%d.%d] ", trm->head->class, trm->head->index);
    DLL_FORALL(trm->arg, ptr) {
	if (cnt == 0) {
	    (void) fprintf(stdout, "(");
	}
	cnt++;
	print_data_term((struct data_term *) dll_inspect(ptr));
    }
    if (cnt != 0) {
	(void) fprintf(stdout, ")");
    }
}


void print_equations()
{
    int i;
    struct equ_info *the_equ;

    for (i = 1; i <= counter[EQU]; i++) {
	the_equ = (struct equ_info *) til[EQU][i];
	(void) fprintf(stdout, "[%d.%d]\t", EQU, i);
	print_data_term(the_equ->lhs);
	(void) fprintf(stdout, " = ");
	print_data_term(the_equ->rhs);
	(void) fprintf(stdout, "\t{ <n>[Eq-%d] <o>1 }\n", i);
    }
}


void print_proc_expr(expr)
    struct proc_expr *expr;
{
    DLL the_args, list;
    DLL_ITEM ptr, ptr1;
    struct data_term *the_term;
    int the_index;
    OBJ_PTR the_obj;

    switch (expr->class) {
    case ALT:
	(void) fprintf(stdout, "<alt,2>(");
	print_proc_expr(expr->pe1);
	(void) fprintf(stdout, " ");
	print_proc_expr(expr->pe2);
	(void) fprintf(stdout, ")");
	break;
    case PAR:
	(void) fprintf(stdout, "<par,2>(");
	print_proc_expr(expr->pe1);
	(void) fprintf(stdout, " ");
	print_proc_expr(expr->pe2);
	(void) fprintf(stdout, ")");
	break;
    case SEQ:
	(void) fprintf(stdout, "<seq,2>(");
	print_proc_expr(expr->pe1);
	(void) fprintf(stdout, " ");
	print_proc_expr(expr->pe2);
	(void) fprintf(stdout, ")");
	break;
    case DLK:
	(void) fprintf(stdout, "<delta>");
	break;
    case TAU:
	(void) fprintf(stdout, "<skip>");
	break;
    case ENC:
	the_index = (int) dll_inspect(dll_go_first(expr->list));
	(void) fprintf(stdout, "<encaps>([5.%d] ", the_index);
	print_proc_expr(expr->pe1);
	(void) fprintf(stdout, ")");
	break;
    case HID:
	the_index = (int) dll_inspect(dll_go_first(expr->list));
	(void) fprintf(stdout, "<hide>([5.%d] ", the_index);
	print_proc_expr(expr->pe1);
	(void) fprintf(stdout, ")");
	break;
    case SUM:
	ptr = dll_go_first(expr->list);
	list = (DLL) dll_inspect(ptr);
	ptr1 = dll_go_first(list);
	ptr1 = dll_go_fw((DLL_ITEM) list);
	the_obj = (OBJ_PTR) dll_inspect(ptr1);
	(void) fprintf(stdout, "<sum>([%d.%d] ", the_obj->class, the_obj->index);
	print_proc_expr(expr->pe1);
	(void) fprintf(stdout, ")");
	break;
    case PRY:
    case PRN:

	ptr = dll_go_first(expr->list);
	the_obj = (OBJ_PTR) dll_inspect(ptr);
	ptr = dll_go_fw(ptr);
	the_args = (DLL) dll_inspect(ptr);

	(void) fprintf(stdout, "[%d.%d]", the_obj->class, the_obj->index);

	if (dll_count(the_args)) {
	    (void) fprintf(stdout, "(");
	    DLL_FORALL(the_args, ptr1) {
		print_data_term((struct data_term *) dll_inspect(ptr1));
	    }
	    (void) fprintf(stdout, ")");
	}
	break;
    case HIF:
	ptr = dll_go_first(expr->list);
	the_term = (struct data_term *) dll_inspect(ptr);
	(void) fprintf(stdout, "<alt,2>(<if>(");
	print_data_term(the_term);
	(void) fprintf(stdout, " [%d.%d] ", FUN, True_index);
	print_proc_expr(expr->pe1);
	(void) fprintf(stdout, ") <if>(");
	print_data_term(the_term);
	(void) fprintf(stdout, " [%d.%d] ", FUN, False_index);
	print_proc_expr(expr->pe2);
	(void) fprintf(stdout, "))");
	break;
	/* the following constructs do NOT exist in TIL, but for uniformity ... */
    case LMG:
	(void) fprintf(stdout, "<lmrg,2>(");
	print_proc_expr(expr->pe1);
	(void) fprintf(stdout, " ");
	print_proc_expr(expr->pe2);
	(void) fprintf(stdout, ")");
	break;
    case CMG:
	(void) fprintf(stdout, "<cmrg,2>(");
	print_proc_expr(expr->pe1);
	(void) fprintf(stdout, " ");
	print_proc_expr(expr->pe2);
	(void) fprintf(stdout, ")");
	break;
    case REN:
	the_index = (int) dll_inspect(dll_go_first(expr->list));
	(void) fprintf(stdout, "<rename>([5.%d] ", the_index);
	print_proc_expr(expr->pe1);
	(void) fprintf(stdout, ")");
	break;
    default:
	break;
    }
}


void print_definitions()
{
    DLL_ITEM ptr, ptr1, ptr2, ptr3;
    DLL var_def;
    struct specification *spec;
    struct proc_decl *the_def;
    int def_cnt = 0;
    OBJ_PTR the_var;

    DLL_FORALL(parse_table, ptr) {
	spec = (struct specification *) dll_inspect(ptr);
	if (spec->type == PRC) {
	    DLL_FORALL(spec->spec, ptr1) {
		the_def = (struct proc_decl *) dll_inspect(ptr1);
		(void) fprintf(stdout, "[%d.%d]\t", DEF, ++def_cnt);
		(void) fprintf(stdout, "[%d.%d]", PRO, the_def->process->index);

		if (dll_count(the_def->vars)) {
		    (void) fprintf(stdout, "(");
		    DLL_FORALL(the_def->vars, ptr2) {
			var_def = (DLL) dll_inspect(ptr2);
			ptr3 = dll_go_first(var_def);
			ptr3 = dll_go_fw(ptr3);
			the_var = (OBJ_PTR) dll_inspect(ptr3);
			(void) fprintf(stdout, "[%d.%d] ", the_var->class, the_var->index);
		    }
		    (void) fprintf(stdout, ")");
		}
		(void) fprintf(stdout, " = ");
		print_proc_expr(the_def->expr);
		(void) fprintf(stdout, "{ <o>1 }\n");
	    }
	}
    }
}


void print_tables()
{

    print_modules();
    print_sorts();
    print_functions();
    print_actions();
    print_processes();
    print_sets();
    print_communications();
    print_variables();
    print_equations();
    print_definitions();
}
