#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"

#include "dll.h"
#include "error.h"
#include "symtab.h"
#include "ystructs.h"
#include "typecheck.h"

/* memory locations */

DLL object_table;
DLL parse_table;
DLL set_table;
DLL variable_table;
int set_index = 0;


DLL init_tables()
{

    object_table = dll_create();
    set_table = dll_create();
    variable_table = dll_create();
    return (parse_table = dll_create());

}


int my_parse()
{
    int error_code;

    error_code = yyparse();
    /*
     * print_objects();
     */
    if (error_code) {
	(void) fprintf(stderr, "*** syntax check failed. no typechecking performed.\n");
    } else {
	type_check();
    }
    return (error_code);
}


#define DEBUG_NAME 0

char *add_name(name)
    char *name;
{
    DLL_ITEM ptr;
    OBJ_PTR the_object;

#if DEBUG_NAME
    printf("searching for %s\n", name);
#endif

    DLL_FORALL(object_table, ptr) {
	the_object = (OBJ_PTR) dll_inspect(ptr);
	if (strcmp(name, the_object->name) == 0) {
	    return (the_object->name);
	}
    }

#if DEBUG_NAME
    printf("adding %s\n", name);
#endif

    return (psf_strdup(name));
}


OBJ_PTR add_object(name, line_nr)
    char *name;
    int line_nr;
{
    OBJ_PTR tmp;

    tmp = PSF_MALLOC(OBJECT);
    tmp->name = add_name(name);
    tmp->line_nr = line_nr;
    tmp->class = -1;
    tmp->index = -1;

    dll_append(object_table, (DLL_INFO) tmp);

    return (tmp);
}


DLL add_set(list)
    DLL list;
{
    dll_insert(list, (DLL_INFO)++ set_index);
    dll_append(set_table, (DLL_INFO) list);
    return (list);
}


void add_var(list)
    DLL list;
{
    /*
     * DLL_ITEM ptr1, ptr2; OBJ_PTR var1, var2;
     * 
     * 
     * if names of variables may be overloaded in different var/rew sections the
     * following piece of code MUST be omitted. It checks for uniqueness of
     * variable names in the complete specification
     * 
     * for ( ptr1 = dll_go_first(list), ptr1 = dll_go_fw(ptr1); ptr1 != NULL; ptr1
     * = dll_go_fw(ptr1)) { var1 = (OBJ_PTR)dll_inspect(ptr1);
     * 
     * for ( ptr2 = dll_go_fw(ptr1); ptr2 != NULL; ptr2 = dll_go_fw(ptr2) ) { var2
     * = (OBJ_PTR)dll_inspect(ptr2); if (strcmp(var1->name,var2->name) == 0) {
     * error_line(var2->line_nr); (void)fprintf(stderr,"variable '%s'
     * redeclared\n",var2->name); } } }
     */

    dll_append(variable_table, (DLL_INFO) list);
}


void print_objects()
{
    DLL_ITEM ptr;
    OBJ_PTR the_object;

    printf("*** The object table ***\n\n");
    DLL_FORALL(object_table, ptr) {
	the_object = (OBJ_PTR) dll_inspect(ptr);
	printf("%3d - <%s>\n", the_object->line_nr, the_object->name);
    }
}
