%{
/*============================================================================*
 *									      *
 *	file: mcrl.y							      *
 *	info: the YACC grammar for the mCRL parser     		       	      *
 *									      *
 *============================================================================*/


#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_exits.h"
#include "dll.h"
#include "symtab.h"
#include "ystructs.h"
#include "tabout.h"
#include "errordet.h"

static  DLL tmp_var;		/* place to store a temporary list */

%}

%start	Specification

%union	{ 
		char*			LITERAL;
		int			INTEGRAL;
		OBJ_PTR			OBJECT;
		DLL			NAME_LIST;
		DLL			TYPED_NAME_LIST;
		DLL			TYPED_NAME_LIST_LIST;
		DLL_ITEM		LIST_PTR;
		struct data_term*	DATA_TERM;
		DLL			DATA_TERM_LIST;
		DLL			SORT_LIST;
		struct func_decl*	FUNC_DECL;
		DLL			FUNC_DECL_LIST;
		struct comm_decl*	COMM_DECL;
		DLL			COMM_DECL_LIST;
		struct act_decl*	ACT_DECL;
		DLL			ACT_DECL_LIST;
		struct proc_decl*	PROC_DECL;
		DLL			PROC_DECL_LIST;
		struct renaming*	RENAMING;
		DLL			RENAMING_LIST;
		DLL			REWRITE;
		DLL			REW_SPEC;
		struct proc_expr*	PROC_EXPR;
		struct specification*	SPECIFICATION;
		DLL			SPEC_LIST;
	}	

%token sort func delta tau encap hide Xrename sum proc act comm var rew
%token parallel_composition communication_merge left_merge left_condition
%token right_condition alternative_composition sequential_composition
%token comma colon equals hash arrow Name

%type	<OBJECT>		Name

%right alternative_composition
%right parallel_composition communication_merge left_merge
%right left_condition right_condition
%right sequential_composition

/* %left  Specification	-- meaningless and causes Solaris' yacc to dump core */

%type  <NAME_LIST>		Name_list
%type  <NAME_LIST>		X_name_list
%type  <NAME_LIST>		Space_name_list
%type  <SORT_LIST>		Sort_specification
%type  <TYPED_NAME_LIST>	Variable_declaration
%type  <TYPED_NAME_LIST>	Single_variable_declaration
%type  <TYPED_NAME_LIST_LIST>	Variable_declaration_list
%type  <TYPED_NAME_LIST_LIST>	Single_variable_declaration_list
%type  <TYPED_NAME_LIST_LIST>	Variable_declaration_section
%type  <DATA_TERM>		Data_term
%type  <DATA_TERM_LIST>		Data_term_list
%type  <FUNC_DECL>		Function_declaration
%type  <FUNC_DECL_LIST>		Function_declaration_list
%type  <FUNC_DECL_LIST>		Function_specification
%type  <COMM_DECL>		Communication_declaration
%type  <COMM_DECL_LIST>		Communication_declaration_list
%type  <COMM_DECL_LIST>		Communication_specification

%type  <ACT_DECL>		Action_declaration
%type  <ACT_DECL_LIST>		Action_declaration_list
%type  <ACT_DECL_LIST>		Action_specification
%type  <PROC_DECL>		Process_declaration
%type  <PROC_DECL_LIST>		Process_declaration_list
%type  <PROC_DECL_LIST>		Process_specification
%type  <RENAMING>		Renaming_declaration
%type  <RENAMING_LIST>		Renaming_declaration_list
%type  <REWRITE>		Rewrite_rule	
%type  <REW_SPEC>		Rewrite_specification	
%type  <REW_SPEC>		Rewrite_rules_section	
%type  <REW_SPEC>		Rewrite_rule_list	
%type  <PROC_EXPR>		Process_expression	
%type  <SPECIFICATION>		Specification_entry	
%type  <SPEC_LIST>		Specification
%%

Name_list
	: Name
		{ $$ = dll_create(); dll_append($$,(DLL_INFO) $1); }
	| Name_list comma Name
		{ dll_append($1,(DLL_INFO) $3); }
	;

X_name_list
	: Name
		{ $$ = dll_create(); dll_append($$,(DLL_INFO) $1); }
	| X_name_list hash Name
		{ dll_append($1,(DLL_INFO) $3); }
	;

Space_name_list
	: Name
		{ $$ = dll_create(); dll_append($$,(DLL_INFO) $1); }
	| Space_name_list Name
		{ dll_append($1,(DLL_INFO) $2); }
	;

Sort_specification
	: sort Space_name_list
		{ $$ = $2; }
	;

Function_specification
	: func Function_declaration_list
		{ $$ = $2; }
	;

Function_declaration_list
	: Function_declaration
		{ $$ = dll_create(); dll_append($$,(DLL_INFO) $1); }
	| Function_declaration_list Function_declaration
		{ dll_append($1,(DLL_INFO) $2); }
	;

Function_declaration
	: Name_list colon X_name_list arrow Name
		{
		  $$ = PSF_MALLOC(struct func_decl);
		  $$->functions = $1;
		  $$->input_type = $3;
		  $$->output_type = $5;
		}
	| Name_list colon arrow Name
		{
		  $$ = PSF_MALLOC(struct func_decl);
		  $$->functions = $1;
		  $$->input_type = dll_create();
		  $$->output_type = $4;
		}
	;

Rewrite_specification
	: Variable_declaration_section Rewrite_rules_section
		{ $$ = dll_create(); dll_append($$,(DLL_INFO) $1); 
		dll_append($$,(DLL_INFO)$2);}
	;

Variable_declaration_list
	: Variable_declaration
		{ $$ = dll_create(); dll_append($$,(DLL_INFO)$1); }
	| Variable_declaration_list Variable_declaration
		{ dll_append($1,(DLL_INFO)$2); }
	;

Variable_declaration_section
	: var Variable_declaration_list
		{ $$ = $2; }
	| /* empty */
		{ $$ = dll_create(); }
	;

Variable_declaration
	: Name_list colon Name
		{ dll_insert($1,$3); add_var($1); }
	;

Data_term_list
	: Data_term
		{ $$ = dll_create(); dll_append($$,(DLL_INFO)$1); }
	| Data_term_list comma Data_term
		{ dll_append($1,(DLL_INFO)$3); }
	;

Data_term
	: Name
		{
		  $$ = PSF_MALLOC(struct data_term);
		  $$->head = $1;
		  $$->arg = dll_create();
		}
	| Name '(' Data_term_list ')'
		{
		  $$ = PSF_MALLOC(struct data_term);
		  $$->head = $1;
		  $$->arg = $3;
		}
	;

Rewrite_rule_list
	: Rewrite_rule
		{ $$ = dll_create(); dll_append($$,(DLL_INFO)$1); }
	| Rewrite_rule_list Rewrite_rule
		{ dll_append($1,(DLL_INFO)$2); }
	;

Rewrite_rules_section
	: rew Rewrite_rule_list
		{ $$ = $2; }
	;

Rewrite_rule
	: Data_term equals Data_term
		{ $$ = dll_create(); dll_append($$,(DLL_INFO)$1); dll_append($$,(DLL_INFO)$3); }

	;

Process_expression
	: Process_expression alternative_composition Process_expression
		{
		  $$ = PSF_MALLOC(struct proc_expr);
		  $$->class = ALT;
		  $$->pe1 = $1;
		  $$->pe2 = $3;
		}
	| Process_expression parallel_composition Process_expression
		{
		  $$ = PSF_MALLOC(struct proc_expr);
		  $$->class = PAR;
		  $$->pe1 = $1;
		  $$->pe2 = $3;
		}
	| Process_expression left_merge Process_expression
		{
		  $$ = PSF_MALLOC(struct proc_expr);
		  $$->class = LMG;
		  $$->pe1 = $1;
		  $$->pe2 = $3;
		}
	| Process_expression communication_merge Process_expression
		{
		  $$ = PSF_MALLOC(struct proc_expr);
		  $$->class = CMG;
		  $$->pe1 = $1;
		  $$->pe2 = $3;
		}
	| Process_expression left_condition Data_term right_condition Process_expression
		{
		  $$ = PSF_MALLOC(struct proc_expr);
		  $$->class = HIF;
		  $$->pe1 = $1;
		  $$->pe2 = $5;
		  $$->list = dll_create();
		  dll_insert($$->list,$3);
		}
	| Process_expression sequential_composition Process_expression
		{
		  $$ = PSF_MALLOC(struct proc_expr);
		  $$->class = SEQ;
		  $$->pe1 = $1;
		  $$->pe2 = $3;
		}
	| delta
		{
		  $$ = PSF_MALLOC(struct proc_expr);
		  $$->class = DLK;
		}
	| tau
		{
		  $$ = PSF_MALLOC(struct proc_expr);
		  $$->class = TAU;
		}
	| encap '(' '{' Name_list '}' comma Process_expression ')'
		{
		  $$ = PSF_MALLOC(struct proc_expr);
		  $$->class = ENC;
		  $$->pe1 = $7;
		  $$->list = add_set($4);
		}
	| hide '(' '{' Name_list '}' comma Process_expression ')'
		{
		  $$ = PSF_MALLOC(struct proc_expr);
		  $$->class = HID;
		  $$->pe1 = $7;
		  $$->list = add_set($4);
		}
	| Xrename '(' '{' Renaming_declaration_list '}' comma Process_expression ')'
		{
		  $$ = PSF_MALLOC(struct proc_expr);
		  $$->class = REN;
		  $$->pe1 = $7;
		  $$->list = add_set($4);
		}
	| sum '(' Single_variable_declaration comma Process_expression ')'
		{
		  $$ = PSF_MALLOC(struct proc_expr);
		  $$->class = SUM;
		  $$->pe1 = $5;
		  tmp_var = dll_create();
		  dll_insert(tmp_var,$3);
		  $$->list = tmp_var;
		}
	| Name '(' Data_term_list ')'
		{
		  $$ = PSF_MALLOC(struct proc_expr);
		  $$->class = PRY;
		  $$->list = dll_create();
		  dll_append($$->list,(DLL_INFO)$1);
		  dll_append($$->list,(DLL_INFO)$3);
		}
	| Name
		{
		  $$ = PSF_MALLOC(struct proc_expr);
		  $$->class = PRN;
		  $$->list = dll_create();
		  dll_append($$->list,(DLL_INFO)$1);
		  dll_append($$->list,dll_create());
		}
	| '(' Process_expression ')'
		{
		  $$ = $2;
		}
	; 

Renaming_declaration_list
	: Renaming_declaration
		{ $$ = dll_create(); dll_append($$,(DLL_INFO)$1); }
	| Renaming_declaration_list comma Renaming_declaration
		{ dll_append($1,(DLL_INFO)$3); }
	;

Renaming_declaration
	: Name arrow Name
		{
		  $$ = PSF_MALLOC(struct renaming);
		  $$->from = $1;
		  $$->to = $3;
		}
	;

Single_variable_declaration_list
	: Single_variable_declaration
		{ $$ = dll_create(); dll_append($$,(DLL_INFO)$1); }
	| Single_variable_declaration_list comma Single_variable_declaration
		{ dll_append($1,(DLL_INFO)$3); }
	;

Single_variable_declaration
	: Name colon Name
		{ 
		  $$ = dll_create();
		  dll_append($$,(DLL_INFO)$3);
		  dll_append($$,(DLL_INFO)$1);
		  add_var($$); }
	;

Process_specification
	: proc Process_declaration_list
		{ $$ = $2; }
	;

Process_declaration_list
	: Process_declaration
		{ $$ = dll_create(); dll_append($$,(DLL_INFO)$1); }
	| Process_declaration_list Process_declaration
		{ dll_append($1,(DLL_INFO)$2); }
	;

Process_declaration
	: Name '(' Single_variable_declaration_list ')' equals Process_expression
		{
		  $$ = PSF_MALLOC(struct proc_decl);
		  $$->process = $1;
		  $$->vars = $3;
		  $$->expr = $6;
		}
	| Name equals Process_expression
		{
		  $$ = PSF_MALLOC(struct proc_decl);
		  $$->process = $1;
		  $$->vars = dll_create();
		  $$->expr = $3;
		}
	;

Action_specification
	: act Action_declaration_list
		{ $$ = $2; }
	;

Action_declaration_list
	: Action_declaration
		{ $$ = dll_create(); dll_append($$,(DLL_INFO)$1); }
	| Action_declaration_list Action_declaration
		{ dll_append($1,(DLL_INFO)$2); }
	;

Action_declaration
	: Name_list colon X_name_list
		{
		  $$ = PSF_MALLOC(struct act_decl);
		  $$->actions = $1;
		  $$->type = $3;
		}
	| Name
		{
		  $$ = PSF_MALLOC(struct act_decl);
		  $$->actions = dll_create();
		  dll_append($$->actions,(DLL_INFO)$1);
		  $$->type = dll_create();
		}
	;

Communication_specification
	: comm Communication_declaration_list
		{ $$ = $2; }
	;

Communication_declaration_list
	: Communication_declaration
		{ $$ = dll_create(); dll_append($$,(DLL_INFO)$1); }
	| Communication_declaration_list Communication_declaration
		{ dll_append($1,(DLL_INFO)$2); }
	;

Communication_declaration
	: Name communication_merge Name equals Name
		{
		  $$ = PSF_MALLOC(struct comm_decl);
		  $$->left = $1;
		  $$->right = $3;
		  $$->result = $5;
		}
	;

Specification_entry
	: Sort_specification
		{
		  $$ = PSF_MALLOC(struct specification);
		  $$->type = SRT;
		  $$->spec = $1;
		}
	| Function_specification
		{
		  $$ = PSF_MALLOC(struct specification);
		  $$->type = FNC;
		  $$->spec = $1;
		}
	| Rewrite_specification
		{
		  $$ = PSF_MALLOC(struct specification);
		  $$->type = REW;
		  $$->spec = $1;
		}
	| Action_specification
		{
		  $$ = PSF_MALLOC(struct specification);
		  $$->type = ACT;
		  $$->spec = $1;
		}
	| Communication_specification
		{
		  $$ = PSF_MALLOC(struct specification);
		  $$->type = CMM;
		  $$->spec = $1;
		}
	| Process_specification
		{
		  $$ = PSF_MALLOC(struct specification);
		  $$->type = PRC;
		  $$->spec = $1;
		}
	;

Specification
	: 
	  {
	    $<SPEC_LIST>$ = init_tables();
	  }
	  Specification_entry
	  { dll_append($$,(DLL_INFO)$2); }
	| Specification Specification_entry
	  { dll_append($1,(DLL_INFO)$2); }
	;

%%

void on_syntax_err() 
{
    exit(EXIT_SYNTAX_ERR);
}
