%{
/*============================================================================*
 *									      *
 *	file: mcrl.l							      *
 *      info: lexical definitions for lex to generate a lexical analyser      *
 * 	      for algebraic specifications written in mCRL 		      *
 *									      *
 *============================================================================*/

/* #include <stdio.h>	-- already included by lex; makedepend objects to
			-- including it twice */
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_fopen.h"
#include "dll.h"
#include "symtab.h"
#include "ystructs.h"
#include "y.tab.h"
#include "main.h"

%}


identifier	[A-Za-z0-9]+
layout		[ \t\r\f\n]
comment		[%][^\n]*[\n]

%%
"||"			return(parallel_composition);
"|"			return(communication_merge);
"||_"			return(left_merge);
"<|"			return(left_condition);
"|>"			return(right_condition);
"+"			return(alternative_composition);
"."			return(sequential_composition);
","			return(comma);
":"			return(colon);
"="			return(equals);
"#"			return(hash);
"->"			return(arrow);

"sort"			return(sort);
"func"			return(func);
"delta"			return(delta);
"tau"			return(tau);
"encap"			return(encap);
"hide"			return(hide);
"rename"		return(Xrename);
"sum"			return(sum);
"var"			return(var);
"rew"			return(rew);
"proc"			return(proc);
"act"			return(act);
"comm"			return(comm);

{identifier}		{
			  yylval.OBJECT=add_object(yytext,yylineno);
			  return(Name);
			}
{layout}		;
{comment}		;
.			{ return(yytext[0]); }
%%

int yywrap()
{
 psf_file pf;
 static suffix suffixes[] = {{NULL, ".mcrl"}, {NULL, NULL}};
 
 if (++current_file>= max_file ) return 1;
 pf = psf_fopen(files[current_file], suffixes);
 yyin = pf.fp;
 filename = pf.name;
 yylineno = 1;
 return 0;

}
