#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf_fopen.h"
#include "psf_standards.h"
#include "main.h"
#include "version.h"
#include "dll.h"
#include "symtab.h"

extern FILE *yyin;		/* input-file of lex */
extern int yylineno;		/* linenumber from lex */
char *filename;			/* name of the current file */
int errorseen = FALSE;		/* flags grammatical errors */
int max_file=0;
int current_file=1;
char *progname;
char **files;

void usage()
{
    (void) fprintf(stderr, "usage: %s [-vh] [mcrl-files]\n", progname);
}

void version()
{
    (void) fprintf(stderr, "mcrl_til version %s, last compiled %s\n",
		   VERSION, __DATE__);

}

int main(argc, argv)
    int argc;
    char *argv[];
{
    int c;
    psf_file pf;
    static suffix suffixes[] = {{NULL, ".mcrl"}, {NULL, NULL}};
    extern int optind;

    if (argc == 0) {
	(void) fprintf(stderr, "Who am I?\n");
	exit(1);
    } else
	progname = psf_basename(argv[0]);

    while ((c = getopt(argc, argv, "hv")) != EOF)
	switch (c) {
	case 'v':
	    version();
	    break;
	case 'h':
	    usage();
	    exit(EXIT_SUCCESS);
	    break;
	default:
	    usage();
	    exit(EXIT_CMD_LINE_ERR);
	};
    if (optind > argc)
	exit(EXIT_CMD_LINE_ERR);
    if (optind == argc) {
	yyin = stdin;
	filename = "stdin";
	if (my_parse())
	    exit(EXIT_SYNTAX_ERR);
    } else
	{
	current_file = optind;
	max_file = argc;
	files = argv;
	pf = psf_fopen(argv[current_file], suffixes);
	yyin = pf.fp;
	filename = pf.name;
	if (my_parse())
	    exit(EXIT_SYNTAX_ERR);
	fclose(yyin);
	}

    return (errorseen ? EXIT_SYNTAX_ERR : EXIT_SUCCESS);
}
