
struct state_tree {
    struct state *state;	/* corresponding state */
    union {
	struct state_tree *single;	/* direct reference */
	struct state_tree **multiple;	/* array of references */
    } next[NR_EXPS];
};

/* statetrees.c */
extern struct state_tree *states_root;
extern void init_state_tree PROTO_ARGS((void));
extern struct state_tree **new_list PROTO_ARGS((int type));
extern struct state_tree **new_array PROTO_ARGS((int size));
extern struct state_tree *new_state_tree PROTO_ARGS((void));
extern void print_state_list PROTO_ARGS((void));
extern void print_state_node PROTO_ARGS((struct state_tree *curr, DLL list));
extern struct state_tree *next_state PROTO_ARGS((struct state_tree *curr, struct expression *expr));
extern struct state_tree *find_state PROTO_ARGS((struct expression *expr, struct state_tree *curr));
extern struct state *expr_to_state PROTO_ARGS((struct expression *exp));
