/*
 * utilities to manipulate states
 */

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "psf_prototype.h"
#include "main.h"
#include "std.h"
#include "memory.h"
#include "constants.h"
#include "options.h"
#include "objects.h"
#include "expressions.h"
#include "definitions.h"
#include "states.h"
#include "statetrees.h"


struct state_tree *states_root;



void init_state_tree()
{
    states_root = new_state_tree();
}


struct state_tree **new_list(type)
    int type;
{
    struct state_tree **tmp;

    switch (type) {
    case ATM_EXP:
	tmp = new_array(NR_ATOMS);
	break;
    case PRC_EXP:
	tmp = new_array(NR_PROCESSES);
	break;
    case ENC_EXP:
    case HID_EXP:
	tmp = new_array(NR_SETS);
	break;
    default:
	assert(0);
    }
    return (tmp);
}


struct state_tree **new_array(size)
    int size;
{
    struct state_tree **tmp;
    int i;

    tmp = alloc_array(struct state_tree *, size + 1);
    for (i = 0; i <= size; i++) {
	tmp[i] = NULL;
    }
    return (tmp);
}


#if 0
struct state_tree **new_processes()
{
    struct state_tree **tmp;
    int i;

    tmp = alloc_array(struct state_tree *, NR_PROCESSES + 1);

    for_all_processes(i) {
	tmp[i] = NULL;
    }
    return (tmp);
}


struct state_tree **new_sets()
{
    struct state_tree **tmp;
    int i;

    tmp = alloc_array(struct state_tree *, NR_SETS + 1);
    for (i = 1; i <= NR_SETS; i++) {
	tmp[i] = NULL;
    }
    return (tmp);
}

#endif


struct state_tree *new_state_tree()
{
    int i;
    struct state_tree *tmp;

    tmp = alloc_ptr(struct state_tree);
    for (i = 0; i < NR_EXPS; i++) {
	tmp->next[i].single = NULL;
    }
    tmp->state = NULL;
    return (tmp);
}


void print_state_list()
{
    static DLL the_list = NULL;
    struct state_tree *the_block;

    if (!the_list) {
	the_list = dll_create();
    }
    dll_append(the_list, (DLL_INFO) states_root);

    do {
	the_block = (struct state_tree *) dll_delete_first(the_list);
	print_state_node(the_block, the_list);
	printf("***           ----          ***\n");
    } while (!dll_empty(the_list));
}


void print_state_node(curr, list)
    struct state_tree *curr;
    DLL list;
{
    int i, j;

    if (!curr) {
	printf("No block at all!\n");
	return;
    }
    printf("state_block @%lu\n", (unsigned long) curr);
    for (i = 0; i < NR_EXPS; i++) {
	switch (i) {
	case ATM_EXP:
	    printf("%s :\n", operator_name[i]);
	    if (!curr->next[i].multiple) {
		printf("NULL\n");
	    } else {
		for (j = 1; j <= NR_ATOMS; j++) {
		    print_identifier(i, j);
		    if (!curr->next[i].multiple[j]) {
			printf(" : NULL\n");
		    } else {
			printf(" : %lu\n", (unsigned long) curr->next[i].multiple[j]);
			dll_append(list, (DLL_INFO) curr->next[i].multiple[j]);
		    }
		}
	    }
	    break;
	case PRC_EXP:
	    printf("%s :\n", operator_name[i]);
	    if (!curr->next[i].multiple) {
		printf("NULL\n");
	    } else {
		for_all_processes(j) {
		    print_identifier(i, j);
		    if (!curr->next[i].multiple[j]) {
			printf(" : NULL\n");
		    } else {
			printf(" : %lu\n", (unsigned long) curr->next[i].multiple[j]);
			dll_append(list, (DLL_INFO) curr->next[i].multiple[j]);
		    }
		}
	    }
	    break;
	case TCK_EXP:
	case EPS_EXP:
	case DLK_EXP:
	case SKP_EXP:
	case ALT_EXP:
	case SEQ_EXP:
	case PAR_EXP:
	case LMG_EXP:
	case COM_EXP:
	case HID_EXP:
	case ENC_EXP:
	    printf("%s :\n", operator_name[i]);
	    if (!curr->next[i].single) {
		printf("NULL\n");
	    } else {
		printf("%lu\n", (unsigned long) curr->next[i].single);
		dll_append(list, (DLL_INFO) curr->next[i].single);
	    }
	    break;
	default:
	    fprintf(stderr, "print_state_node: unknown switch %d\n", i);
	    break;
	}
    }
}


struct state_tree *next_state(curr, expr)
    struct state_tree *curr;
    struct expression *expr;
{

#if 0
    printf("*** next_state: ");
    print_expression(expr);
    printf("\n");
    print_state_list(curr);
#endif

    switch (expr->type) {
    case ATM_EXP:
    case PRC_EXP:
    case ENC_EXP:
    case HID_EXP:

	if (!curr->next[expr->type].multiple) {
	    curr->next[expr->type].multiple = new_list(expr->type);
	}
	if (!curr->next[expr->type].multiple[expr->index]) {
	    curr->next[expr->type].multiple[expr->index] = new_state_tree();
	}
	return (curr->next[expr->type].multiple[expr->index]);
	break;
    case TCK_EXP:
    case SKP_EXP:
    case DLK_EXP:
    case SEQ_EXP:
    case ALT_EXP:
    case PAR_EXP:
    case LMG_EXP:
    case COM_EXP:
	if (!curr->next[expr->type].single) {
	    curr->next[expr->type].single = new_state_tree();
	}
	return (curr->next[expr->type].single);
	break;
    default:
	fprintf(stderr, "next_state: unknown expression type in switch\n");
	ProgrammerError;
	break;
    }
    ProgrammerError;
    return (NULL);
}


struct state_tree *find_state(expr, curr)
    struct expression *expr;
    struct state_tree *curr;
{


#if 0
    printf("*** find_state : ");
    print_expression(expr);
    printf("\n");
    print_state_list(curr);
#endif


    switch (expr->type) {
    case ATM_EXP:
    case SKP_EXP:
    case DLK_EXP:
    case PRC_EXP:
    case TCK_EXP:
	return (next_state(curr, expr));
	break;
    case SEQ_EXP:
    case ALT_EXP:
    case PAR_EXP:
    case LMG_EXP:
    case COM_EXP:
	return (find_state(expr->right,
			   next_state(find_state(expr->left, curr), expr)));
	break;

    case ENC_EXP:
    case HID_EXP:
	return (find_state(expr->right, next_state(curr, expr)));
	break;

    default:
	fprintf(stderr, "find_state: unknown expression type\n");
	printf("operator: %s\n", operator_name[expr->type]);
	ProgrammerError;
	break;
    }
    ProgrammerError;
    return (NULL);
}


struct state *expr_to_state(exp)
    struct expression *exp;
{
    struct state_tree *tmp;

#if 0
    printf("expr_to_state: searching for ");
    print_expression(exp);
    printf("\n");
#endif

    tmp = find_state(exp, states_root);
    if (!tmp->state) {
	tmp->state = new_state();
	tmp->state->exp = exp;
    }

#if 0
    printf("found: ");
    print_state(tmp->state);
#endif

    return (tmp->state);
}
