#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf_malloc.h"
#include "constants.h"
#include "options.h"

extern char *optarg;

/* options */

int Option_Verbose = FALSE;
int Option_Debug = FALSE;
int Option_Transitions = FALSE;
int Option_List = FALSE;
int Option_Modifications = FALSE;
int Option_Guardedness = FALSE;
int Option_Blocks = FALSE;
int Option_Simulator = FALSE;
int Option_Rewrite = FALSE;
int Option_Execution = FALSE;
int Option_Communication = FALSE;
int Option_Top = FALSE;
int Option_Shorthand = FALSE;

char *Option_Initial_Seed = NULL;
char *Option_Top_Str = NULL;

void process_options(argc, argv)
    int argc;
    char *argv[];
{
    int opt;

    while ((opt = getopt(argc, argv, OPTIONS)) != -1) {
	switch (opt) {
	case 'b':
	    Option_Blocks = TRUE;
	    break;
	case 'c':
	    Option_Communication = TRUE;
	    break;
	case 'd':
	    Option_Debug = TRUE;
	    break;
	case 'g':
	    Option_Guardedness = TRUE;
	    break;
	case 'i':
	    Option_Initial_Seed = psf_strdup(optarg);
	    break;
	case 'l':
	    Option_List = TRUE;
	    break;
	case 'm':
	    Option_Modifications = TRUE;
	    break;
	case 'r':
	    Option_Rewrite = TRUE;
	    break;
	case 's':
	    Option_Shorthand = TRUE;
	    break;
	case 't':
	    Option_Top = TRUE;
	    Option_Top_Str = psf_strdup(optarg);
	    break;
	case 'v':
	    Option_Verbose = TRUE;
	    break;
	case 'x':
	    Option_Execution = TRUE;
	    break;
	case 'h':
	    fprintf(stderr, USAGE_STR, argv[0], OPTIONS_STR);
	    exit(EXIT_SUCCESS);
	case '?':
	    fprintf(stderr, USAGE_STR, argv[0], OPTIONS_STR);
	    exit(EXIT_CMD_LINE_ERR);
	}
    }
}
