/*
 * the objects to be manipulated
 */

#include "dll.h"

/* objects.c */
extern struct definition **process;
extern struct atom **atom;
extern struct set **set;
extern char *operator_name[];

extern void init_operator_names PROTO_ARGS((void));

#define INFINITE	0
#define FINITE		1
#define	UNKNOWN		2

#define UNEXPANDED 	0
#define EXPANDED 	1
#define EXPANDING 	2


struct definition {		/* object defining proces definition */
    unsigned trace:2;		/* does this definition contain finite trace */
    unsigned expansion:2;	/* expansion status */
    unsigned visited:1;		/* marker for several tests */
    unsigned recursive:1;	/* marker for recursivity tests */
    unsigned dependent:1;	/* marker for dependency tests */
    unsigned derived:1;		/* is this a derived process */
    unsigned guarded:1;		/* is this a guarded process */
    char *name;			/* process name */
    struct definition *base;	/* base process even if base self */
    int derivative_cnt;		/* number of deravitive(s) */
    struct state *initial;	/* initial state */
    struct expression *myself;	/* this process as expression */
    struct expression *exp;	/* the expression defined */
    int *unguarded_in;		/* array with guardedness info wrt processes */
};


struct atom {
    char *name;			/* name of atom */
    int *partner;		/* array of communication partners */
};


struct set {
    char *name;			/* name of the set */
    DLL contents;		/* list of elements */
};
