/*
 * memory.h : checked memory allocation
 */
#include "psf_malloc.h"

#ifndef Memory_Available
#define Memory_Available

#ifdef NO_MEMORY_CHECK
#define MEMORY_CHECK 0
#else
#define MEMORY_CHECK 1
#endif

#ifdef THINK_C
#include <stdlib.h>
#else
#include <malloc.h>
#endif

#define   alloc_ptr(x)   	PSF_MALLOC(x)
#define   alloc_array(x,n) 	PSF_NMALLOC(x,n)

#if MEMORY_CHECK

/* memory.c */
extern void *alloc_check PROTO_ARGS((int bytes));

#else
#define alloc_check(n) alloc(n)
#endif

#endif
