/*
 * generate FC from a LTS-file
 */

#include <stdio.h>
#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf_fopen.h"
#include "env_variables.h"
#include "main.h"
#include "options.h"
#include "memory.h"
#include "tiltype.h"
#include "readtil.h"
#include "version.h"
#include "check.h"
#include "expressions.h"
#include "definitions.h"
#include "ltsfc.h"

extern int optind;

/* globals */

struct module *the_mod;
int Error_Status;
char *progname;
char *filename;

static suffix suffixes[] = {{LTSSUFFIX, LTSSUFFIX_DEFAULT}, {NULL, NULL}};
psf_file pf;                /* psf file from psf_fopen */

#define CONTINOUS_OUTPUT 1	/* set to 1 to disallow buffering */

int main(argc, argv)
    int argc;
    char *argv[];
{
    FILE *lts_in = NULL, *fc_out = NULL;
    char *out_file = NULL;

#if CONTINOUS_OUTPUT
    setbuf(stdout, NULL);
#endif

    process_options(argc, argv);

    progname = argv[0];		/* update parameter list */
    filename = NULL;
    argc -= optind - 1;
    argv += optind - 1;

    /* check parameters */
    switch (argc) {

    case 1:			/* we have to read from standard input */
	lts_in = stdin;
	fc_out = stdout;
	break;

    case 2:			/* we have an input file */
	filename = argv[1];
	fc_out = stdout;
	break;

    case 3:			/* we have an input and a output file */
	filename = argv[1];
	out_file = argv[2];
	break;

    default:
	fprintf(stderr, USAGE_STR, progname, OPTIONS_STR);
	exit(EXIT_CMD_LINE_ERR);
	break;
    }

    /* open input file */
    if (filename) {
	pf = psf_fopen(filename, suffixes );
	lts_in = pf.fp;
	filename = pf.name;
    }
    if (Option_Verbose) version();
    
    the_mod = alloc_ptr(struct module);

    if (read_module(the_mod, lts_in) == 1) {	/* read in lts file */
	fprintf(stderr, "error(s) in LTS format.\n");
	exit(EXIT_SYNTAX_ERR);
    }
    if (filename) {
	fclose(lts_in);		/* close lts file */
    }
    if (check_args(the_mod) != 0) {
	fprintf(stderr,
	      "*** Error: restricted to argument free atoms and processes\n");
	exit(EXIT_SYNTAX_ERR);
    }
    init_definitions(the_mod);

    read_definitions(the_mod);
    if (Error_Status) {
	exit(Error_Status);
    }
    if (Option_Verbose) {
	if (out_file) {
	    printf("... generating '%s'\n", out_file);
	}
    }
    /* open output file */
    if (out_file) {
	if ((fc_out = fopen(out_file, "w")) == NULL) {
	    fprintf(stderr, "%s: can't open file \"%s\" for output\n", progname, out_file);
	    exit(EXIT_IO_ERR);
	}
    }
    write_fc_file(the_mod, Option_Top_Str, fc_out);

    if (out_file) {
	if (fclose(fc_out) != 0) {	/* close fc output file */
	    fprintf(stderr, "%s: failed to close \"%s\"\n", progname, out_file);
	}
    }
    exit(Error_Status);
}
