.TH "LTS_FC" 1L "July 13, 1993" "PSF-Toolkit"
.UC 4
.SH NAME
lts_fc \- translate LTS code to a FC specification
.SH SYNOPSIS
.B lts_fc
[
.B \-hvs
] [
.B \-t top
] [
.I lts-file
[
.I fc-file
] ]
.SH DESCRIPTION
The program
.B lts_fc
tries to make a FC specification from LTS-code.
.B lts_fc
reads from the standard input or from
.I lts-file
if
.I lts-file
is given, and writes to the standard output or to
.I fc-file
if
.I fc-file
is given.
.BR
If no suffix is given to 
.I lts-file 
the suffix as defined by the environment
variable
.B LTSSUFFIX
is used. The default
.IR .lts
is used if
.B LTSSUFFIX 
is not set.
.SH OPTIONS
.TP 4n
.B \-h
displays a message about how to use the program.
.TP
.B \-v
puts the program in verbose mode.  In this mode the program shows the
version number and the name of the output file it is opening.
.TP
.B \-s
puts the generation of fc code in "shorthand" mode.  Normally non-abbrviated
fc statements are written.  When specifying this switch the abbreviated syntax
is used.
.TP
.B \-t
.I top
enables the user to specify the name of the state that will be indicated in
the fc code as being the main/initial state.
.SH EXIT STATUS
.TP 4n
0   EXIT_SUCCESS	no errors
.TP
1   EXIT_CMD_LINE_ERR	calling program with illegal arguments
.TP
2   EXIT_IO_ERR		file could not be opened
.TP
3   EXIT_SYNTAX_ERR     errors in input file
.TP
4   EXIT_MEM_ERR	memory allocation/deallocation error
.TP
5   EXIT_HELP		something really wrong
. SH SEE ALSO
.BR psf (1L)
.BR trans (1L)
.BR fc_lts (1L)
.SH AUTHOR
Peter Peters, Eindhoven University of Technology (pp@win.tue.nl)
.SH BUGS
Sure....
