/*
 * dll_check.h: checking routines
 * 
 * 
 */

#ifndef DLL_Check_Available
#define DLL_Check_Available

#include "dll.h"

#if DLL_CHECK

/* dll_check.c */
extern DLL _issued_items;
extern DLL _issued_lists;
extern int _item_guard;
extern int _list_guard;
extern void check_item PROTO_ARGS((DLL_ITEM item));
extern void check_list PROTO_ARGS((DLL list));
extern void check_non_empty_list PROTO_ARGS((DLL list));
extern void check_order_fns PROTO_ARGS((DLL x, DLL y));
extern void check_non_sorted PROTO_ARGS((DLL list));
extern void check_on_list PROTO_ARGS((DLL list, DLL_ITEM item));
extern void check_list_types PROTO_ARGS((DLL x, DLL y));
extern int cmp_pointers PROTO_ARGS((DLL_INFO *p1, DLL_INFO *p2));

#else

#define check_item(i) ;
#define check_list(l) ;
#define check_non_empty_list(l) ;
#define check_order_fns(l1,l2) ;
#define check_non_sorted(l) ;
#define check_on_list(l,i) ;
#define check_list_types(l1,l2) ;
#define cmp_pointers(p1,p2) ;
#endif

#endif
