/*
 * dll.h : include file for doubly linked list structures
 * 
 * 
 * naming conventions:
 * 
 * dll    : doubly linked list dll_s  : sorted doubly linked list dll_u  : doubly
 * linked list with unique elements dll_su : sorted doubly linked list with
 * unique elements
 * 
 */

#ifndef DLL_Available
#define DLL_Available

#if THINK_C
#define DLL_NO_CHECK
#endif

#ifdef DLL_NO_CHECK		/* check function arguments? */
#define DLL_CHECK 0
#define DLL_CORE 0
#else
#define DLL_CHECK 1
#define DLL_CORE 1
#endif

#define DLL_ERROR 99		/* just a number */

typedef void *DLL_INFO;

typedef struct dll_it {
    struct dll_it *bw;		/* backward link */
    struct dll_it *fw;		/* forward link */
    DLL_INFO info;		/* the element */

#if DLL_CHECK
    int id;			/* identification field */
#endif

} DLL_ITBL, *DLL_ITEM;

typedef struct dll_def {
    DLL_ITEM first;		/* first element in the list */
    DLL_ITEM last;		/* last element in the list */
    unsigned sorted:1;		/* sorted list? */
    unsigned unique:1;		/* list of unique elements? */
    int (*cmp) ();		/* element compare function */
    int size;			/* number of elements in list */

#if DLL_CHECK
    int id;			/* identification field */
#endif

} DLL_BLOCK, *DLL;



/* useful macros */

/* DLL_FORALL: make a for loop traversing all elements from l using p as ptr */
#define DLL_FORALL(l,p) for(p=dll_go_first(l);p!=NULL;p=dll_go_fw(p))

/* dll.c */
extern DLL_ITEM _dll_create_item PROTO_ARGS((DLL_INFO info));
extern DLL_INFO _dll_delete_item PROTO_ARGS((DLL list, DLL_ITEM ptr));
extern void _dll_dispose_item PROTO_ARGS((DLL_ITEM ptr));
extern DLL dll_create PROTO_ARGS((void));
extern DLL dll_s_create PROTO_ARGS((int (*cmp)()));
extern DLL dll_u_create PROTO_ARGS((int (*cmp)()));
extern DLL dll_su_create PROTO_ARGS((int (*cmp)()));
extern DLL dll_create_descendent PROTO_ARGS((DLL prototype));
extern DLL _dll_create_descendent PROTO_ARGS((DLL prototype));
extern void dll_flush PROTO_ARGS((DLL ptr));
extern void _dll_flush PROTO_ARGS((DLL ptr));
extern void dll_dispose PROTO_ARGS((DLL ptr));
extern void _dll_dispose PROTO_ARGS((DLL ptr));
extern int dll_empty PROTO_ARGS((DLL list));
extern int _dll_empty PROTO_ARGS((DLL list));
extern int dll_first PROTO_ARGS((DLL list, DLL_ITEM curr));
extern int _dll_first PROTO_ARGS((DLL list, DLL_ITEM curr));
extern int dll_last PROTO_ARGS((DLL list, DLL_ITEM curr));
extern int _dll_last PROTO_ARGS((DLL list, DLL_ITEM curr));
extern int dll_count PROTO_ARGS((DLL list));
extern int _dll_count PROTO_ARGS((DLL list));
extern DLL dll_copy PROTO_ARGS((DLL list));
extern DLL _dll_copy PROTO_ARGS((DLL list));
extern DLL_ITEM dll_go_first PROTO_ARGS((DLL list));
extern DLL_ITEM _dll_go_first PROTO_ARGS((DLL list));
extern DLL_ITEM dll_go_last PROTO_ARGS((DLL list));
extern DLL_ITEM _dll_go_last PROTO_ARGS((DLL list));
extern DLL_ITEM dll_go_fw PROTO_ARGS((DLL_ITEM curr));
extern DLL_ITEM _dll_go_fw PROTO_ARGS((DLL_ITEM curr));
extern DLL_ITEM dll_go_bw PROTO_ARGS((DLL_ITEM curr));
extern DLL_ITEM _dll_go_bw PROTO_ARGS((DLL_ITEM curr));
extern DLL_ITEM dll_add PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_add PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM dll_insert PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_insert PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM dll_append PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_append PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM dll_add_before PROTO_ARGS((DLL list, DLL_ITEM curr, DLL_INFO info));
extern DLL_ITEM _dll_add_before PROTO_ARGS((DLL list, DLL_ITEM curr, DLL_INFO info));
extern DLL_ITEM dll_add_after PROTO_ARGS((DLL list, DLL_ITEM curr, DLL_INFO info));
extern DLL_ITEM _dll_add_after PROTO_ARGS((DLL list, DLL_ITEM curr, DLL_INFO info));
extern DLL_ITEM _dll_add_first PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_add_last PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_insert_at PROTO_ARGS((DLL list, DLL_ITEM curr, DLL_INFO info));
extern DLL_ITEM _dll_append_at PROTO_ARGS((DLL list, DLL_ITEM curr, DLL_INFO info));
extern DLL_INFO dll_delete PROTO_ARGS((DLL list, DLL_ITEM curr));
extern DLL_INFO _dll_delete PROTO_ARGS((DLL list, DLL_ITEM curr));
extern DLL_INFO dll_delete_first PROTO_ARGS((DLL list));
extern DLL_INFO _dll_delete_first PROTO_ARGS((DLL list));
extern DLL_INFO dll_delete_last PROTO_ARGS((DLL list));
extern DLL_INFO _dll_delete_last PROTO_ARGS((DLL list));
extern DLL_INFO dll_delete_info PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_INFO _dll_delete_info PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_INFO dll_inspect PROTO_ARGS((DLL_ITEM curr));
extern DLL_INFO _dll_inspect PROTO_ARGS((DLL_ITEM curr));
extern DLL_INFO dll_inspect_first PROTO_ARGS((DLL list));
extern DLL_INFO _dll_inspect_first PROTO_ARGS((DLL list));
extern DLL_INFO dll_inspect_last PROTO_ARGS((DLL list));
extern DLL_INFO _dll_inspect_last PROTO_ARGS((DLL list));
extern DLL_ITEM dll_search PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_search PROTO_ARGS((DLL list, DLL_INFO info));
extern int dll_compare PROTO_ARGS((DLL x, DLL y));
extern int _dll_compare PROTO_ARGS((DLL x, DLL y));
extern DLL dll_union PROTO_ARGS((DLL x, DLL y));
extern DLL _dll_union PROTO_ARGS((DLL x, DLL y));
extern DLL dll_intersection PROTO_ARGS((DLL x, DLL y));
extern DLL _dll_intersection PROTO_ARGS((DLL x, DLL y));
extern DLL dll_difference PROTO_ARGS((DLL x, DLL y));
extern DLL _dll_difference PROTO_ARGS((DLL x, DLL y));
extern void dll_apply PROTO_ARGS((DLL list, void (*f)()));
extern void _dll_apply PROTO_ARGS((DLL list, void (*f)()));
extern int dll_index PROTO_ARGS((DLL list, DLL_INFO info));
extern int _dll_index PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_s_add PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_u_add PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_su_add PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_INFO _dll_s_delete PROTO_ARGS((DLL list, DLL_INFO info));
extern void _dll_exit PROTO_ARGS((int error));

#endif
