/*
 * maintain definitions
 */

#include <stdio.h>

#ifdef THINK_C
#include <strings.h>
#endif

#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_exits.h"
#include "main.h"
#include "memory.h"
#include "sign.h"
#include "tiltype.h"
#include "fieldex.h"
#include "std.h"
#include "options.h"
#include "constants.h"
#include "objects.h"
#include "expressions.h"
#include "definitions.h"


/* global variables for this module */

int NR_ATOMS, NR_PROCESSES, NR_SETS, NR_DEFS;	/* some constants */


void init_definitions(the_mod)
    struct module *the_mod;
{
    int i, j;

    NR_ATOMS = the_mod->entries_table[ATM];
    NR_PROCESSES = the_mod->entries_table[PRO];
    NR_SETS = the_mod->entries_table[SET];
    NR_DEFS = the_mod->entries_table[DEF];

    process = alloc_array(struct definition *, NR_PROCESSES + 1);
    atom = alloc_array(struct atom *, NR_ATOMS + 1);
    set = alloc_array(struct set *, NR_SETS + 1);

    for (i = 1; i <= NR_PROCESSES; i++) {
	process[i] = NULL;
    }

    for (i = 1; i <= NR_ATOMS; i++) {
	atom[i] = alloc_ptr(struct atom);
	atom[i]->name = psf_strdup(field_extract("n", the_mod->atm[i].ff,ATM,i));
	atom[i]->partner = alloc_array(int, NR_ATOMS + 1);
	for (j = 1; j <= NR_ATOMS; j++) {	/* clear communication matrix */
	    atom[i]->partner[j] = NO_COMMUNICATION;
	}
	/*
	 * printf("atom: %s\n",atom[i]->name);
	 */
    }

    for (i = 1; i <= NR_SETS; i++) {
	set[i] = alloc_ptr(struct set);
	set[i]->name = psf_strdup(field_extract("n", the_mod->set[i].ff,SET,i));
	if (the_mod->set[i].u_tag) {
	    set[i]->contents = enumerate_set(&(the_mod->set[i].construct.set_term),
					     the_mod->set[i].u_tag);
	} else {
	    set[i]->contents = get_set_contents(the_mod->set[i].construct.sort.key);
	}
    }
}


struct definition *new_definition()
{
    struct definition *tmp;

    tmp = alloc_ptr(struct definition);

    tmp->trace = UNKNOWN;
    tmp->expansion = UNEXPANDED;
    tmp->visited = FALSE;
    tmp->recursive = FALSE;
    tmp->derived = FALSE;
    tmp->name = NULL;
    tmp->derivative_cnt = 0;
    tmp->base = tmp;
    tmp->initial = NULL;
    tmp->myself = new_expression();
    tmp->myself->type = PRC_EXP;
    tmp->exp = NULL;

    return (tmp);
}


int any_recursion()
{
    int i;

    for_all_processes(i) {
	if (process[i]->recursive) {
	    return (TRUE);
	}
    }
    return (FALSE);
}


void clear_recursion_flag()
{
    int i;

    for_all_processes(i) {
	process[i]->recursive = FALSE;
    }
}


void clear_dependency_flag()
{
    int i;

    for_all_processes(i) {
	process[i]->dependent = FALSE;
    }
}


void read_definitions(the_mod)
    struct module *the_mod;
{
    int i, proc_index;
    struct expression *tmp_exp;

    for (i = 1; i <= the_mod->entries_table[DEF]; i++) {
	proc_index = the_mod->def[i].ae_t.ind.key;
	if (process[proc_index] == NULL) {
	    process[proc_index] = new_definition();
	    process[proc_index]->myself->type = PRC_EXP;
	    process[proc_index]->myself->index = proc_index;
	    process[proc_index]->exp = read_expression(i);
	    process[proc_index]->name =
		psf_strdup(field_extract("n", the_mod->pro[proc_index].ff,PRO,proc_index));
	} else {
	    tmp_exp = new_expression();
	    tmp_exp->type = ALT_EXP;
	    tmp_exp->left = process[proc_index]->exp;
	    tmp_exp->right = read_expression(i);
	    process[proc_index]->exp = tmp_exp;
	}
    }

    for_all_processes(i) {
	if (!process[i]) {
	    process[i] = new_definition();
	    process[i]->myself->index = i;
	    process[i]->name = psf_strdup(field_extract("n", the_mod->pro[i].ff,PRO,i));
	    process[i]->exp = new_expression();
	    process[i]->exp->type = DLK_EXP;
	}
    }
}


void install_comm(message, myself, partner, result)
    char *message;
    int myself, partner, result;
{
    if (atom[myself]->partner[partner] != NO_COMMUNICATION) {

	if (atom[myself]->partner[partner] == result) {
	    /*
	     * fprintf(stderr,"\n*** Warning: redefinition of communication:
	     * "); print_communication(myself,partner);
	     */
	} else {
	    fprintf(stderr, "\n*** Error: illegal redefinition of communication:\n");
	    printf("    ");
	    print_communication(myself, partner);
	    atom[myself]->partner[partner] = result;
	    printf("    ");
	    print_communication(myself, partner);
	    Error_Status = EXIT_SYNTAX_ERR;
	}
    }
    atom[myself]->partner[partner] = result;

    if (Option_Communication) {
	printf("%-15s : %s | %s = %s\n",
	       message,
	       atom[myself]->name,
	       atom[partner]->name,
	       atom[result]->name);
    }
}


void read_communications(the_mod)
    struct module *the_mod;
{
    int i, myself, partner, result;

    for (i = 1; i <= the_mod->entries_table[COM]; i++) {
	myself = the_mod->com[i].aet[0].ind.key;
	partner = the_mod->com[i].aet[1].ind.key;
	result = the_mod->com[i].aet[2].ind.key;
	install_comm("definition", myself, partner, result);
	install_comm("commutativity", partner, myself, result);
    }

    /* now check associativity */

#if 0
    for (i = 1; i <= NR_ATOMS; i++) {
	for (j = i; j <= NR_ATOMS; j++) {
	    for (k = j; k <= NR_ATOMS; k++) {

		inner1 = communication(i, j);
		result1 = communication(inner1, k);

		inner2 = communication(k, j);
		result2 = communication(inner2, i);

		inner3 = communication(i, k);
		result3 = communication(inner3, j);

		if (result1 != result2) {
		    fprintf(stderr, "\n*** Error: communication function is not associative:\n");
		    fprintf(stderr, "    ");
		    print_associativity(i, j, k, result1);
		    fprintf(stderr, "     & ");
		    print_associativity(k, j, i, result2);
		}
		if (result1 != result2) {
		    if (result1 != NO_COMMUNICATION) {
			if (result2 != NO_COMMUNICATION) {
			    fprintf(stderr, "\n*** Error: communication function is not associative:\n");
			    fprintf(stderr, "    ");
			    print_associativity(i, j, k, result1);
			    fprintf(stderr, "     & ");
			    print_associativity(k, j, i, result2);
			} else {
			    install_comm
			}
		    } else {
		    }
		}
		if (result1 != NO_COMMUNICATION) {
		    if (result2 != NO_COMMUNICATION) {

			if (result1 != result2) {
			    fprintf(stderr, "\n*** Error: communication function is not associative:\n");
			    fprintf(stderr, "    ");
			    print_associativity(i, j, k, result1);
			    fprintf(stderr, "     & ");
			    print_associativity(k, j, i, result2);
			}
			if (result3 != NO_COMMUNICATION) {

			    /* 1,2,3 are defined */
			    if (result1 != result2) {
				fprintf(stderr, "\n*** Error: communication function is not associative:\n");
				fprintf(stderr, "    ");
				print_associativity(i, j, k, result1);
				fprintf(stderr, "     & ");
				print_associativity(k, j, i, result2);
			    }
			} else {
			}
		    } else {
		    }
		} else {
		}
	    }
	}
    }
#endif
}


int communication(s, r)
    int s, r;
{
    if (s == NO_COMMUNICATION || r == NO_COMMUNICATION) {
	return (NO_COMMUNICATION);
    } else {
	return (atom[s]->partner[r]);
    }
}


void print_communication(s, r)
    int s, r;
{
    if (atom[s]->partner[r] != NO_COMMUNICATION) {
	printf("%s | %s = %s\n",
	       atom[s]->name,
	       atom[r]->name,
	       atom[atom[s]->partner[r]]->name);
    }
}


void print_associativity(x, y, z, result)
    int x, y, z, result;
{
    printf("(%s | %s) | %s = %s\n",
	   atom[x]->name,
	   atom[y]->name,
	   atom[z]->name,
	   atom[result]->name);
}


void print_communications()
{
    int i, j;

    for (i = 1; i <= NR_ATOMS; i++) {
	for (j = 1; j <= NR_ATOMS; j++) {
	    print_communication(i, j);
	}
    }
}


void print_definition(def)
    struct definition *def;
{

    if (def != NULL) {
	print_identifier(PRC_EXP, def->myself->index);
	printf(" = ");
	print_expression(def->exp);
	printf("\n");
    }
}


void print_definitions()
{
    int i;

    for_all_processes(i) {
	print_definition(process[i]);
    }
}


int finite_trace_exp(exp)
    struct expression *exp;
{

#if 0
    printf("* ");
    print_expression(exp);
    printf(" *\n");
#endif

    switch (exp->type) {
    case ATM_EXP:
	return (TRUE);
	break;
    case PRC_EXP:
	return (finite_trace(process[exp->index]));
	break;
    case SEQ_EXP:
	return (finite_trace_exp(exp->left) && finite_trace_exp(exp->right));
	break;
    case ALT_EXP:
	return (finite_trace_exp(exp->left) || finite_trace_exp(exp->right));
	break;
    case PAR_EXP:
    case LMG_EXP:
    case COM_EXP:
	return (finite_trace_exp(exp->left) && finite_trace_exp(exp->right));
	break;
    case HID_EXP:
	return (finite_trace_exp(exp->right));
	break;
    case ENC_EXP:
	return (finite_trace_exp(exp->right));
	break;
    case SKP_EXP:
	return (TRUE);
	break;
    case DLK_EXP:
	return (FALSE);
	break;
    case TCK_EXP:
	return (TRUE);
	break;
    default:
	fprintf(stderr, "illegal expression type\n");
	ProgrammerError;
	break;
    }
    ProgrammerError;
    return (UNDEFINED);
}


int finite_trace(def)
    struct definition *def;
{
    switch (def->trace) {
    case FINITE:
	return (TRUE);
	break;
    case INFINITE:
	return (FALSE);
	break;
    case UNKNOWN:
	if (def->visited == TRUE) {
	    return (FALSE);
	} else {
	    def->visited = TRUE;
	    if (finite_trace_exp(def->exp)) {
		def->trace = FINITE;
	    } else {
		def->trace = INFINITE;
	    }
	    def->visited = FALSE;
	    return (finite_trace(def));
	}
	break;
    default:
	fprintf(stderr, "illegal tracing type\n");
	ProgrammerError;
	break;
    }
    ProgrammerError;
    return (UNDEFINED);
}


int guardedness()
{
    int i, j, change = FALSE, error_message_shown = FALSE;


    for_all_processes(i) {
	process[i]->unguarded_in = alloc_array(int, NR_PROCESSES + 1);
	for_all_processes(j) {
	    process[i]->unguarded_in[j] = FALSE;
	}
	process[i]->unguarded_in =
	    fill_in_guard_info(process[i]->exp, process[i]->unguarded_in);

#if 0
	if (process[i]->unguarded_in[i]) {	/* process is unguarded */
	    Error_Status = EXIT_SYNTAX_ERR;
	    fprintf(stderr, "*** Error: unguarded specification\n");
	    print_definition(process[i]);
	}
#endif

    }

    do {
	change = FALSE;
	for_all_processes(i) {
	    if (!process[i]->guarded) {
		if (guarded(process[i])) {
		    process[i]->guarded = TRUE;
		    change = TRUE;
		}
	    }
	}
    } while (change);

    for_all_processes(i) {
	if (!process[i]->guarded) {
	    if (!error_message_shown) {
		Error_Status = EXIT_SYNTAX_ERR;
		fprintf(stderr, "\n*** Error: unguarded specification\n");
		error_message_shown = TRUE;
	    }
	    fprintf(stderr, "    ");
	    print_definition(process[i]);
	}
    }
    return (Error_Status == EXIT_SUCCESS);
}


int guarded(proc)
    struct definition *proc;
{
    int i;

    for_all_processes(i) {
	if (proc->unguarded_in[i]) {
	    if (!process[i]->guarded) {
		return (FALSE);
	    }
	}
    }
    return (TRUE);
}


int *fill_in_guard_info(expr, table)
    struct expression *expr;
    int table[];
{
    switch (expr->type) {
    case PRC_EXP:
	table[expr->index] = TRUE;
	break;
    case ATM_EXP:
    case DLK_EXP:
    case SKP_EXP:
	break;
    case SEQ_EXP:
	fill_in_guard_info(expr->left, table);
	break;
    case ALT_EXP:
    case PAR_EXP:
	fill_in_guard_info(expr->left, table);
	fill_in_guard_info(expr->right, table);
	break;
    case HID_EXP:
    case ENC_EXP:
	fill_in_guard_info(expr->right, table);
	break;
    default:
	printf("list_ung_exp: unknown switch\n");
	break;
    }
    return (table);
}


DLL get_set_contents(index)
    int index;
{
    if (!set[index]) {
	fprintf(stderr, "*** Error: use before declaration. set '%s'\n",
		set[index]->name);
	Error_Status = EXIT_SYNTAX_ERR;
	return (dll_su_create(cmp_integers));	/* return an empty set */
    } else {
	return (set[index]->contents);
    }
}


DLL enumerate_set(trm, a_trm)
    struct s_term *trm;
    int a_trm;
{
    int i;
    DLL tmp = NULL;
    struct ae_term *the_set;

    if (!a_trm) {		/* it's not a set term but a set */
	the_set = (struct ae_term *) trm;
	return (get_set_contents(the_set->ind.key));
    }
    switch (trm->fun) {

    case ENU:
	tmp = dll_su_create(cmp_integers);
	for (i = 0; i < trm->a; i++) {
	    dll_add(tmp, (DLL_INFO) trm->arr[i].ae_t->ind.key);
	}
	break;

    case UNI:
	if (trm->a != 2) {
	    fprintf(stderr, "Only binary operators supported!\n");
	    ProgrammerError;
	}
	return (dll_union(
			  enumerate_set(trm->arr[0].s_t, trm->u_tag[0]),
			  enumerate_set(trm->arr[1].s_t, trm->u_tag[1])));
	break;

    case INT:
	if (trm->a != 2) {
	    fprintf(stderr, "Only binary operators supported!\n");
	    ProgrammerError;
	}
	return (dll_intersection(
				 enumerate_set(trm->arr[0].s_t, trm->u_tag[0]),
			      enumerate_set(trm->arr[1].s_t, trm->u_tag[1])));
	break;

    case DIF:
	if (trm->a != 2) {
	    fprintf(stderr, "Only binary operators supported!\n");
	    ProgrammerError;
	}
	return (dll_difference(
			       enumerate_set(trm->arr[0].s_t, trm->u_tag[0]),
			       enumerate_set(trm->arr[1].s_t, trm->u_tag[1])));
	break;

    default:
	fprintf(stderr, "unknown set-operation. code(%c)\n", trm->fun);
	Error_Status = EXIT_SYNTAX_ERR;
	ProgrammerError;
	break;
    }
    return (tmp);
}


void fprint_set(file, set)
    FILE *file;
    DLL set;
{
    int index;
    DLL_ITEM ptr;

    fprintf(file, "{ ");

    DLL_FORALL(set, ptr) {
	index = (int) dll_inspect(ptr);
	fprintf(file, "%s ", atom[index]->name);
    }

    fprintf(file, "}");
}


void print_sets()
{
    int i;

    for (i = 1; i <= NR_SETS; i++) {
	printf("%s = ", set[i]->name);
	print_set(set[i]->contents);
	printf("\n");
    }
}
