/*
 * utilities to manipulate epsilon closures
 */

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "psf_prototype.h"
#include "constants.h"
#include "options.h"
#include "expressions.h"
#include "transitions.h"
#include "objects.h"
#include "memory.h"
#include "states.h"
#include "closure.h"

DLL the_closures = NULL;	/* global list of all closures */


void init_closure()
{
    if (!the_closures) {
	the_closures = dll_u_create(cmp_closures);
    }
}


void epsilon_closure(eps_closure, state, ancestor)
    DLL eps_closure;
    struct state *state, *ancestor;
{
    DLL_ITEM ptr;
    struct transition *the_transition;
    int state_added = FALSE;

    if (Option_Debug) {
	printf("e-closure visiting: S%d\n", state->index);
    }
    if (state->visited) {
	return;
    }
    state->visited = TRUE;

    switch (state->exp->type) {

    case TCK_EXP:
	ancestor->final = TRUE;
	dll_add(eps_closure, (DLL_INFO) state);
	break;

    case DLK_EXP:
	ancestor->deadlock = TRUE;
	dll_add(eps_closure, (DLL_INFO) state);
	break;

    default:
	DLL_FORALL(state->transitions, ptr) {
	    the_transition = (struct transition *) dll_inspect(ptr);
	    if (the_transition->label->type != EPS_EXP) {
		ancestor->non_epsilon = TRUE;
		if (!state_added) {
		    state_added = TRUE;
		    dll_add(eps_closure, (DLL_INFO) state);
		}
	    } else {
		epsilon_closure(eps_closure, the_transition->target, ancestor);
	    }
	}
    }
    state->visited = FALSE;
}


void epsilon_closure_of_state(the_state)
    struct state *the_state;
{
    epsilon_closure(the_state->epsilon_closure, the_state, the_state);
}


int cmp_closures(c1, c2)
    DLL_INFO c1, c2;
{
    return (dll_compare((DLL) c1, (DLL) c2));
}


void epsilon_closures()
{
    DLL_ITEM state_ptr;
    struct state *the_state;

    DLL_FORALL(the_states, state_ptr) {
	the_state = (struct state *) dll_inspect(state_ptr);

	if (Option_Debug) {
	    printf("epsilon closure: S%d = \n", the_state->index);
	}
	epsilon_closure_of_state(the_state);

	if (Option_Debug) {
	    print_epsilon_closure(the_state->epsilon_closure);
	}
	dll_add(the_closures, (DLL_INFO) the_state->epsilon_closure);
	the_state->block = dll_index(the_closures, (DLL_INFO) the_state->epsilon_closure);

	if (Option_Debug) {
	    printf(" = B%d\n\n", the_state->block);
	}
    }
}


void print_epsilon_closure(closure)
    DLL closure;
{

    DLL_ITEM closure_ptr;
    struct state *the_item;

    printf("{");
    DLL_FORALL(closure, closure_ptr) {
	the_item = (struct state *) dll_inspect(closure_ptr);
	printf(" S%d", the_item->index);
    }
    printf(" }");
}


void print_epsilon_closures()
{
    DLL_ITEM state_ptr;
    struct state *the_state;

    DLL_FORALL(the_states, state_ptr) {
	the_state = (struct state *) dll_inspect(state_ptr);
	printf("epsilon-closure(S%d) = ", the_state->index);
	print_epsilon_closure(the_state->epsilon_closure);
	printf(" = B%d\n", the_state->block);
    }
}
