/*
 * check validity of system of definitions, no arguments allowed
 */

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "fieldex.h"


int check_args(mod)		/* check whether all atoms/proc's are argument
				 * free */
    struct module *mod;
{
    int arg = 0, i;

    for (i = 1; i < mod->entries_table[ATM]; i++) {
	if (mod->atm[i].sor_indlist.a != 0) {
	    arg = 1;
	    fprintf(stderr, "Atom '%s' not argument-free\n",
		    field_extract("n", mod->atm[i].ff,ATM,i));
	}
    }
    for (i = 1; i < mod->entries_table[DEF]; i++) {
	if (mod->def[i].ae_t.a != 0) {
	    arg = 1;
	    fprintf(stderr, "Process '%s' not argument-free\n",
		    field_extract("n", mod->pro[mod->def[i].ae_t.ind.key].ff,PRO,mod->def[i].ae_t.ind.key));
	}
    }
    return (arg);
}
