
struct block {
    unsigned processed:1;	/* flag for transition transfer */
    unsigned reachable:1;	/* flag for reachability analysis */
    unsigned deadlock:1;	/* flag signalling deadlock state */
    unsigned final:1;		/* flag signalling final state */
    unsigned non_epsilon:1;	/* flag for non-epsilon transition  */
    int index;			/* index in block list */
    union {
	int til_index;		/* index in til file */
	int fc2_index;		/* index in fc2 file */
    } file_index;
    DLL elements;		/* elements of the block */
    DLL transitions;		/* transitions from this block */
    struct expression *exp;	/* preferred name on output locally */
    char *name;			/* preferred name on output of TIL file */
};

/* blocks.c */
extern struct block *the_block;
extern int NR_BLOCKS;
extern int REACHABLE_BLOCKS;
extern int cmp_block_transitions PROTO_ARGS((DLL_INFO trans1, DLL_INFO trans2));
extern void make_blocks PROTO_ARGS((void));
extern void make_trans_for_blocks PROTO_ARGS((void));
extern void print_trans_for_blocks PROTO_ARGS((int reachability));
extern void print_trans_for_pref_names PROTO_ARGS((void));
extern void preferred_names PROTO_ARGS((void));
extern void reachable_blocks PROTO_ARGS((void));
extern void reachable_block PROTO_ARGS((int index));
extern void print_blocks PROTO_ARGS((int reachability));
extern void print_reachable_blocks_and_trans PROTO_ARGS((void));
