/*
        _dll.h : include file with private functions


*/

#include "dll.h"

#define LIST_ID 13579		/* magic number to identify list */
#define ITEM_ID 24680		/* magic number to identify item */
#define FREED_LIST_ID 97531	/* magic number to identify freed list */
#define FREED_ITEM_ID 8642	/* magic number to identify freed item */

DLL_ITEM _dll_s_add();          /* insert into sorted list */
DLL_ITEM _dll_u_add();		/* insert non-identical items only */
DLL_ITEM _dll_su_add(); 	/* add to sorted list, non-identical only */

DLL_INFO _dll_s_delete();       /* delete from sorted list */


DLL_ITEM _dll_create_item();	/* create a list item */
DLL_INFO _dll_delete_item();	/* delete a list item */
void _dll_dispose_item();	/* return item's memory to the free-list */

DLL_ITEM _dll_add_first();	/* insert in a list, no checks */
DLL_ITEM _dll_add_last();	/* append to a list, no checks */
DLL_ITEM _dll_insert_at();	/* insert at certain position, no checks */
DLL_ITEM _dll_append_at();	/* append at certain position, no checks */

#if DLL_CHECK
void check_list();		/* check for valid list pointer */
void check_item();		/* check for valid item pointer */
void check_non_empty_list();	/* check that the list is not empty */
void check_order_fns();		/* check that the lists have equal functions */
void check_non_sorted();	/* check that the list is not sorted */
void check_on_list();		/* check that item is part of the list */
void check_list_types();	/* check for equal list types */

int cmp_pointers();		/* compare to pointers */
#endif

void _dll_exit();		/* exit from 'dll' after error */

/* _DLL_FORALL: make a for loop traversing all elements from l using p as ptr */
#define _DLL_FORALL(l,p) for(p=_dll_go_first(l);p!=NULL;p=_dll_go_fw(p))


/* private no checking functions */

DLL _dll_create_descendent();   /* create a list of same type */

void _dll_flush();              /* delete all elements of doubly linked list */
void _dll_dispose();            /* dispose a doubly linked list */
DLL _dll_copy();                /* create a copy of a doubly linked list */

int _dll_empty();               /* check for empty list */
int _dll_first();               /* first element in list? */
int _dll_last();                /* last element in list? */

DLL_ITEM _dll_go_first();       /* go to first element */
DLL_ITEM _dll_go_last();        /* go to last element */
DLL_ITEM _dll_go_fw();          /* go to next element */
DLL_ITEM _dll_go_bw();          /* go to previous element */

DLL_ITEM _dll_add();            /* add info to the list */
DLL_ITEM _dll_insert();         /* insert info at the front of list */
DLL_ITEM _dll_append();         /* append info at the back of list */
DLL_ITEM _dll_add_before();     /* insert info at current element */
DLL_ITEM _dll_add_after();      /* append info at current element */

DLL_INFO _dll_delete();         /* retrieve and delete the current element */
DLL_INFO _dll_delete_info();    /* retrieve and delete info */
DLL_INFO _dll_delete_first();   /* retrieve and delete the front element */
DLL_INFO _dll_delete_last();    /* retrieve and delete the rear element */

DLL_INFO _dll_inspect();        /* get current element */
DLL_INFO _dll_inspect_first();  /* get first element */
DLL_INFO _dll_inspect_last();   /* get last element */

DLL_ITEM _dll_search();		/* search item for info */

DLL _dll_union();		/* compute the union of two lists */
DLL _dll_intersection();	/* compute the intersection of two lists */
DLL _dll_difference();		/* compute the difference of two lists */

void _dll_apply();              /* apply function to all elements from list */
int  _dll_compare();            /* compare two lists */

int  _dll_count();              /* count the number of items */
int  _dll_index();              /* return index of item, -1 if not on list */



