#ifndef TABLES_H
#define TABLES_H

#include "expr.h"
#include "list.h"

#define DIRECT 0
#define TABLE 0
#define LABEL 1

typedef struct {
  int  id;		/* optional number */
  int  tiltype;		/* til type generation */
  int  tilindex;	/* til index generation */
  expr *exp;		/* expression */
} tableentry;

typedef struct {
  int     typ;		/* STRUCT, BEHAV, LOGIC, HOOK */
  int     ind;		/* direct = 0, indirect != 1 */
  int     ofs;		/* offset if indirect , last referrable if direct */
  list    *ilst;	/* list of tableentry */
} tableitem;

typedef struct {
  int  typ;		/* STRUCT, BEHAV, LOGIC, HOOK */
  expr *exp;		/* hook, struct, behav or logic expression */
} labelitem;

typedef struct {
  list *tab;		/* tables */
  list *lab;		/* labels */
} tlitem;

typedef struct {
  int typ;
  labelitem *lab;
  tableitem *tab;
} tolitem;

typedef struct {
  int    id;		/* optional number */
  list   *lab;		/* labels */
  int    nbr;		/* nbr of resulting states */
  expr   *slst;		/* resulting states in form "1+2+3+...+x" */
} edgeitem;

typedef struct {
  int    id;		/* optional number */
  list   *lab;		/* label structure */
  list   *elst;		/* list of edge items */
} vertexitem;
 
typedef struct {
  int      id;		/* optional number */
  tlitem   *tl;		/* tables and labels */
  list     *vlt;	/* very local tables */
  list     *vlst;	/* list of vertex items */
} netitem;

typedef struct {
  tlitem   *tl;		/* tables and labels */
  list     *nlst;	/* array of net items */
} netstable;

/* tables.c */
extern netstable *netsp;
extern netstable *createnetstable PROTO_ARGS((tlitem *tl, list *nl));
extern netitem *createnetitem PROTO_ARGS((int id, tlitem *tl, list *vl));
extern vertexitem *createvertexitem PROTO_ARGS((int id, list *lbl, list *edg));
extern edgeitem *createedgeitem PROTO_ARGS((int id, list *lbl, expr *exp));
extern list *createtables PROTO_ARGS((void));
extern list *createlabels PROTO_ARGS((void));
extern tableitem *createtableitem PROTO_ARGS((int typ, int ind, int ofs, list *lst));
extern labelitem *createlabelitem PROTO_ARGS((int typ, expr *exp));
extern tableentry *createtableentry PROTO_ARGS((int id, expr *exp));
extern tlitem *createtlitem PROTO_ARGS((void));
extern list *addnetitem PROTO_ARGS((list *nl, netitem *ni));
extern list *addvertexitem PROTO_ARGS((list *vl, vertexitem *vi));
extern list *addedgeitem PROTO_ARGS((list *el, edgeitem *ei));
extern list *addtableitem PROTO_ARGS((list *tl, tableitem *ti));
extern list *addtableentry PROTO_ARGS((list *tl, tableentry *te));
extern list *addlabelitem PROTO_ARGS((list *ll, labelitem *li));
extern list *addexpentry PROTO_ARGS((list *el, expr *e));
extern labelitem *typedlabel PROTO_ARGS((list *l, int t));
extern labelitem *structlabel PROTO_ARGS((list *l));
extern labelitem *behavlabel PROTO_ARGS((list *l));
extern labelitem *logiclabel PROTO_ARGS((list *l));
extern labelitem *hooklabel PROTO_ARGS((list *l));
extern tableitem *typedtable PROTO_ARGS((list *l, int t));
extern tableitem *structtable PROTO_ARGS((list *l));
extern tableitem *behavtable PROTO_ARGS((list *l));
extern tableitem *logictable PROTO_ARGS((list *l));
extern tableitem *hooktable PROTO_ARGS((list *l));
extern list *addtypedtableentry PROTO_ARGS((list *ta, int ty, tableentry *te));
extern vertexitem *findvertex PROTO_ARGS((netitem *n, expr *e));

#endif
