#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_exits.h"
#include "symtab.h"
#include "lexyacc.h"

netstable *netsp;

netstable *createnetstable(tl,nl)
tlitem *tl;
list *nl;
{
    netstable *t = PSF_MALLOC(netstable);

    t->tl = tl;			/* tables and labels */
    t->nlst = nl;		/* a list of netitems */
    return (t);
}

netitem *createnetitem(id,tl,vl)
int  id;
tlitem *tl;
list *vl;
{
    netitem *i = PSF_MALLOC(netitem);

    i->id = id;
    i->tl = tl;
    i->vlt = NULL;
    i->vlst = vl;
    return (i);
}

vertexitem *createvertexitem(id,lbl,edg)
int id;
list *lbl;
list *edg;
{
    vertexitem *v = PSF_MALLOC(vertexitem);

    v->id = id;
    v->lab = lbl;
    v->elst = edg;
    return (v);
}

edgeitem *createedgeitem(id,lbl,exp)
int id;
list *lbl;
expr *exp;
{
    edgeitem *e = PSF_MALLOC(edgeitem);

    e->id = id;
    e->lab = lbl;
    e->slst = exp;
    return (e);
}

list *createtables()
{
    return (createlist());
}

list *createlabels()
{
    return (createlist());
}

tableitem *createtableitem(typ,ind,ofs,lst)
int typ;
int ind;
int ofs;
list *lst;
{
    tableitem *t = PSF_MALLOC(tableitem);

    t->typ = typ;
    t->ind = ind;
    t->ofs = ofs;
    t->ilst = lst;
    return (t);
}

labelitem *createlabelitem(typ,exp)
int typ;
expr *exp;
{
    labelitem *l = PSF_MALLOC(labelitem);

     l->typ = typ;
     l->exp = exp;
     return (l);
}

tableentry *createtableentry(id,exp)
int  id;
expr *exp;
{
    tableentry *e = PSF_MALLOC(tableentry);

    e->id = id;
    e->tiltype = -1;
    e->tilindex = -1;
    e->exp = exp;
    return (e);
}

tlitem *createtlitem()
{
    tlitem *tl = PSF_MALLOC(tlitem);

    tl->tab = NULL;
    tl->lab = NULL;
    return (tl);
}

list *addnetitem(nl,ni)
list *nl;
netitem *ni;
{
    list *l = nl;

    if (l == NULL) {
	l = createlist();
    }
    appendlist(l, (listitem) ni);
    return (l);
}

list *addvertexitem(vl,vi)
list *vl;
vertexitem *vi;
{
    list *l = vl;

    if (l == NULL) {
	l = createlist();
    }
    appendlist(l, (listitem) vi);
    return (l);
}

list *addedgeitem(el,ei)
list *el;
edgeitem *ei;
{
    list *l = el;

    if (l == NULL) {
	l = createlist();
    }
    appendlist(l, (listitem) ei);
    return (l);
}

list *addtableitem(tl,ti)
list *tl;
tableitem *ti;
{
    list *l = tl;

    if (l == NULL) {
	l = createlist ();
    }
    appendlist(l, (listitem) ti);
    return (l);
}

list *addtableentry(tl,te)
list *tl;
tableentry *te;
{
    list *l = tl;

    if (l == NULL) {
	l = createlist();
    }
    appendlist(l, (listitem) te);
    return (l);
}


list *addlabelitem(ll,li)
list *ll;
labelitem *li;
{
    list *l = ll;

    if (l == NULL) {
	l = createlist ();
    }
    appendlist(l, (listitem) li);
    return (l);
}

list *addexpentry(el,e)
list *el;
expr *e;
{
    list *l = el;

    if (l == NULL) {
	l = createlist();
    }
    appendlist(l, (listitem) e);
    return (l);
}

labelitem *typedlabel(l,t)
list *l;
int t;
{
    int i;

    FORALL(l,i) {
	labelitem *li = (labelitem *)getitem(l,i);
	if (li->typ == t) {
	    return (li);
	}
    }
    return (NULL);
}

labelitem *structlabel(l)
list *l;
{
    return (typedlabel(l,STRUCT));
}

labelitem *behavlabel(l)
list *l;
{
    return (typedlabel(l,BEHAV));
}

labelitem *logiclabel(l)
list *l;
{
    return (typedlabel(l,LOGIC));
}

labelitem *hooklabel(l)
list *l;
{
    return (typedlabel(l,HOOK));
}

tableitem *typedtable(l,t)
list *l;
int t;
{
    int i;

    FORALL(l,i) {
	tableitem *ti = (tableitem *)getitem(l,i);
	if (ti->typ == t) {
	    return (ti);
	}
    }
    return (NULL);
}

tableitem *structtable(l)
list *l;
{
    return (typedtable(l,STRUCT));
}

tableitem *behavtable(l)
list *l;
{
    return (typedtable(l,BEHAV));
}

tableitem *logictable(l)
list *l;
{
    return (typedtable(l,LOGIC));
}

tableitem *hooktable(l)
list *l;
{
    return (typedtable(l,HOOK));
}

list *addtypedtableentry(ta,ty,te)
list *ta;
int ty;
tableentry *te;
{
    list *t = ta;
    tableitem *ti;

    ti = typedtable(t,ty);
    if (ti == NULL) {
	ti = createtableitem(ty,DIRECT,0,NULL);
	t = addtableitem(t,ti);
    }
    ti->ilst = addtableentry(ti->ilst,te);

    return (t);
}

vertexitem *findvertex(n,e)
netitem *n;
expr *e;
{
    int i;

    FORALL(n->vlst,i) {
	vertexitem *vi=(vertexitem *)getitem(n->vlst,i);
	labelitem *li=typedlabel(vi->lab,STRUCT);
	switch (e->operator) {
	case INTEGER:
	    if (eval(e) == vi->id) {
		return (vi);
	    }
	    break;
	case STRING:
	    if ((li) && (e->operator == li->exp->operator)) {
		if (strcmp(map[e->value].text,map[li->exp->value].text) == 0) {
		    return (vi);
		}
	    }
	    break;
	default:
	    fprintf(stderr,"Invalid expression operator in findvertex.\n");
	    exit(EXIT_HELP);
	}
    }
    return (NULL);
}
