#ifndef SYMTAB_H
#define SYMTAB_H

#define MAXNAMES 500

typedef void *syminfo;

typedef struct symtabtype {
	int     type;			/* Symbol type CONST,OPERATOR...    */
	char    *text;			/* The symbol stored at this node   */
	int     id;			/* map index                        */
	syminfo info;			/* attached info depends on type    */
	struct  symtabtype *left,*right;/* Subtrees of this node            */
} symtab;

/* symtab.c */
extern symtab map[MAXNAMES];		/* The symbol table		    */
extern int    mapindex;			/* The next free symbol table loc   */

extern int inmap PROTO_ARGS((char *text, int typ));
extern int findmap PROTO_ARGS((char *text));

#endif
