#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "psf_malloc.h"
#include "symtab.h"

int	mapindex = 0;
int	oldmapindex = 0;
symtab	map[MAXNAMES];

/*
 * return the mapindex of the input string, creating a new one if necessary.
 */
int inmap(text,typ)
char *text;
int  typ;
{
    symtab *pointer;
    int compare;
    char *save;

    oldmapindex = mapindex;	/* saved to check if add is done */
    if (!mapindex) {		/* If there are no symbols yet, create root
				 * of tree */
	save = PSF_NMALLOC(char,strlen(text) + 1);
	strcpy(save, text);
	map[0].text = save;
	map[0].id = 0;
	map[0].type = typ;
	map[0].info = NULL;
	map[0].left = NULL;
	map[0].right = NULL;
	return (mapindex++);
    };
    pointer = map;		/* Start at the root of the tree */
    while (TRUE) {
	compare = strcmp(text, pointer->text);
	if (compare == 0)
	    return pointer->id;	/* If the string is found, return index */
	if (compare > 0)
	    if (pointer->right)	/* If not at a leaf...    */
		pointer = pointer->right;	/* Move down to right     */
	    else {		/* Else create a new leaf */
	        if (mapindex == MAXNAMES) {
	       	    fprintf(stderr,"inmap: symbol table full\n");
	            exit(1);
	        }
		save = PSF_NMALLOC(char,strlen(text) + 1);
		strcpy(save, text);
		map[mapindex].text = save;
		map[mapindex].id = mapindex;
		map[mapindex].type = typ;
		map[mapindex].info = NULL;
		map[mapindex].left = NULL;
		map[mapindex].right = NULL;
		pointer->right = &map[mapindex];
		return mapindex++;
	    }
	else if (pointer->left)	/* If not at a leaf...    */
	    pointer = pointer->left;	/* Move down to left */
	else {			/* Else create a new leaf */
	    if (mapindex == MAXNAMES) {
	        fprintf(stderr,"inmap: symbol table full\n");
	        exit(1);
	    }
	    save = PSF_NMALLOC(char,strlen(text) + 1);
	    strcpy(save, text);
	    map[mapindex].text = save;
	    map[mapindex].id = mapindex;
	    map[mapindex].type = typ;
	    map[mapindex].info = NULL;
	    map[mapindex].left = NULL;
	    map[mapindex].right = NULL;
	    pointer->left = &map[mapindex];
	    return mapindex++;
	}
    }
}

/*
 * return the mapindex of the input string, if present.
 */
int findmap(text)
char *text;
{
    symtab *pointer;
    int compare;

    if (!mapindex) {				/* if no root, find fails */
	return (-1);
    };

    pointer = map;				/* start at the tree root */
    while (TRUE) {
	compare = strcmp(text, pointer->text);
	if (compare == 0)
	    return pointer->id;			/* if found, return index */
	if (compare > 0)
	    if (pointer->right)			/* if not at a leaf...    */
		pointer = pointer->right;	/* move down to right     */
	    else {				/* else find fails        */
	        return (-1);
	    }
	else if (pointer->left)			/* if not at a leaf...    */
	    pointer = pointer->left;		/* move down to left      */
	else {					/* else find fails        */
	    return (-1);
	}
    }
}
