#ifndef OPERATOR_H
#define OPERATOR_H

#include "psf_standards.h"
#include "list.h"

typedef struct {
    list *domain;
    int  codomain;
} domains;

typedef struct {
    bool predef;	/* true = predefined, false = not predefined */
    int  priority;	/* the operator priority 4 for INFIX_OP, 
						 3 for INFIX3_OP,
						 2 for INFIX2_OP,... */
    int  optype;	/* CONSTANT_DECL, ... */
    int  a;		/* arity */
    char *text;
    int	 *domain;	/* array of type: the arguments of operators */
    int	 codomain;	/* the target of operator: ANY_TYPE, ... */
} opentry;

/* operator.c */
extern int last_predef;

extern void load_predef_op PROTO_ARGS((void));
extern int find_operator PROTO_ARGS((char *op, int *i));
extern int install_op PROTO_ARGS((char *op, int optype, list *domain, int codomain));

#endif
