#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "util.h"
#include "main.h"
#include "symtab.h"
#include "lexyacc.h"

/* predifined operator indices */

int	TAU;
int	TAU1;
int	QUIT;
int	DOT;
int	COMMA;
int	LT;
int	GT;
int	PLUS;
int	SEMI;
int	SHRIEK;
int	QUEST;
int	TILDE;
int	last_predef;

void load_predef_op() /* install predefined operators */
{
	char	*s;
 
	/*********************************** constant operators */
 
	s = strfit("t");
	TAU = install_op(s, CONSTANT, NULL, BEHAV);
	((opentry *)map[TAU].info)->predef = 1;
 
	s = strfit("tau");
	TAU1 = install_op(s, CONSTANT, NULL, BEHAV);
	((opentry *)map[TAU1].info)->predef = 1;
 
	s = strfit("quit");
	QUIT = install_op(s, CONSTANT, NULL, BEHAV);
	((opentry *)map[QUIT].info)->predef = 1;
 
	/******************* prefix operators, watch priority ! */
 
	s = strfit(".");
	DOT = install_op(s, INFIX0,
			appendintlist(ANY, appendintlist(ANY, NULL)),
			ANY);
	((opentry *)map[DOT].info)->predef = TRUE;
	((opentry *)map[DOT].info)->priority = 0;

	s = strfit(",");
	COMMA = install_op(s, INFIX1,
			appendintlist(ANY, appendintlist(ANY, NULL)),
			ANY);
	((opentry *)map[COMMA].info)->predef = TRUE;
	((opentry *)map[COMMA].info)->priority = 1;

	s = strfit("<");
	LT = install_op(s, INFIX2,
			appendintlist(ANY, appendintlist(ANY, NULL)),
			ANY);
	((opentry *)map[LT].info)->predef = TRUE;
	((opentry *)map[LT].info)->priority = 2;

	s = strfit(">");
	GT = install_op(s, INFIX3,
			appendintlist(ANY, appendintlist(ANY, NULL)),
			ANY);
	((opentry *)map[GT].info)->predef = TRUE;
	((opentry *)map[GT].info)->priority = 2;

	s = strfit("+");
	PLUS = install_op(s, INFIX4,
			appendintlist(ANY, appendintlist(ANY, NULL)),
			ANY);
	((opentry *)map[PLUS].info)->predef = TRUE;
	((opentry *)map[PLUS].info)->priority = 3;

	s = strfit(";");
	SEMI = install_op(s, INFIX5,
			appendintlist(ANY, appendintlist(ANY, NULL)),
			ANY);
	((opentry *)map[SEMI].info)->predef = TRUE;
	((opentry *)map[SEMI].info)->priority = 4;

	/*************************************** unary operators */
 
	s = strfit("!");
	SHRIEK = install_op(s, UNARY, appendintlist(ANY, NULL), ANY);
	((opentry *)map[SHRIEK].info)->predef = TRUE;

	s = strfit("?");
	QUEST = install_op(s, UNARY, appendintlist(ANY, NULL), ANY);
	((opentry *)map[QUEST].info)->predef = TRUE;

	s = strfit("~");
	TILDE = install_op(s, UNARY, appendintlist(ANY, NULL), ANY);
	((opentry *)map[TILDE].info)->predef = TRUE;

	last_predef = TILDE;
}

/*
 * find_operator: return  the type of operator if is in map, else insert
 * and return UNDEF
 */
int find_operator(op, i)
char	*op;
int	*i;
{
	opentry	*entry;
	
	*i = findmap(op);
	if (*i != -1) {
	  entry = (opentry *)map[*i].info;
	  return (entry->optype);
	} else {
	  return (UNDEF);
	}
}

int install_op(op, optype, domain, codomain)
char	*op;
int	optype;
list	*domain;
int	codomain;
{
	int	index, i, j, l, t;
	bool	flagerr;
	opentry *entry;
 
	if (find_operator(op,&index) != UNDEF) {
		PSF_FREE(op);
		disposelist(domain);
		errfc++;
		fprintf(stderr, "install_op: operator already defined\n");
		return (0);
	} else {
	    index = inmap(op,optype);
	}
	l = listcount(domain);
	switch (optype) {
	case CONSTANT:
		if (l != 0) {
			fprintf(stderr, "install_op: constant with arity != 0\n");
			PSF_FREE(op);
			disposelist(domain);
			errfc++;
			return (0);
		}
		break;
	case INFIX:
		if (l != 2) {
			fprintf(stderr, "install_op: infix operator with arity != 2\n");
			PSF_FREE(op);
			disposelist(domain);
			errfc++;
			return (0);
		}
		break;
	case UNARY:
		if (l != 1) {
			fprintf(stderr, "install_op: unary operator with arity != 1\n");
			PSF_FREE(op);
			disposelist(domain);
			errfc++;
			return (0);
		}
		break;
	}
	entry = PSF_MALLOC(opentry);
        map[index].info = entry;
	entry->optype = optype;
	entry->a = l;
	entry->predef = 0;
	entry->priority = 4;
	if (l > 0) {
		flagerr = 0;
		entry->domain = PSF_NMALLOC(int,l);
		i=0;
		FORALL(domain,j) {
		    t = ((intlistitem *)getitem(domain,j))->val;
		    entry->domain[i++] = t;
		    flagerr += (t == ANY && codomain != ANY);
		}
		if (flagerr) {
			errfc++;
			fprintf(stderr, "type error in declaration\n");
			disposelist(domain);
			PSF_FREE(op);
			PSF_FREE(entry->domain);
			return (0);
		}
	} else {
		entry->domain = NULL;
	}
	disposelist(domain);
	entry->codomain = codomain;
	PSF_FREE(op);
	return (index);
}
