#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_exits.h"
#include "psf_fopen.h"
#include "env_variables.h"
#include "main.h"
#include "buildtil.h"
#include "writetil.h"
#include "lexyacc.h"
#include "version.h"
#include "dump.h"

#define OPTIONS "dDvsh"
#define OPTIONS_STR "-vsh" /* nobody needs to know about the dump stuff */
#define USAGE_STR "usage: %s [%s] [<fc-file> [<lts-file>]]\n"

/* This is the main program.  After initializing some global data,
   the YACC parser is called to build the til module table. If there are no 
   syntax errors, we write the file
*/


static suffix suffixes[] = {{FCSUFFIX, FCSUFFIX_DEFAULT}, {NULL, NULL}};

int  optind;
int  errfc = 0;             /* error status code */
bool optdebug = FALSE;      /* debugging switch given */
bool optdump = FALSE;       /* fc2 dump switch given */
bool optshort = FALSE;      /* short notation of fc strings */
bool optverbose = FALSE;    /* verbose switch given */
char *progname;             /* program name */
psf_file pf;		    /* psf file from psf_fopen */

tilmodule *mod;

extern FILE *yyin;

int main(argc, argv)
	int  argc;
	char **argv;
{
	FILE *lts_out=NULL;
	char *in_file=NULL,*out_file=NULL;
	char *pn;
	int  opt;

	progname = argv[0];

	/* parse options */

	while ((opt = getopt(argc,argv,OPTIONS)) != -1) {
		switch (opt) {
		case 'd':
			optdebug = TRUE;
			break;
		case 'D':
			optdump = TRUE;
			break;
		case 's':
			optshort = TRUE;
			break;
		case 'v':
			optverbose = TRUE;
			break;
		case 'h':
			fprintf(stderr,USAGE_STR,argv[0],OPTIONS_STR);
			exit(EXIT_SUCCESS);
		case '?':
			fprintf(stderr,USAGE_STR,argv[0],OPTIONS_STR);
			exit(EXIT_CMD_LINE_ERR);
		}
	}

	/* update parameter list */

	pn = argv[0];         /* update parameter list */
	argc -= optind -1;
	argv += optind -1;

	/* check parameters */
	switch (argc) {
	case 1:     /* we have to read from standard input */
		lts_out = stdout;
		break;
	case 2:     /* we have an input file */
		in_file = argv[1];
		lts_out = stdout;
		break;
	case 3:         /* we have an input and a output file */
		in_file = argv[1];
		out_file = argv[2];
		break;
	default:
		fprintf(stderr,"usage: %s [-%s] [input-file [output-file]]\n",pn,OPTIONS_STR);
		exit(EXIT_CMD_LINE_ERR);
		break;
	}
 
	/* open input file */
	if (in_file) {
		pf = psf_fopen(in_file, suffixes);
		yyin = pf.fp;
		in_file = pf.name;
	}
 
	if (optverbose == TRUE) {
		version();
	}

	yyparse();

	if (optdebug == TRUE) dumpmap(stderr);
	if (optdump == TRUE) dump(stderr,netsp);

	if (errfc != 0) {
		exit(EXIT_SYNTAX_ERR);
	}

	/* open output file */
	if (!lts_out) {
		if ((lts_out = fopen(out_file,"w")) == NULL) {
			fprintf(stderr,"%s: can't open file \"%s\" for output\n",pn,out_file);
			exit(EXIT_IO_ERR);
		}
	}

	write_til_init();

	write_module(mod,lts_out);

	if (out_file) {
		if(fclose(lts_out) != 0) {                  /* close fc output file */
			fprintf(stderr,"%s: failed to close \"%s\"\n",pn,out_file);
			exit(EXIT_IO_ERR);
		}
	}
 
    	exit(EXIT_SUCCESS);
}
