#include "psf_prototype.h"
#include "psf_malloc.h"
#include "list.h"

list *createlist()
{
    list *l;

    l = PSF_MALLOC(list);
    l->cur_entry = -1;
    l->max_entry = 1;
    l->info = PSF_MALLOC(listitem);
    return (l);
}

void disposelist(l)
list *l;
{
    int i;

    if (l) {
	FORALL(l,i) {
	    PSF_FREE(getitem(l,i));
	}
	PSF_FREE(l->info);
	PSF_FREE(l);
    }
}
    
list *appendlist(l,i)
list *l;
listitem *i;
{
    list *m = l;

    if (m == NULL) {
	m = createlist();
    }

    if (m->cur_entry == m->max_entry-1) {
	m->max_entry *= 2;
	m->info = PSF_REALLOC(m->info,listitem,m->max_entry);
    }
    m->cur_entry++;
    m->info[m->cur_entry] = i;
    return (m);
}

int listcount(l)
list *l;
{
    if (l) {
	return (l->cur_entry + 1);
    } else {
	return (0);
    }
}

listitem *getitem(l,i)
list *l;
int i;
{
    if (i <= l->cur_entry) {
	return (l->info[i]);
    } else {
	return (NULL);
    }
}

list *appendintlist(i,l)
int i;
list *l;
{
    intlistitem *p = PSF_MALLOC(intlistitem);

    p->val = i;
    return (appendlist(l, (listitem) p));
}
