.TH "FC_LTS" 1L "July 13, 1993" "PSF-Toolkit"
.UC 4
.SH NAME
fc_lts \- translates a FC specification to LTS code.
.SH SYNOPSIS
.B fc_lts
[
.B \-hvs
] [
.I fc-file
[
.I lts-file
] ]
.SH DESCRIPTION
The program
.B fc_lts
tries to make LTS-code from a FC specification.
.B fc_lts
reads from the standard input or from
.I fc-file
if
.I fc-file
is given, and writes to the standard output or to
.I lts-file
if
.I lts-file
is given.
.BR
If no suffix is given to 
.I fc-file 
the suffix as defined by the environment
variable
.B FCSUFFIX
is used. The default
.IR .fc
is used if
.B FCSUFFIX 
is not set.
.SH OPTIONS
.TP 4n
.B \-h
displays a message explaining how to use the program.
.TP
.B \-v
puts the program in verbose mode.  In this mode the program shows the
version number and the name of the output file it is opening.
.TP
.B \-s
puts the generation of fc code in "shorthand" mode.  Normally non-abbrviated
fc statements are written.  When specifying this switch the abbreviated syntax
is used.
.SH EXIT STATUS
.TP 4n
0   EXIT_SUCCESS	no errors
.TP
1   EXIT_CMD_LINE_ERR	calling program with illegal arguments
.TP
2   EXIT_IO_ERR		file could not be opened
.TP
3   EXIT_SYNTAX_ERR     errors in input file
.TP
4   EXIT_MEM_ERR	memory allocation/deallocation error
.TP
5   EXIT_HELP		something really wrong
. SH SEE ALSO
.BR psf (1L)
.BR trans (1L)
.BR lts_fc (1L)
.SH AUTHOR
Peter Peters, Eindhoven University of Technology (pp@win.tue.nl)
.SH LIMITATIONS
.TP
Only single results for vertices are handled.
.TP
Vertices are assumed to be of type struct.
.TP
Edges are assumed to be of type behav.
.SH BUGS
.TP
Sure....
