%{

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "psf_exits.h"
#include "psf_malloc.h"
#include "main.h"
#include "expr.h"
#include "list.h"
#include "symtab.h"
#include "operator.h"
#include "tables.h"
#include "buildtil.h"

void yyerror PROTO_ARGS((char *s));

void message(s)
char *s;
{
    fprintf(stderr,"%s\n",s);
}

void fatalmessage(s)
char *s;
{
    message(s);
    exit(EXIT_SYNTAX_ERR);
}

void prologue()
{
    load_predef_op();
}
 
void epilogue()
{
    mod = PSF_MALLOC(tilmodule);
    init_module(mod);
    /* enter predefined til stuff */
    tiladm(netsp,mod);
/*
    tilsor(mod);
    tilfun(mod);
*/
    tilatm(netsp,mod);
    tilpro(netsp,mod);
    tildef(netsp,mod);
}

%}

%union	{
	int		intval;
	char		*string;
	list		*listitm;
	netstable	*netsitm;
	netitem		*netitm;
	vertexitem	*vertexitm;
	tableitem	*tableitm;
	labelitem	*labelitm;
	tlitem		*tlitm;
	tolitem		tolitm;
	tableentry	*tblentry;
	edgeitem	*edgeitm;  /* from tables.h */
	expr		*expitm;   /* from expr.h */
	list		*lst;      /* from list.h */
	domains		domitm;    /* from operator.h */
	}

%token <intval> ANY
%token <intval> ARROW
%token <intval> BEHAV		/* short b */
%token <intval> COLON
%token <intval> CONSTANT	/* predefined t,q,tau,quit */
%token <intval> CONSTANT_DECL	/* short C */
%token <intval> DECLARATIONS	/* short D */
%token <intval> EDGE		/* short e */
%token <intval> EDGES		/* short E */
%token <intval> HOOK		/* short h */
%token <string> IDENT
%token <intval> INFIX
%token <intval> INFIX5		/* predefined ; */
%token <intval> INFIX4		/* predefined + */
%token <intval> INFIX3		/* predefined > */
%token <intval> INFIX2		/* predefined < */
%token <intval> INFIX1		/* predefined , */
%token <intval> INFIX0		/* predefined . */
%token <intval> INFIX_DECL	/* short I */
%token <intval> INTEGER
%token <intval> LOGIC		/* short l */
%token <intval> NET		/* short n */
%token <intval> NETS		/* short N */
%token <intval>	PREFIX
%token <intval>	PREFIX_DECL	/* short P ? */
%token <intval> RESULT		/* short r */
%token <intval> RESULTS		/* short R */
%token <string> SYMBOL
%token <intval> TABLE_TYPE
	                	/* short forms: S, B, L, H */
       		         	/* long forms: structs, behavs, logics, hooks */
%token <intval> UNARY_DECL	/* short U */
%token <intval> VERTEX   	/* short v */
%token <intval> VERTICE		/* short V */
%token <intval> FCSTAR
%token <string> STRING
%token <intval> STRUCT   	/* short S */
%token <intval> UNARY    	/* predefined ! ? ~  */
%token <intval> VERSION
%token <intval> OP CP REF MINUS INDIRECT
%token <intval> END_OF_FILE

%token <intval> STRUCTS BEHAVS LOGICS HOOKS

/* associative: */
%left INFIX
%left INFIX5
%left INFIX4
%left INFIX3
%left INFIX2
%left INFIX1
%left INFIX0
%nonassoc UNARY

%token <intval>	UNDEF

%type  <string>    decl_token
%type  <intval>    decl_class type declaration index_shift
%type  <lst>       types
%type  <domitm>    decl_type
%type  <netsitm>   nets
%type  <listitm>   net_list vertice_entry vertice edges edge_entry_list
%type  <listitm>   exps_entries exps_entry_list label field_label_list
%type  <listitm>   edge_table
%type  <netitm>    net
%type  <vertexitm> vertex_entry
%type  <labelitm>  field_label
%type  <expitm>    exp ref hook_name results
%type  <edgeitm>   edge_entry
%type  <tlitm>     tables_and_labels
%type  <tolitm>    table_or_label
%type  <tblentry>  exp_entry

%start code_file
%%

code_file: 
	{ prologue(); }
	version
	declarations
	nets
	{ netsp = $4;
	  epilogue();
	}
/*	END_OF_FILE */
	;

version:
	VERSION STRING {}
	|
	/* Empty */
	;

declarations:
	/* EMPTY */
	|
	DECLARATIONS 
	declaration_list {}
	;

declaration_list:
	declaration {}
	|
	declaration_list declaration
	;

declaration:
	decl_class 
	decl_token 
	decl_type
	{ $$ = install_op( $2, $1, $3.domain, $3.codomain); }
	;

decl_class:
	UNARY_DECL
	{ $$ = UNARY; }
	|
	INFIX_DECL
	{ $$ = INFIX; }
	|
	CONSTANT_DECL
	{ $$ = CONSTANT; }
	|
	PREFIX_DECL
	{ $$ = PREFIX; }
	;

decl_token:
	IDENT
	{ $$ = $1; }
	|
	SYMBOL
	{ $$ = $1; }
	;

decl_type:
	OP 
	types 
	CP 
	ARROW 
	type
	{ $$.domain = $2; $$.codomain = $5; }
	;

types :
	/* EMPTY */
	{ $$ = NULL; }
        |
	types type
	{ $$ = appendintlist($2,$1); }
      ;

type :
	BEHAV
	{ $$ = BEHAV; }
	|
	STRUCT
	{ $$ = STRUCT; }
	|
	LOGIC 
	{ $$ = LOGIC; }
	|
	HOOK 
	{ $$ = HOOK; }
	|
	ANY
	{ $$ = ANY; }
	;

nets:
	/* EMPTY */
	{ $$ = NULL; }
	|
	NETS INTEGER
	tables_and_labels
	net_list
	{ if ($2 != listcount($4)) {
	      fatalmessage("specified/required number of nets do not match.");
	  }
	  $$ = createnetstable($3,$4);
	}
	;

net_list:
	net
	{ $$ = addnetitem(NULL,$1); }
	|
	net_list net
	{ $$ = addnetitem($1,$2); }
	;

net:
	NET 
	tables_and_labels
	vertice_entry
	{ $$ = createnetitem(-1,$2,$3); } 
	|
	NET INTEGER 
	tables_and_labels
	vertice_entry
	{ $$ = createnetitem($2,$3,$4); } 
	;

vertice_entry:
	VERTICE INTEGER
	vertice
	{ if ($2 != listcount($3)) {
	      fatalmessage("specified/required number of vertices do not match.");
	  }
	  $$ = $3;
	}
	;

tables_and_labels:
	/* EMPTY */ 
	{ $$ = NULL; }
	|
	tables_and_labels table_or_label
	{ tlitem *tl = $1;

	  if (tl == NULL) {
	    tl = createtlitem();
	  }
	  if ($2.typ == TABLE) {
	    tl->tab = addtableitem(tl->tab,$2.tab);
	  } else {
	    if ($2.typ = LABEL) {
	      tl->lab = addlabelitem(tl->lab,$2.lab);
	    }
	  }
	  $$ = tl;
	}
	;

/**********************/
/* Expressions Tables */

table_or_label:  
	TABLE_TYPE
	INDIRECT index_shift
	{ $$.typ = TABLE;
	  $$.tab = createtableitem($1,INDIRECT,$3,NULL);
	}
	|
	TABLE_TYPE
	INTEGER
	exps_entries
	{ if ($2 != listcount($3)) {
	      /* message("specified/required number of vertices do not match."); */
	  }
	  $$.typ = TABLE;
	  $$.tab = createtableitem($1,DIRECT,0,$3);
	}
	|
	field_label
	{ $$.typ = LABEL;
	  $$.lab = $1;
	}
	;

exps_entries:
	exps_entry_list 
	{ $$ = $1; }
	|
	exps_entry_list 
	INDIRECT index_shift
	{ $$ = addexpentry($1,makeexp(INDIRECT,NULL,NULL,$3)); }
	;

index_shift:
	/* EMPTY */
	{ $$ = 0; }
	|
	INTEGER
	{ $$ = $1; }
	|
	MINUS INTEGER
	{ $$ = -$1; }
	;

exps_entry_list:
	exp_entry
	{ $$ = addexpentry(NULL, (expr *) $1); }
	|
	exps_entry_list exp_entry
	{ $$ = addexpentry($1, (expr *) $2); }
	;

exp_entry:
	exp
	{ $$ = createtableentry(-1,$1); }
	|
	COLON INTEGER 
	exp 
	{ $$ = createtableentry($2,$3); }
	;

exp :
	CONSTANT 
	{ $$ = makeexp( CONSTANT,NULL,NULL,$1 ); }
	|
	PREFIX exp
	{ $$ = makeexp( PREFIX,$2,NULL,$1 ); }
	|
	UNARY exp
	{ $$ = makeexp( UNARY,$2,NULL,$1 ); }
	|
	exp INFIX exp
	{ $$ = makeexp( INFIX,$1,$3,$2 ); }
	|
	exp INFIX5 exp
	{ $$ = makeexp( INFIX5,$1,$3,$2 ); }
	|
	exp INFIX4 exp
	{ $$ = makeexp( INFIX4,$1,$3,$2 ); }
	|
	exp INFIX3 exp
	{ $$ = makeexp( INFIX3,$1,$3,$2 ); }
	|
	exp INFIX2 exp
	{ $$ = makeexp( INFIX2,$1,$3,$2 ); }
	|
	exp INFIX1 exp
	{ $$ = makeexp( INFIX1,$1,$3,$2 ); }
	|
	exp INFIX0 exp
	{ $$ = makeexp( INFIX0,$1,$3,$2 ); }
	|
	OP exp CP		
	{ $$ = $2; }
	|
	STRING		
	{ $$ = makeexp( STRING,NULL,NULL,inmap($1,STRING) ); }
	|
	FCSTAR		
	{ $$ = makeexp( FCSTAR,NULL,NULL,$1 ); }
	|
	ref              
	{ $$ = $1; }
	;

/***************************/
/* Labels and their fields */

label:
	field_label_list
	{ $$ = $1; }
	;
	
field_label_list:
	/* EMPTY */
	{ $$ = NULL; }
	|
	field_label_list field_label
	{ $$ = addlabelitem($1,$2); }
	;

field_label:
	STRUCT exp	
	{ $$ = createlabelitem(STRUCT,$2); }
	|
	BEHAV exp		
	{ $$ = createlabelitem(BEHAV,$2); }
	|
	LOGIC exp		
	{ $$ = createlabelitem(LOGIC,$2); }
	|
	HOOK exp	
	{ $$ = createlabelitem(HOOK,$2); }
        ;

ref:
	INTEGER     
	{ $$ = makeexp( INTEGER,NULL,NULL,$1 ); }
	|
	REF ref 
	{ $$ = makeexp( REF,(expr *) $1,NULL,0 ); }
	;

hook_name:
	STRING 
	{ $$ = makeexp( STRING, NULL, NULL, inmap($1,STRING) ); }
	|
	ref	   
	{ $$ = $1; }
	;

/*********************/
/* Edge Tables */

vertice:
	vertex_entry
	{ $$ = addvertexitem(NULL,$1); }
	|
	vertice vertex_entry
	{ $$ = addvertexitem($1,$2); }
	;

vertex_entry:
	VERTEX INTEGER 
	label 
	edge_table
	{ $$ = createvertexitem($2,$3,$4); }
	|
	VERTEX 
	label 
	edge_table
	{ $$ = createvertexitem(-1,$2,$3); }
	;

edge_table:
	EDGES INTEGER
	edges
	{ if ($2 != listcount($3)) {
	      /* message("specified/required number of edges do not match."); */
	  }
	  $$ = $3;
	}
	;

edges:
	/* EMPTY */
	{ $$ = NULL; }
	| edge_entry_list
	{ $$ = $1; }
	;

edge_entry_list:
	edge_entry
	{ $$ = addedgeitem(NULL,$1); }
	|
	edge_entry_list
	edge_entry
	{ $$ = addedgeitem($1,$2); }
	;

edge_entry:
	label results
	{ $$ = createedgeitem(-1,$1,$2); }
	|
	edge_key label results
	{ $$ = createedgeitem(-1,$2,$3); }
	|
	edge_key INTEGER label results
	{ $$ = createedgeitem($2,$3,$4); }
	;

results:
	RESULTS INTEGER opt_arrow exp
	{ $$ = $4; }
	| result exp
	{ $$ = $2; }
	| result
	{ $$ = NULL; }
	;

opt_arrow
	: /* EMPTY */
	|
	ARROW {}
	;

result:
	ARROW {}
	|
	RESULT {}
	;

edge_key:
	COLON {}
	|
	EDGE {}
	;
%%

#include "lex.yy.c"
