symbols		[,\./;'`<>\?:~\[\]\{\}\-_=\+!#\$\^\|\\@&\(\)]
special_symbol  [%\*\"]
digits		[0-9]
letters		[a-zA-Z]
stringchar	[^\"]

int		{digits}+
string		\"{stringchar}*\"
ident		{letters}+
star		(\* | \*{int})

%%
"%"			{ while (input()!='\n') ; }
[ \t\n]			;
"->"			return(ARROW);

version			return(VERSION);

any			return(ANY);

b			|
behav			return(BEHAV);

B			|
behavs			{ yylval.intval = BEHAV; return(TABLE_TYPE); }

C			|
constant		return(CONSTANT_DECL);

D			|
declarations		return(DECLARATIONS);

e			|
edge			return(EDGE);

E 			|
edges			return(EDGES);

g			|
graph			return(NET);

G 			|
graphs			return(NETS);

h			|
hook			return(HOOK);

H			|
hooks			{ yylval.intval = HOOK; return(TABLE_TYPE); }

i			|
indirect		return(INDIRECT);

I			|
infix			return(INFIX_DECL); 

l			|
logic			return(LOGIC);

L			|
logics			{ yylval.intval = LOGIC; return(TABLE_TYPE); }

n			|
net 			return(NET);

N			|
nets 			return(NETS);

P 			|
prefix			return(PREFIX_DECL);

r 			|
result 			return(RESULT);

R			|
results			return(RESULTS);

U			|
unary			return(UNARY_DECL);

v			|
vertex			return(VERTEX);

V			|
vertice			return(VERTICE);

s			|
struct 			return(STRUCT);

S 			|
structs			{ yylval.intval= STRUCT; return(TABLE_TYPE); }

- 			return(MINUS);
: 			return(COLON);
\( 			return(OP);
\) 			return(CP);
& 			return(INDIRECT);
@ 			return(REF);

\*			{ 	yylval.intval = 1; return(FCSTAR); }
\*{int}			{	sscanf(yytext, "%d", &yylval.intval); return(FCSTAR); }

{string}		{ 	
				yylval.string = PSF_NMALLOC(char,yyleng-1);
			  	yytext[yyleng-1]='\0';
			  	strcpy(yylval.string, &yytext[1]);
				return(STRING);
			}

{int}			{ 
				sscanf(yytext, "%d", &yylval.intval); 
				return(INTEGER); 
			}

{symbols}		{
				int	     ind;
				int	    type;

				type = find_operator(yytext, &ind);
				switch (type) {
				case CONSTANT: yylval.intval = ind; return(CONSTANT);
				case UNARY   : yylval.intval = ind; return(UNARY);
				case PREFIX  : yylval.intval = ind; return(PREFIX);
				case INFIX   : yylval.intval = ind; return(INFIX);
				case INFIX0  : yylval.intval = ind; return(INFIX0);
				case INFIX1  : yylval.intval = ind; return(INFIX1);
				case INFIX2  : yylval.intval = ind; return(INFIX2);
				case INFIX3  : yylval.intval = ind; return(INFIX3);
				case INFIX4  : yylval.intval = ind; return(INFIX4);
				case INFIX5  : yylval.intval = ind; return(INFIX5);
				case UNDEF   : yylval.string = PSF_NMALLOC(char,yyleng+1);
						  strcpy(yylval.string, yytext);
						  return (SYMBOL);
				}
			}


{ident}			{
				int	     ind;
				int	    type;

				type = find_operator(yytext, &ind);
				switch(type) {
				case CONSTANT: yylval.intval = ind; return(CONSTANT);
				case PREFIX  : yylval.intval = ind; return(PREFIX);
				case UNARY   : yylval.intval = ind; return(UNARY);
				case INFIX   : yylval.intval = ind; return(INFIX);
				case INFIX0  : yylval.intval = ind; return(INFIX0);
				case INFIX1  : yylval.intval = ind; return(INFIX1);
				case INFIX2  : yylval.intval = ind; return(INFIX2);
				case INFIX3  : yylval.intval = ind; return(INFIX3);
				case INFIX4  : yylval.intval = ind; return(INFIX4);
				case INFIX5  : yylval.intval = ind; return(INFIX5);
				case UNDEF   : yylval.string = PSF_NMALLOC(char,yyleng+1);
					       strcpy(yylval.string, yytext);
					       return(IDENT);
				}
			}
%%

void yyerror(s)
char *s;
{
	fprintf(stderr,"Error in line %d, at token \"%s\".\n", yylineno, yytext);
}
 
int yywrap()
{
	if (yyin != stdin) {
		fclose (yyin);
		yyin = stdin;
	}
	return (1);
}
