#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf_malloc.h"
#include "util.h"
#include "symtab.h"
#include "lexyacc.h"

expr *makeexp(op,arg1,arg2,val)
int op;
expr *arg1;
expr *arg2;
int val;
{
  expr *temp;

  temp = PSF_MALLOC(expr);
  temp->operator = op;
  temp->left = arg1;
  temp->right = arg2;
  temp->value = val;
  return (temp);
}

int countexp(e)
expr *e;
{
  if (e) {
    if ((e->left) || (e->right)) {
      return (countexp(e->left) + countexp(e->right));
    } else {
      return (1);
    }
  }
  return(-1); /* should not happen */
}

char *strexpr(e)
expr *e;
{
    char *r = NULL;
    char *s = PSF_NMALLOC(char,255);
    char *s1 = NULL;

    *s = '\0';
    if (e) {
	switch (e->operator) {
	case INTEGER:
	    sprintf(s,"%d",e->value);
	    break;
	case INDIRECT:
	    sprintf(s,"&%d",e->value);
	    break;
	case REF:
	    sprintf(s,"@");
	    s1 = strexpr(e->left);
	    strcat(s,s1);
	    PSF_FREE(s1);
	    break;
	case CONSTANT:
	    strcat(s,map[e->value].text);
	    break;
	case STRING:
	    strcat(s,map[e->value].text);
	    break;
	case UNARY:
	    strcat(s,map[e->value].text);
	    s1 = strexpr(e->left);
	    strcat(s,s1);
	    PSF_FREE(s1);
	    break;
	case PREFIX:
	    strcat(s,map[e->value].text);
	    s1 = strexpr(e->left);
	    strcat(s,s1);
	    PSF_FREE(s1);
	    if (e->right) {
		strcat(s,",");
		s1 = strexpr(e->right);
		strcat(s,s1);
		PSF_FREE(s1);
	    }
	    strcat(s,")");
	    break;
	case INFIX:
	case INFIX0:
	case INFIX1:
	case INFIX2:
	case INFIX3:
	case INFIX4:
	case INFIX5:
	    sprintf(s,"(");
	    s1 = strexpr(e->left);
	    strcat(s,s1);
	    PSF_FREE(s1);
	    strcat(s,map[e->value].text);
	    s1 = strexpr(e->right);
	    strcat(s,s1);
	    PSF_FREE(s1);
	    strcat(s,")");
	    break;
	case FCSTAR:
	    strcat(s,"*");
	    if (e->value > 1) {
		s1 = PSF_NMALLOC(char,255);
		sprintf(s1,"%d",e->value);
		strcat(s,s1);
		PSF_FREE(s1);
	    }
	    break;
	default:
	    fprintf(stderr,"UNKNOWN EXPRESSION TYPE\n");
	    exit(1);
	}
	r = strfit(s);
	PSF_FREE(s);
    }
    return (r);
}

char *qstrexpr(e)
expr *e;
{
    char *se = NULL;

    if (e) {
	se = strexpr(e);
	if (e->operator == STRING) {
	    char *s = PSF_NMALLOC(char,strlen(se)+3);
	    sprintf(s,"\"%s\"",se);
	    PSF_FREE(se);
	    se = s;
	}
    }
    return (se);
}

int eval(e)
expr *e;
{

    if (e) {
	switch (e->operator) {
	case INDIRECT:
	case INTEGER:
	case REF:
	    return(e->value);
	default:
	    fprintf(stderr,"Illegal expression operator type in eval.\n");
	    exit(EXIT_HELP);
	}
    } else {
	fprintf(stderr,"NULL reference in eval\n");
	exit(EXIT_HELP);
    }
}
