#ifndef BUILDTIL_H
#define BUILDTIL_H

#include "tiltype.h"
#include "tables.h"
#include "operator.h"

typedef struct indextype INDEXTYPE;
typedef struct indexlist INDEXLIST;
typedef struct process_expr PROCESS_EXPR;

/* buildtil.c */
extern unsigned int max_entries[MTABLE];

extern void init_module PROTO_ARGS((tilmodule *mod));
extern void enlarge_entries PROTO_ARGS((tabletype tnr, tilmodule *mod));
extern unsigned int current_entry PROTO_ARGS((tabletype tnr, tilmodule *mod));
extern unsigned int add_entry PROTO_ARGS((tabletype tnr, tilmodule *mod));
extern void tilsor PROTO_ARGS((tilmodule *mod));
extern char *netname PROTO_ARGS((netitem *n));
extern void tiladm PROTO_ARGS((netstable *n, tilmodule *mod));
extern int sortindex PROTO_ARGS((int t));
extern void fill_fun_entry PROTO_ARGS((int i, unsigned int j, opentry *e));
extern void tilfun PROTO_ARGS((tilmodule *mod));
extern void tilatmadd PROTO_ARGS((tableentry *e, int o, tilmodule *mod));
extern void tilatmpertable PROTO_ARGS((tableitem *t, int o, tilmodule *mod));
extern void tilatm PROTO_ARGS((netstable *n, tilmodule *mod));
extern int tilproadd PROTO_ARGS((tableentry *e, int o, tilmodule *mod));
extern void tilpropertable PROTO_ARGS((tableitem *t, int o, tilmodule *mod));
extern void tilpro PROTO_ARGS((netstable *n, tilmodule *mod));
extern INDEXTYPE *localtableindex PROTO_ARGS((list *l, expr *e, int t, int *ofs));
extern INDEXTYPE *tableindex PROTO_ARGS((list *gt, list *lt, list *vlt, expr *e, int t));
extern INDEXTYPE *labelindex PROTO_ARGS((list *gt, list *lt, list *vlt, list *l, int t));
extern INDEXTYPE *vertexindex PROTO_ARGS((netitem *n, list *gt, list *lt, list *vlt, expr *e));
extern INDEXLIST *vertexlist PROTO_ARGS((netitem *n, list *gt, list *lt, list *vlt, expr *e, INDEXLIST *l));
extern void tildef PROTO_ARGS((netstable *n, tilmodule *mod));

#endif
